/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyEditor;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigris.gef.properties.ui.PropertyDialog;

class PropertyCanvas
extends JPanel
implements MouseListener {
    private static boolean ignoreClick = false;
    private JFrame frame;
    private PropertyEditor editor;

    public PropertyCanvas(JFrame jFrame, PropertyEditor propertyEditor) {
        this.frame = jFrame;
        this.editor = propertyEditor;
        this.addMouseListener(this);
    }

    @Override
    public void paint(Graphics graphics) {
        Rectangle rectangle = new Rectangle(2, 2, this.getSize().width - 4, this.getSize().height - 4);
        this.editor.paintValue(graphics, rectangle);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(80, 20);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(80, 20);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!ignoreClick) {
            try {
                ignoreClick = true;
                int n2 = this.frame.getLocation().x - 30;
                int n3 = this.frame.getLocation().y + 50;
                new PropertyDialog(this.frame, this.editor, n2, n3);
                return;
            }
            finally {
                ignoreClick = false;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

