/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.ui;

import java.awt.event.MouseListener;
import java.util.Date;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import org.tigris.gef.ui.TableMap;
import org.tigris.gef.ui.TableSorter$1;

public class TableSorter
extends TableMap {
    int[] indexes;
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    int compares;

    public TableSorter() {
        this.indexes = new int[0];
    }

    public TableSorter(TableModel tableModel) {
        this.setModel(tableModel);
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.reallocateIndexes();
    }

    public int compareRowsByColumn(int n2, int n3, int n4) {
        String string;
        Class<?> clazz = this.model.getColumnClass(n4);
        TableModel tableModel = this.model;
        Object object = tableModel.getValueAt(n2, n4);
        Object object2 = tableModel.getValueAt(n3, n4);
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (clazz.getSuperclass() == Number.class) {
            double d2;
            double d3 = ((Number)tableModel.getValueAt(n2, n4)).doubleValue();
            if (d3 < (d2 = ((Number)tableModel.getValueAt(n3, n4)).doubleValue())) {
                return -1;
            }
            if (d3 > d2) {
                return 1;
            }
            return 0;
        }
        if (clazz == Date.class) {
            long l2;
            long l3 = ((Date)tableModel.getValueAt(n2, n4)).getTime();
            if (l3 < (l2 = ((Date)tableModel.getValueAt(n3, n4)).getTime())) {
                return -1;
            }
            if (l3 > l2) {
                return 1;
            }
            return 0;
        }
        if (clazz == String.class) {
            String string2;
            String string3 = (String)tableModel.getValueAt(n2, n4);
            int n5 = string3.compareTo(string2 = (String)tableModel.getValueAt(n3, n4));
            if (n5 < 0) {
                return -1;
            }
            if (n5 > 0) {
                return 1;
            }
            return 0;
        }
        if (clazz == Boolean.class) {
            int n6 = ((Boolean)tableModel.getValueAt(n2, n4)).booleanValue();
            if (n6 == (n2 = (int)(((Boolean)tableModel.getValueAt(n3, n4)).booleanValue() ? 1 : 0))) {
                return 0;
            }
            if (n6 != 0) {
                return 1;
            }
            return -1;
        }
        String string4 = tableModel.getValueAt(n2, n4).toString();
        int n7 = string4.compareTo(string = tableModel.getValueAt(n3, n4).toString());
        if (n7 < 0) {
            return -1;
        }
        if (n7 > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int n2, int n3) {
        ++this.compares;
        for (int i2 = 0; i2 < this.sortingColumns.size(); ++i2) {
            Integer n4 = (Integer)this.sortingColumns.elementAt(i2);
            int n5 = this.compareRowsByColumn(n2, n3, n4);
            if (n5 == 0) continue;
            if (this.ascending) {
                return n5;
            }
            return -n5;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int n2 = this.model.getRowCount();
        this.indexes = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.indexes[i2] = i2;
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.reallocateIndexes();
        super.tableChanged(tableModelEvent);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            System.err.println("Sorter not informed of a change in model.");
        }
    }

    public void sort(Object object) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void n2sort() {
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            for (int i3 = i2 + 1; i3 < this.getRowCount(); ++i3) {
                if (this.compare(this.indexes[i2], this.indexes[i3]) != -1) continue;
                this.swap(i2, i3);
            }
        }
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n2, int n3) {
        if (n3 - n2 < 2) {
            return;
        }
        int n4 = (n2 + n3) / 2;
        this.shuttlesort(nArray2, nArray, n2, n4);
        this.shuttlesort(nArray2, nArray, n4, n3);
        int n5 = n2;
        int n6 = n4;
        if (n3 - n2 >= 4 && this.compare(nArray[n4 - 1], nArray[n4]) <= 0) {
            while (n2 < n3) {
                nArray2[n2] = nArray[n2];
                ++n2;
            }
            return;
        }
        while (n2 < n3) {
            nArray2[n2] = n6 >= n3 || n5 < n4 && this.compare(nArray[n5], nArray[n6]) <= 0 ? nArray[n5++] : nArray[n6++];
            ++n2;
        }
    }

    public void swap(int n2, int n3) {
        int n4 = this.indexes[n2];
        this.indexes[n2] = this.indexes[n3];
        this.indexes[n3] = n4;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[n2], n3);
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        this.checkModel();
        this.model.setValueAt(object, this.indexes[n2], n3);
    }

    public void sortByColumn(int n2) {
        this.sortByColumn(n2, true);
    }

    public void sortByColumn(int n2, boolean bl2) {
        this.ascending = bl2;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(n2));
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        EventListener eventListener = this;
        jTable.setColumnSelectionAllowed(false);
        eventListener = new TableSorter$1(this, jTable, (TableSorter)eventListener);
        jTable.getTableHeader().addMouseListener((MouseListener)eventListener);
    }
}

