/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.vp_pda.v4;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import ro.atreides.vp_pda.v4.Config3;
import ro.atreides.vp_pda.v4.Location3;
import ro.atreides.vp_pda.v4.PdaLogic3;
import ro.atreides.vp_pda.v4.TablesPanel;

public class LocationsPanel {
    public LocationsPanel(final Shell parentShell, final PdaLogic3 logic) {
        int close = Config3.closeMode ? 80 : 0;
        final Shell locationsShell = new Shell(parentShell, close);
        Iterator loc = logic.getLocations().iterator();
        final Table table = new Table((Composite)locationsShell, 2560);
        table.setLinesVisible(true);
        int columnCount = 2;
        for (int i = 0; i < 2; ++i) {
            TableColumn column = new TableColumn(table, 0);
            column.setText("________");
        }
        final Hashtable<String, Location3> positions = new Hashtable<String, Location3>();
        int i = 0;
        while (loc.hasNext()) {
            TableItem item = new TableItem(table, 0);
            Font initialFont = item.getFont();
            FontData[] fontData = initialFont.getFontData();
            for (int k = 0; k < fontData.length; ++k) {
                fontData[k].setHeight(Config3.selectorFontSize);
            }
            Font newFont = new Font((Device)parentShell.getDisplay(), fontData);
            item.setFont(newFont);
            for (int j = 0; j < 2 && loc.hasNext(); ++j) {
                Location3 loco = (Location3)loc.next();
                item.setText(j, loco.getLabel());
                positions.put(i + "_" + j, loco);
            }
            if (!loc.hasNext()) break;
            ++i;
        }
        for (i = 0; i < 2; ++i) {
            table.getColumn(i).pack();
        }
        table.pack();
        table.setBounds(0, 21, 240, 280);
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = table.getClientArea();
                Point pt = new Point(event.x, event.y);
                boolean stop = false;
                for (int index = table.getTopIndex(); !stop && index < table.getItemCount(); ++index) {
                    boolean visible = false;
                    TableItem item = table.getItem(index);
                    for (int i = 0; i < 2; ++i) {
                        Location3 loco;
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt) && (loco = (Location3)positions.get(index + "_" + i)) != null) {
                            logic.setLocatie(loco);
                            new TablesPanel(parentShell, logic);
                            locationsShell.close();
                            stop = true;
                            break;
                        }
                        if (visible || !rect.intersects(clientArea)) continue;
                        visible = true;
                    }
                    if (visible) continue;
                    return;
                }
            }
        });
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        event.height = Config3.meseRowSize;
                    }
                }
            }
        };
        table.addListener(41, paintListener);
        table.addListener(42, paintListener);
        locationsShell.setSize(240, Config3.dY);
        locationsShell.open();
    }
}

