/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import ro.deversoft.odf.gearbox.common.OperationResult;
import ro.deversoft.odf.gearbox.common.OperationResultResponseDDD;
import ro.deversoft.odf.gearbox.common.domain.CurrencyDDD;
import ro.deversoft.odf.gearbox.common.enums.CurrencyType;
import ro.deversoft.odf.gearbox.common.exception.ODFRuntimeException;

public final class CommonUtils {
    static ObjectMapper objectMapper = new ObjectMapper();

    public static String humanReadableFileSize(long fileSize, boolean evaluate) {
        return evaluate ? CommonUtils.humanReadableFileSize(fileSize) : "<file size not evaluated>";
    }

    public static String humanReadableFileSize(long fileSize) {
        if (fileSize < 0L) {
            throw new ODFRuntimeException("Negative fileSize, therefor it is invalid !");
        }
        if (fileSize < 1024L) {
            return String.format("%,d bytes", fileSize);
        }
        if (fileSize < 0x100000L) {
            return String.format("%,d kb", fileSize / 1024L);
        }
        return String.format("%,d mb", fileSize / 1024L * 1024L);
    }

    public static boolean isMapNullOrEmtpy(Map map, Object key) {
        return map == null || map.get(key) == null;
    }

    public static JsonNode buildEmptyJsonNode() {
        try {
            return new ObjectMapper().readTree("{}");
        }
        catch (JsonProcessingException jsonProcessingException) {
            return null;
        }
    }

    public static String getNotNullString(String value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String getNotNullString(String value) {
        return CommonUtils.getNotNullString(value, "");
    }

    public static double roundDoubleUp(double toRound, int scale) {
        try {
            BigDecimal bigDecimal = BigDecimal.valueOf(toRound).setScale(scale + 4, RoundingMode.HALF_UP);
            double res1 = bigDecimal.doubleValue();
            BigDecimal bd2 = BigDecimal.valueOf(res1).setScale(scale, RoundingMode.HALF_UP);
            double res2 = bd2.doubleValue();
            return res2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return toRound;
        }
    }

    public static CurrencyDDD buildLoyaltyPointsCurrency() {
        return new CurrencyDDD().setCode("LP").setCurrencyType(CurrencyType.INTERNAL).setDescription("Loyalty Points");
    }

    public static CurrencyDDD buildExperienceCurrency() {
        return new CurrencyDDD().setCode("XP").setCurrencyType(CurrencyType.INTERNAL).setDescription("Experience Points");
    }

    public static JsonNode getDetailsJsonNode(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        return objectMapper.valueToTree(map);
    }

    public static OperationResultResponseDDD returnError(String error) {
        return OperationResultResponseDDD.builder().setOperationResult(OperationResult.FAIL).setOperationResultDesc(error).setAdditionalInfos(CommonUtils.getDetailsJsonNode("Error", error)).build();
    }

    public static OperationResultResponseDDD returnOk() {
        return OperationResultResponseDDD.builder().setOperationResult(OperationResult.OK).setOperationResultDesc("OK").build();
    }

    public static Map<String, Object> buildDefaultFormatterMapForOperatorTasks(String tableName, String zoneName, LocalDateTime requestDate) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("table", tableName);
        res.put("zone", zoneName);
        res.put("hour", requestDate.format(DateTimeFormatter.ISO_LOCAL_TIME));
        return res;
    }

    public static void addMaxINTIfEmptyList(List<Integer> list) {
        if (list.size() == 0) {
            list.add(Integer.MAX_VALUE);
        }
    }

    public static void addRandomUUIDIfEmptyList(List<String> list) {
        if (list.size() == 0) {
            list.add(UUID.randomUUID().toString());
        }
    }

    private CommonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

