/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.UUID;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODFId
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ODFId.class);
    private String uuidValue;

    public static ODFId generateNew() {
        return new ODFId();
    }

    public static ODFId of(String uuidValue) {
        return new ODFId(uuidValue);
    }

    private ODFId() {
        this.uuidValue = UUID.randomUUID().toString();
    }

    public ODFId(@NonNull String uuidValue) {
        if (uuidValue == null) {
            throw new NullPointerException("uuidValue is marked non-null but is null");
        }
        this.uuidValue = this.checkValidUUID(uuidValue);
    }

    private String checkValidUUID(String uuidValue) {
        try {
            return UUID.fromString(uuidValue).toString();
        }
        catch (IllegalArgumentException e) {
            if (uuidValue != null && uuidValue.length() >= 16) {
                String s2 = uuidValue.replace("-", "");
                UUID uuid = new UUID(new BigInteger(s2.substring(0, 16), 16).longValue(), new BigInteger(s2.substring(16), 16).longValue());
                if (uuid.toString().equalsIgnoreCase(uuidValue)) {
                    return uuid.toString();
                }
            } else if (uuidValue != null && uuidValue.length() == 0) {
                log.error("UUID LENGTH 0", (Throwable)e);
            }
            throw e;
        }
    }

    public ODFId setUuidValue(@NonNull String uuidValue) {
        if (uuidValue == null) {
            throw new NullPointerException("uuidValue is marked non-null but is null");
        }
        this.uuidValue = this.checkValidUUID(uuidValue);
        return this;
    }

    public static ODFIdBuilder builder() {
        return new ODFIdBuilder();
    }

    public String getUuidValue() {
        return this.uuidValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODFId)) {
            return false;
        }
        ODFId other = (ODFId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uuidValue = this.getUuidValue();
        String other$uuidValue = other.getUuidValue();
        return !(this$uuidValue == null ? other$uuidValue != null : !this$uuidValue.equals(other$uuidValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ODFId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uuidValue = this.getUuidValue();
        result = result * 59 + ($uuidValue == null ? 43 : $uuidValue.hashCode());
        return result;
    }

    public String toString() {
        return "ODFId(uuidValue=" + this.getUuidValue() + ")";
    }

    public static class ODFIdBuilder {
        private String uuidValue;

        ODFIdBuilder() {
        }

        public ODFIdBuilder setUuidValue(String uuidValue) {
            this.uuidValue = uuidValue;
            return this;
        }

        public ODFId build() {
            return new ODFId(this.uuidValue);
        }

        public String toString() {
            return "ODFId.ODFIdBuilder(uuidValue=" + this.uuidValue + ")";
        }
    }
}

