/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import ro.deversoft.odf.gearbox.common.domain.MeasurementUnitSystemEnum;

public class MeasurementUnitDDD
implements Serializable {
    private String symbol;
    private String description;
    private MeasurementUnitSystemEnum unitSystem;

    public static Map<String, MeasurementUnitDDD> getAllAvailableUnits() {
        Map<String, MeasurementUnitDDD> result = Collections.synchronizedMap(new LinkedHashMap());
        MeasurementUnitDDD kg = new MeasurementUnitDDD("Kg", "Kilogram", MeasurementUnitSystemEnum.METRIC);
        result.put(kg.getSymbol(), kg);
        MeasurementUnitDDD L = new MeasurementUnitDDD("L", "Liter", MeasurementUnitSystemEnum.METRIC);
        result.put(L.getSymbol(), L);
        MeasurementUnitDDD buc = new MeasurementUnitDDD("Buc", "Bucati", MeasurementUnitSystemEnum.INHOUSE);
        result.put(buc.getSymbol(), buc);
        return result;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getDescription() {
        return this.description;
    }

    public MeasurementUnitSystemEnum getUnitSystem() {
        return this.unitSystem;
    }

    public MeasurementUnitDDD(String symbol, String description, MeasurementUnitSystemEnum unitSystem) {
        this.symbol = symbol;
        this.description = description;
        this.unitSystem = unitSystem;
    }

    public MeasurementUnitDDD() {
    }

    public MeasurementUnitDDD setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public MeasurementUnitDDD setDescription(String description) {
        this.description = description;
        return this;
    }

    public MeasurementUnitDDD setUnitSystem(MeasurementUnitSystemEnum unitSystem) {
        this.unitSystem = unitSystem;
        return this;
    }
}

