/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.deversoft.odf.gearbox.common.ODFId;

public class ODFIdListDDD {
    private static final Logger log = LoggerFactory.getLogger(ODFIdListDDD.class);
    List<ODFId> list = new ArrayList<ODFId>();

    @JsonIgnore
    public void addItem(ODFId add) {
        this.list.add(add);
    }

    @JsonIgnore
    public void addItemIfNotExists(ODFId add) {
        if (!this.list.contains(add)) {
            this.addItem(add);
        }
    }

    @JsonIgnore
    public String[] getAsStringArray() {
        List<String> collect = this.getAsStringList();
        return collect.toArray(new String[0]);
    }

    @JsonIgnore
    public List<String> getAsStringList() {
        return this.list.stream().map(ODFId::getUuidValue).collect(Collectors.toList());
    }

    @JsonIgnore
    public ODFIdListDDD sort() {
        Collections.sort(this.list, new Comparator<ODFId>(){

            @Override
            public int compare(ODFId odfId, ODFId t1) {
                return odfId.getUuidValue().compareToIgnoreCase(t1.getUuidValue());
            }
        });
        return this;
    }

    public void clear() {
        this.list.clear();
    }

    public List<ODFId> getList() {
        return this.list;
    }

    public ODFIdListDDD setList(List<ODFId> list) {
        this.list = list;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODFIdListDDD)) {
            return false;
        }
        ODFIdListDDD other = (ODFIdListDDD)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ODFId> this$list = this.getList();
        List<ODFId> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ODFIdListDDD;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ODFId> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public ODFIdListDDD() {
    }

    public ODFIdListDDD(List<ODFId> list) {
        this.list = list;
    }

    public String toString() {
        return "ODFIdListDDD(list=" + this.getList() + ")";
    }
}

