/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.sellitemoptions;

import java.util.ArrayList;
import java.util.List;
import ro.deversoft.odf.gearbox.common.ODFId;
import ro.deversoft.odf.gearbox.common.sellitemoptions.SellItemOptionFormDDD;
import ro.deversoft.odf.gearbox.common.sellitemoptions.SellItemOptionPredefinedDDD;

public class SellItemOptionsDefinitionDDD {
    List<SellItemOptionPredefinedDDD> predefined;
    List<SellItemOptionFormDDD> forms;
    boolean overrideAllInherited;

    public boolean hasOptions() {
        return this.predefined != null && this.predefined.size() > 0 || this.forms != null && this.forms.size() > 0;
    }

    public List<ODFId> getAllMandatoryOptionIds() {
        ODFId key;
        ArrayList<ODFId> allIds = new ArrayList<ODFId>();
        if (this.predefined != null && this.predefined.size() > 0) {
            for (SellItemOptionPredefinedDDD sellItemOptionPredefinedDDD : this.predefined) {
                if (!sellItemOptionPredefinedDDD.required) continue;
                key = sellItemOptionPredefinedDDD.getKey();
                allIds.add(key);
            }
        }
        if (this.forms != null && this.forms.size() > 0) {
            for (SellItemOptionFormDDD sellItemOptionFormDDD : this.forms) {
                if (!sellItemOptionFormDDD.required) continue;
                key = sellItemOptionFormDDD.getKey();
                allIds.add(key);
            }
        }
        return allIds;
    }

    public boolean atLeastOneIsSettableByCustomer() {
        if (this.predefined != null && this.predefined.size() > 0) {
            for (SellItemOptionPredefinedDDD sellItemOptionPredefinedDDD : this.predefined) {
                if (!sellItemOptionPredefinedDDD.settableInCustomerApp) continue;
                return true;
            }
        }
        if (this.forms != null && this.forms.size() > 0) {
            for (SellItemOptionFormDDD sellItemOptionFormDDD : this.forms) {
                if (!sellItemOptionFormDDD.settableInCustomerApp) continue;
                return true;
            }
        }
        return false;
    }

    public boolean atLeastOneIsRequired() {
        if (this.predefined != null && this.predefined.size() > 0) {
            for (SellItemOptionPredefinedDDD sellItemOptionPredefinedDDD : this.predefined) {
                if (!sellItemOptionPredefinedDDD.required) continue;
                return true;
            }
        }
        if (this.forms != null && this.forms.size() > 0) {
            for (SellItemOptionFormDDD sellItemOptionFormDDD : this.forms) {
                if (!sellItemOptionFormDDD.required) continue;
                return true;
            }
        }
        return false;
    }

    private static List<SellItemOptionPredefinedDDD> $default$predefined() {
        return new ArrayList<SellItemOptionPredefinedDDD>();
    }

    private static List<SellItemOptionFormDDD> $default$forms() {
        return new ArrayList<SellItemOptionFormDDD>();
    }

    public static SellItemOptionsDefinitionDDDBuilder builder() {
        return new SellItemOptionsDefinitionDDDBuilder();
    }

    public List<SellItemOptionPredefinedDDD> getPredefined() {
        return this.predefined;
    }

    public List<SellItemOptionFormDDD> getForms() {
        return this.forms;
    }

    public boolean getOverrideAllInherited() {
        return this.overrideAllInherited;
    }

    public SellItemOptionsDefinitionDDD setPredefined(List<SellItemOptionPredefinedDDD> predefined) {
        this.predefined = predefined;
        return this;
    }

    public SellItemOptionsDefinitionDDD setForms(List<SellItemOptionFormDDD> forms) {
        this.forms = forms;
        return this;
    }

    public SellItemOptionsDefinitionDDD setOverrideAllInherited(boolean overrideAllInherited) {
        this.overrideAllInherited = overrideAllInherited;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SellItemOptionsDefinitionDDD)) {
            return false;
        }
        SellItemOptionsDefinitionDDD other = (SellItemOptionsDefinitionDDD)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOverrideAllInherited() != other.getOverrideAllInherited()) {
            return false;
        }
        List<SellItemOptionPredefinedDDD> this$predefined = this.getPredefined();
        List<SellItemOptionPredefinedDDD> other$predefined = other.getPredefined();
        if (this$predefined == null ? other$predefined != null : !((Object)this$predefined).equals(other$predefined)) {
            return false;
        }
        List<SellItemOptionFormDDD> this$forms = this.getForms();
        List<SellItemOptionFormDDD> other$forms = other.getForms();
        return !(this$forms == null ? other$forms != null : !((Object)this$forms).equals(other$forms));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SellItemOptionsDefinitionDDD;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.getOverrideAllInherited() ? 79 : 97);
        List<SellItemOptionPredefinedDDD> $predefined = this.getPredefined();
        result = result * 59 + ($predefined == null ? 43 : ((Object)$predefined).hashCode());
        List<SellItemOptionFormDDD> $forms = this.getForms();
        result = result * 59 + ($forms == null ? 43 : ((Object)$forms).hashCode());
        return result;
    }

    public String toString() {
        return "SellItemOptionsDefinitionDDD(predefined=" + this.getPredefined() + ", forms=" + this.getForms() + ", overrideAllInherited=" + this.getOverrideAllInherited() + ")";
    }

    public SellItemOptionsDefinitionDDD(List<SellItemOptionPredefinedDDD> predefined, List<SellItemOptionFormDDD> forms, boolean overrideAllInherited) {
        this.predefined = predefined;
        this.forms = forms;
        this.overrideAllInherited = overrideAllInherited;
    }

    public SellItemOptionsDefinitionDDD() {
        this.predefined = SellItemOptionsDefinitionDDD.$default$predefined();
        this.forms = SellItemOptionsDefinitionDDD.$default$forms();
    }

    public static class SellItemOptionsDefinitionDDDBuilder {
        private boolean predefined$set;
        private List<SellItemOptionPredefinedDDD> predefined$value;
        private boolean forms$set;
        private List<SellItemOptionFormDDD> forms$value;
        private boolean overrideAllInherited;

        SellItemOptionsDefinitionDDDBuilder() {
        }

        public SellItemOptionsDefinitionDDDBuilder setPredefined(List<SellItemOptionPredefinedDDD> predefined) {
            this.predefined$value = predefined;
            this.predefined$set = true;
            return this;
        }

        public SellItemOptionsDefinitionDDDBuilder setForms(List<SellItemOptionFormDDD> forms) {
            this.forms$value = forms;
            this.forms$set = true;
            return this;
        }

        public SellItemOptionsDefinitionDDDBuilder setOverrideAllInherited(boolean overrideAllInherited) {
            this.overrideAllInherited = overrideAllInherited;
            return this;
        }

        public SellItemOptionsDefinitionDDD build() {
            List predefined$value = this.predefined$value;
            if (!this.predefined$set) {
                predefined$value = SellItemOptionsDefinitionDDD.$default$predefined();
            }
            List forms$value = this.forms$value;
            if (!this.forms$set) {
                forms$value = SellItemOptionsDefinitionDDD.$default$forms();
            }
            return new SellItemOptionsDefinitionDDD(predefined$value, forms$value, this.overrideAllInherited);
        }

        public String toString() {
            return "SellItemOptionsDefinitionDDD.SellItemOptionsDefinitionDDDBuilder(predefined$value=" + this.predefined$value + ", forms$value=" + this.forms$value + ", overrideAllInherited=" + this.overrideAllInherited + ")";
        }
    }
}

