/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui;

import com.shfarr.ui.layouts.FlexibleGridLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FhFontChooser
extends JPanel
implements ActionListener,
ChangeListener {
    private JComboBox fontCombo = null;
    private JPanel editor = null;
    private JLabel sampleLabel = null;
    private JCheckBox italicCheckBox = null;
    private JCheckBox boldCheckBox = null;
    private JSpinner sizeSpinner = null;

    public FhFontChooser() {
        super(new BorderLayout(4, 4));
        JScrollPane scp = new JScrollPane(this.getSampleLabel());
        scp.setPreferredSize(new Dimension(420, 180));
        this.add((Component)scp, "Center");
        this.add((Component)this.getEditor(), "South");
    }

    protected JComboBox getFontCombo() {
        if (this.fontCombo == null) {
            this.fontCombo = new JComboBox();
            Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            int i = 0;
            while (i < fonts.length) {
                this.fontCombo.addItem(fonts[i].getName());
                ++i;
            }
            this.fontCombo.addActionListener(this);
        }
        return this.fontCombo;
    }

    protected JLabel getSampleLabel() {
        if (this.sampleLabel == null) {
            this.sampleLabel = new JLabel("Sample Text", 0);
            this.sampleLabel.setOpaque(true);
            this.sampleLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        }
        return this.sampleLabel;
    }

    protected JCheckBox getBoldCheckBox() {
        if (this.boldCheckBox == null) {
            this.boldCheckBox = new JCheckBox("Bold");
            this.boldCheckBox.addActionListener(this);
        }
        return this.boldCheckBox;
    }

    protected JCheckBox getItalicCheckBox() {
        if (this.italicCheckBox == null) {
            this.italicCheckBox = new JCheckBox("Italic");
            this.italicCheckBox.addActionListener(this);
        }
        return this.italicCheckBox;
    }

    protected JSpinner getSizeSpinner() {
        if (this.sizeSpinner == null) {
            this.sizeSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 1000, 1));
            this.sizeSpinner.addChangeListener(this);
        }
        return this.sizeSpinner;
    }

    protected JPanel getEditor() {
        if (this.editor == null) {
            this.editor = new JPanel(new FlexibleGridLayout(3, 2, 4, 4));
            this.editor.add(this.getFontCombo());
            this.editor.add(this.getSizeSpinner());
            this.editor.add(this.getBoldCheckBox());
            this.editor.add(new JLabel());
            this.editor.add(this.getItalicCheckBox());
            this.editor.add(new JLabel());
        }
        return this.editor;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getFontCombo()) {
            this.getSampleLabel().setFont(new Font(this.getFontCombo().getSelectedItem().toString(), this.getSampleLabel().getFont().getStyle(), this.getSampleLabel().getFont().getSize()));
        }
        if (e.getSource() instanceof JCheckBox) {
            int style = 0;
            if (this.getBoldCheckBox().isSelected()) {
                style |= 1;
            }
            if (this.getItalicCheckBox().isSelected()) {
                style |= 2;
            }
            this.getSampleLabel().setFont(this.getSampleLabel().getFont().deriveFont(style));
        }
    }

    public Font getSelectedFont() {
        return this.getSampleLabel().getFont();
    }

    public void setSelectedFont(Font font) {
        this.getSampleLabel().setFont(font);
        this.getFontCombo().setSelectedItem(font.getName());
        this.getBoldCheckBox().setSelected(font.isBold());
        this.getItalicCheckBox().setSelected(font.isItalic());
        this.getSizeSpinner().setValue(new Integer(font.getSize()));
    }

    public void stateChanged(ChangeEvent e) {
        this.getSampleLabel().setFont(this.getSampleLabel().getFont().deriveFont(((Integer)this.getSizeSpinner().getValue()).floatValue()));
    }

    public static final Font sshowDialog(Component parent, String title, Font initial) {
        FhFontChooser chooser = new FhFontChooser();
        chooser.setSelectedFont(initial);
        Font[] ans = new Font[1];
        return initial;
    }

    public static final Font showDialog(Component parent, String title, final Font initial) {
        FhFontChooser chooser = new FhFontChooser();
        chooser.setSelectedFont(initial);
        final Font[] ans = new Font[1];
        final JDialog dialog = parent instanceof Frame ? new JDialog((Frame)parent, title, true) : (parent instanceof Dialog ? new JDialog((Dialog)parent, title, true) : (SwingUtilities.windowForComponent(parent) instanceof Frame ? new JDialog((Frame)SwingUtilities.windowForComponent(parent), title, true) : new JDialog((Dialog)SwingUtilities.windowForComponent(parent), title, true)));
        JOptionPane op = new JOptionPane(){

            public Object[] getOptions() {
                return new String[]{"Ok", "Cancel", "Reset"};
            }

            public void setValue(Object value) {
                super.setValue(value);
                if (value.equals("Reset")) {
                    FhFontChooser.this.setSelectedFont(initial);
                } else if (value.equals("Cancel")) {
                    dialog.dispose();
                } else if (value.equals("Ok")) {
                    ans[0] = FhFontChooser.this.getSelectedFont();
                    dialog.dispose();
                }
            }
        };
        op.setMessage(chooser);
        op.setIcon(null);
        dialog.getContentPane().add((Component)op, "Center");
        dialog.pack();
        dialog.setLocation((int)(parent.getLocation().getX() + (double)((parent.getWidth() - dialog.getWidth()) / 2)), (int)(parent.getLocation().getY() + (double)((parent.getHeight() - dialog.getHeight()) / 2)));
        dialog.setVisible(true);
        return ans[0];
    }
}

