/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.ext;

import com.shfarr.ui.GraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;

public class FhTableCellRenderer
extends DefaultTableCellRenderer
implements UIResource {
    protected int crow = 0;
    protected boolean selected = false;

    public Color getBackground() {
        if (this.crow % 2 != 0 && super.getBackground() != null) {
            return new Color(GraphicsUtils.darker(super.getBackground().getRGB(), 0.02));
        }
        return super.getBackground();
    }

    protected int getTextAlignment(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return 4;
        }
        return 2;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int col) {
        this.crow = row;
        this.selected = selected;
        Component c = super.getTableCellRendererComponent(table, value, selected, hasFocus, row, col);
        this.setHorizontalAlignment(this.getTextAlignment(value));
        if (c == this && value instanceof Boolean) {
            this.setText(null);
            if (Boolean.TRUE.equals(value)) {
                this.setIcon(UIManager.getIcon("CheckBox.selectedIcon"));
            } else {
                this.setIcon(UIManager.getIcon("CheckBox.unselectedIcon"));
            }
        } else {
            this.setIcon(null);
        }
        return c;
    }

    protected void setValue(Object value) {
        this.setText(value == null ? " ??? " : " " + value.toString() + " ");
    }
}

