/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.vp_pda.v4;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.pda_utils.PdaUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.vp_pda.v2.Categorie;
import ro.atreides.vp_pda.v2.Product;
import ro.atreides.vp_pda.v2.Sectie;
import ro.atreides.vp_pda.v4.BonMarcaj;
import ro.atreides.vp_pda.v4.Config3;
import ro.atreides.vp_pda.v4.ConnectionLogic;
import ro.atreides.vp_pda.v4.Location3;
import ro.atreides.vp_pda.v4.MessageListener;
import ro.atreides.vp_pda.v4.Sale;
import ro.atreides.vp_pda.v4.Table3;
import ro.atreides.vp_pda.v4.TableStatus;
import ro.atreides.vp_pda.v4.WaitMoreInterface;
import ro.atreides.vp_pda.v4.messages.AbstractMessage;
import ro.atreides.vp_pda.v4.messages.IncasatMessage;
import ro.atreides.vp_pda.v4.messages.IncasatReply;
import ro.atreides.vp_pda.v4.messages.LoginMessage;
import ro.atreides.vp_pda.v4.messages.LoginReply;
import ro.atreides.vp_pda.v4.messages.MarcajMessage;
import ro.atreides.vp_pda.v4.messages.MarcajReply;
import ro.atreides.vp_pda.v4.messages.NotaMessage;
import ro.atreides.vp_pda.v4.messages.NotaReply;
import ro.atreides.vp_pda.v4.messages.NotificationsAcknoledgedMessage;
import ro.atreides.vp_pda.v4.messages.NotificationsAcknoledgedReply;
import ro.atreides.vp_pda.v4.messages.PingMessage;
import ro.atreides.vp_pda.v4.messages.PingReply;
import ro.atreides.vp_pda.v4.messages.ReadDataMessage;
import ro.atreides.vp_pda.v4.messages.ReadDataReply;
import ro.atreides.vp_pda.v4.messages.ReadNotificationsMessage;
import ro.atreides.vp_pda.v4.messages.ReadNotificationsReply;
import ro.atreides.vp_pda.v4.messages.RefreshTableMessage;
import ro.atreides.vp_pda.v4.messages.RefreshTableReply;

public class PdaLogic3
implements MessageListener {
    private static PdaLogic3 instance;
    private Hashtable locationsHash = new Hashtable();
    private Hashtable tablesHash = new Hashtable();
    private Hashtable sectionsHash = new Hashtable();
    private Hashtable categoriesHash = new Hashtable();
    private Hashtable productsHash = new Hashtable();
    private Location3 locatie = null;
    public static final int LA_PLATA = 5;
    public static final int CLIENTI = 1;
    public static final int LIBERA = 0;
    public static final String LOGIN_DENIED = "LOGIN_DENIED";
    private boolean notificationsActive = false;
    private String notificationsString = "--";
    private boolean waitForReadData = false;
    private boolean waitForRefreshTable = false;
    private boolean waitForNoficationAcknoledged = false;
    private boolean waitForLogin = false;
    private boolean waitForMarcaj = false;
    private boolean waitForNota = false;
    private boolean waitForIncasat = false;
    private boolean waitReadNotifications = false;
    public int idWaiter = -1;
    public static final long waitMillis = 20000L;
    public static final long keepAliveMillis = 10000L;
    private long pingTime;
    private long pongTime;

    public static synchronized PdaLogic3 getInstance() {
        if (instance == null) {
            instance = new PdaLogic3();
        }
        return instance;
    }

    private boolean sendMessageAndWait(AbstractMessage toSend, WaitMoreInterface inter) {
        long deadline = System.currentTimeMillis() + 20000L;
        ConnectionLogic.getInstance().sendMessage(toSend);
        while (inter.waitMore() && System.currentTimeMillis() < deadline) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        return System.currentTimeMillis() <= deadline;
    }

    private PdaLogic3() {
        Config3.readConfiguration();
        ConnectionLogic.getInstance();
        ConnectionLogic.getInstance().addMessageListener(ReadDataReply.class, this);
        ConnectionLogic.getInstance().addMessageListener(RefreshTableReply.class, this);
        ConnectionLogic.getInstance().addMessageListener(LoginReply.class, this);
        ConnectionLogic.getInstance().addMessageListener(MarcajReply.class, this);
        ConnectionLogic.getInstance().addMessageListener(NotaReply.class, this);
        ConnectionLogic.getInstance().addMessageListener(IncasatReply.class, this);
        ConnectionLogic.getInstance().addMessageListener(ReadNotificationsReply.class, this);
        ConnectionLogic.getInstance().addMessageListener(NotificationsAcknoledgedReply.class, this);
        ConnectionLogic.getInstance().addMessageListener(PingReply.class, this);
        Thread keepAliveThread = new Thread(new Runnable(){

            public void run() {
                PdaLogic3.this.pingTime = System.currentTimeMillis();
                PdaLogic3.this.pongTime = System.currentTimeMillis();
                while (true) {
                    if (PdaLogic3.this.pongTime - PdaLogic3.this.pingTime > 10000L) {
                        System.out.println("KeepAliveThread not received pong, disconnecting");
                        ConnectionLogic.getInstance().disconnect();
                        continue;
                    }
                    PdaLogic3.this.pingTime = System.currentTimeMillis();
                    ConnectionLogic.getInstance().sendMessage(new PingMessage());
                    try {
                        Thread.sleep(9000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        });
        keepAliveThread.setName(ConnectionLogic.class.getName() + "_KeepAliveThread");
        keepAliveThread.start();
        this.waitForReadData = true;
        boolean opOk = this.sendMessageAndWait(new ReadDataMessage(), new WaitMoreInterface(){

            public boolean waitMore() {
                return PdaLogic3.this.waitForReadData;
            }
        });
        if (!opOk) {
            System.out.println("Citirea datelor a esuat.\nVerificati / reporniti reteaua wireless.");
            System.exit(1);
        }
        System.out.println("Am citit meniul");
        opOk = this.sendRefreshRequest();
        if (!opOk) {
            System.out.println("Citirea meselor a esuat.\nVerificati / reporniti reteaua wireless.");
            System.exit(1);
        }
        System.out.println("Am citit mesele");
        Runnable notificationsSoundAlert = new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(Config3.notificationsAlertSeconds * 1000);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    try {
                        if (!Config3.playSound || !PdaLogic3.this.notificationsActive) continue;
                        PdaUtils.playAlarmMP3();
                        continue;
                    }
                    catch (Throwable th) {
                        Logger.logError((Object)this, (Throwable)th);
                        continue;
                    }
                    break;
                }
            }
        };
        new Thread(notificationsSoundAlert).start();
        Runnable notificationsRead = new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(Config3.notificationsAlertSeconds * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (PdaLogic3.this.idWaiter == -1) continue;
                    PdaLogic3.this.readNotifications();
                }
            }
        };
        new Thread(notificationsRead).start();
    }

    public String getNotificationsString() {
        return this.notificationsString;
    }

    public void notificationsAcknoledged() {
        this.notificationsActive = false;
        this.notificationsString = "--";
        if (this.idWaiter == -1) {
            return;
        }
        this.waitForNoficationAcknoledged = true;
        this.sendMessageAndWait(new NotificationsAcknoledgedMessage(this.idWaiter), new WaitMoreInterface(){

            public boolean waitMore() {
                return PdaLogic3.this.waitForNoficationAcknoledged;
            }
        });
    }

    public void readNotifications() {
        this.waitReadNotifications = true;
        this.sendMessageAndWait(new ReadNotificationsMessage(this.idWaiter), new WaitMoreInterface(){

            public boolean waitMore() {
                return PdaLogic3.this.waitReadNotifications;
            }
        });
    }

    public void messageReceived(AbstractMessage received) {
        AbstractMessage reply;
        if (received instanceof ReadDataReply) {
            this.readDataFromServer((ReadDataReply)received);
        }
        if (received instanceof RefreshTableReply) {
            reply = (RefreshTableReply)received;
            Vector tables = ((RefreshTableReply)reply).getTables();
            for (int i = 0; i < tables.size(); ++i) {
                TableStatus tableStatus = (TableStatus)tables.elementAt(i);
                this.setWaiterForTable(tableStatus.getIdTable(), tableStatus.getIdUser(), tableStatus.getUserName());
                this.setStatusForTable(tableStatus.getIdTable(), tableStatus.getStatus());
            }
            this.waitForRefreshTable = false;
        }
        if (received instanceof LoginReply) {
            reply = (LoginReply)received;
            this.idWaiter = ((LoginReply)reply).getIdWaiter();
            this.waitForLogin = false;
        }
        if (received instanceof MarcajReply) {
            reply = (MarcajReply)received;
            if (((MarcajReply)reply).isOk()) {
                int idTable = ((MarcajReply)reply).getIdTable();
                Table3 t = (Table3)this.tablesHash.get(new Integer(idTable));
                t.setSales(((MarcajReply)reply).getSales());
                t.setMaxPlatou(((MarcajReply)reply).getMaxIdPlatou());
                this.setWaiterForTable(idTable, ((MarcajReply)reply).getIdUser(), ((MarcajReply)reply).getUsername());
                this.setStatusForTable(idTable, ((MarcajReply)reply).getTableStatus());
            }
            this.waitForMarcaj = false;
        }
        if (received instanceof NotaReply) {
            reply = (NotaReply)received;
            if (((NotaReply)reply).isOk()) {
                int idTable = ((NotaReply)reply).getIdTable();
                this.setWaiterForTable(idTable, ((NotaReply)reply).getIdUser(), ((NotaReply)reply).getUsername());
                this.setStatusForTable(idTable, ((NotaReply)reply).getStatus());
            }
            this.waitForNota = false;
        }
        if (received instanceof IncasatReply) {
            reply = (IncasatReply)received;
            if (((IncasatReply)reply).isOk()) {
                int idTable = ((IncasatReply)reply).getIdTable();
                this.setWaiterForTable(idTable, -1, "");
                this.setStatusForTable(idTable, ((IncasatReply)reply).getStatus());
            }
            this.waitForIncasat = false;
        }
        if (received instanceof ReadNotificationsReply) {
            ReadNotificationsReply rdReply = (ReadNotificationsReply)received;
            if (Validators.correctString((String)rdReply.getNotificationsString())) {
                this.notificationsString = rdReply.getNotificationsString();
                this.notificationsActive = true;
            }
            this.waitReadNotifications = false;
        }
        if (received instanceof NotificationsAcknoledgedReply) {
            this.notificationsActive = false;
            this.notificationsString = "--";
            this.waitForNoficationAcknoledged = false;
        }
        if (received instanceof PingReply) {
            this.pongTime = System.currentTimeMillis();
        }
    }

    private void readDataFromServer(ReadDataReply reply) {
        try {
            String file = Config3.currentDir + File.separator + "input_data.xml";
            String content = "";
            content = reply.getXml();
            if (!Validators.correctString((String)content)) {
                System.out.println("Nu am citit datele de la server. Verificati / reporniti reteaua wireless");
                System.exit(1);
            }
            FileUtils.writeTextToFile((String)file, (String)content);
            Utils.importXml((DefaultHandler)new DefaultHandler(){

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    String label;
                    String label2;
                    int id;
                    if (qName.equalsIgnoreCase("location")) {
                        Location3 l = new Location3();
                        id = Integer.parseInt(attributes.getValue("id"));
                        label2 = attributes.getValue("label");
                        l.setId(id);
                        l.setLabel(label2);
                        PdaLogic3.this.locationsHash.put(label2, l);
                    }
                    if (qName.equalsIgnoreCase("table")) {
                        Table3 t = new Table3();
                        id = Integer.parseInt(attributes.getValue("id"));
                        int idLocatie = Integer.parseInt(attributes.getValue("id_locatie"));
                        label = attributes.getValue("label");
                        t.setId(id);
                        t.setLabel(label);
                        t.setIdLocatie(idLocatie);
                        PdaLogic3.this.tablesHash.put(new Integer(id), t);
                    }
                    if (qName.equalsIgnoreCase("sectie")) {
                        Sectie s = new Sectie();
                        id = Integer.parseInt(attributes.getValue("id"));
                        label2 = attributes.getValue("label");
                        s.setId(id);
                        s.setLabel(label2);
                        PdaLogic3.this.sectionsHash.put(new Integer(id), s);
                    }
                    if (qName.equalsIgnoreCase("categorie")) {
                        Categorie c = new Categorie();
                        id = Integer.parseInt(attributes.getValue("id"));
                        int idSectie = Integer.parseInt(attributes.getValue("idSectie"));
                        label = attributes.getValue("label");
                        c.setIdCategorie(id);
                        c.setName(label);
                        c.setIdSectie(idSectie);
                        PdaLogic3.this.categoriesHash.put(new Integer(id), c);
                    }
                    if (qName.equalsIgnoreCase("produs")) {
                        Product p = new Product();
                        id = Integer.parseInt(attributes.getValue("id"));
                        int idCategorie = Integer.parseInt(attributes.getValue("idCategorie"));
                        label = attributes.getValue("label");
                        p.setIdCategorie(idCategorie);
                        p.setName(label);
                        p.setIdProduct(id);
                        float pret = Float.parseFloat(attributes.getValue("pret"));
                        p.setPret(pret);
                        PdaLogic3.this.productsHash.put(new Integer(id), p);
                    }
                }
            }, (String)file);
            this.waitForReadData = false;
        }
        catch (IOException e) {
            Logger.logException((Object)this, (Exception)e);
            System.out.println("IO Error");
            System.exit(1);
        }
        catch (SAXException e) {
            Logger.logException((Object)this, (Exception)e);
            System.out.println("Fisier date incorect");
            System.exit(1);
        }
    }

    public boolean sendRefreshRequest() {
        this.waitForRefreshTable = true;
        RefreshTableMessage rtm = new RefreshTableMessage();
        return this.sendMessageAndWait(rtm, new WaitMoreInterface(){

            public boolean waitMore() {
                return PdaLogic3.this.waitForRefreshTable;
            }
        });
    }

    public boolean nota(Table3 masa) {
        this.waitForNota = true;
        NotaMessage nm = new NotaMessage(masa.getId(), this.idWaiter);
        return this.sendMessageAndWait(nm, new WaitMoreInterface(){

            public boolean waitMore() {
                return PdaLogic3.this.waitForNota;
            }
        });
    }

    public boolean incasat(Table3 masa) {
        this.waitForIncasat = true;
        IncasatMessage nm = new IncasatMessage(masa.getId(), this.idWaiter);
        return this.sendMessageAndWait(nm, new WaitMoreInterface(){

            public boolean waitMore() {
                return PdaLogic3.this.waitForIncasat;
            }
        });
    }

    public int getIdWaiter() {
        return this.idWaiter;
    }

    public boolean tryLogin(String user, String parola) {
        if (!Validators.correctString((String)user) || !Validators.correctString((String)parola)) {
            return false;
        }
        this.idWaiter = -1;
        LoginMessage login = new LoginMessage(user, parola);
        this.waitForLogin = true;
        this.sendMessageAndWait(login, new WaitMoreInterface(){

            public boolean waitMore() {
                return PdaLogic3.this.waitForLogin;
            }
        });
        return this.idWaiter != -1;
    }

    public Vector getLocations() {
        Vector v = new Vector(this.locationsHash.values());
        Vector<Location3> v2 = new Vector<Location3>();
        Iterator tabl = v.iterator();
        while (tabl.hasNext()) {
            Location3 location = (Location3)tabl.next();
            boolean must = false;
            Iterator i2 = this.tablesHash.values().iterator();
            while (i2.hasNext()) {
                Table3 t = (Table3)i2.next();
                if (t.getIdLocatie() != location.getId()) continue;
                must = true;
                break;
            }
            if (!must) continue;
            v2.add(location);
        }
        Collections.sort(v2);
        return v2;
    }

    public Vector getSections() {
        return new Vector(this.sectionsHash.values());
    }

    public Vector getCategoriesForSectie(int idSectie) {
        Vector<Categorie> result = new Vector<Categorie>();
        Iterator iterator = this.categoriesHash.values().iterator();
        while (iterator.hasNext()) {
            Categorie c = (Categorie)iterator.next();
            if (c.getIdSectie() != idSectie) continue;
            result.add(c);
        }
        Collections.sort(result);
        return result;
    }

    public Vector getProduseForCategorie(int idCategorie) {
        Vector<Product> result = new Vector<Product>();
        Iterator iterator = this.productsHash.values().iterator();
        while (iterator.hasNext()) {
            Product p = (Product)iterator.next();
            if (p.getIdCategorie() != idCategorie) continue;
            result.add(p);
        }
        Collections.sort(result);
        return result;
    }

    public Product getProductById(int id) {
        return (Product)this.productsHash.get(new Integer(id));
    }

    public Vector getTablesForLocatie(int idLocatie) {
        Vector<Table3> result = new Vector<Table3>();
        Iterator iterator = this.tablesHash.values().iterator();
        while (iterator.hasNext()) {
            Table3 t3 = (Table3)iterator.next();
            if (t3.getIdLocatie() != idLocatie) continue;
            result.add(t3);
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Table3 t1 = (Table3)arg0;
                Table3 t2 = (Table3)arg1;
                int scor1 = 0;
                int scor2 = 0;
                if (PdaLogic3.this.idWaiter != -1) {
                    if (PdaLogic3.this.idWaiter == t1.getIdWaiter()) {
                        scor1 += 100;
                    }
                    if (PdaLogic3.this.idWaiter == t2.getIdWaiter()) {
                        scor2 += 100;
                    }
                }
                if (t1.getStatus() == 5) {
                    scor1 += 10;
                }
                if (t2.getStatus() == 5) {
                    scor2 += 10;
                }
                if (t1.getStatus() == 1) {
                    ++scor1;
                }
                if (t2.getStatus() == 1) {
                    ++scor2;
                }
                if (scor1 != scor2) {
                    return scor2 - scor1;
                }
                return t1.getLabel().compareToIgnoreCase(t2.getLabel());
            }
        });
        return result;
    }

    public void logout() {
        this.idWaiter = -1;
    }

    public Location3 getLocatie() {
        return this.locatie;
    }

    public void setLocatie(Location3 locatie) {
        this.locatie = locatie;
    }

    public boolean isTableEmpty(int idTable) {
        Table3 table = (Table3)this.tablesHash.get(new Integer(idTable));
        return table.getStatus() == -1;
    }

    public void marcaj(Vector presales, int idMasa) {
        BonMarcaj bm = new BonMarcaj(idMasa, this.idWaiter, presales);
        this.waitForMarcaj = true;
        MarcajMessage mm = new MarcajMessage(bm);
        this.sendMessageAndWait(mm, new WaitMoreInterface(){

            public boolean waitMore() {
                return PdaLogic3.this.waitForMarcaj;
            }
        });
    }

    public void refreshSalesAtTable(int idMasa) {
        BonMarcaj bm = new BonMarcaj(idMasa, this.idWaiter, new Vector());
        this.waitForMarcaj = true;
        MarcajMessage mm = new MarcajMessage(bm);
        this.sendMessageAndWait(mm, new WaitMoreInterface(){

            public boolean waitMore() {
                return PdaLogic3.this.waitForMarcaj;
            }
        });
    }

    public boolean canUserTable(int idWaiter, int idTable) {
        if (idWaiter == -1) {
            return false;
        }
        Table3 t3 = (Table3)this.tablesHash.get(new Integer(idTable));
        if (t3.getStatus() == -1) {
            return true;
        }
        return t3.getIdWaiter() == idWaiter;
    }

    public void setWaiterForTable(int idTable, int idWaiter, String userName) {
        Table3 t1 = (Table3)this.tablesHash.get(new Integer(idTable));
        if (t1 != null) {
            t1.setIdWaiter(idWaiter);
            t1.setUserName(userName);
        }
    }

    public void setStatusForTable(int idTable, int status) {
        Table3 t1 = (Table3)this.tablesHash.get(new Integer(idTable));
        if (t1 != null) {
            t1.setStatus(status);
        }
    }

    public Vector getSalesAtTable(int idTable) {
        Table3 t1 = (Table3)this.tablesHash.get(new Integer(idTable));
        if (t1 != null) {
            Vector sales = t1.getSales();
            Collections.sort(sales, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Sale s1 = (Sale)arg0;
                    Sale s2 = (Sale)arg1;
                    Product p1 = (Product)PdaLogic3.this.productsHash.get(new Integer(s1.getIdProduct()));
                    Categorie c1 = (Categorie)PdaLogic3.this.categoriesHash.get(new Integer(p1.getIdCategorie()));
                    Sectie se1 = (Sectie)PdaLogic3.this.sectionsHash.get(new Integer(c1.getIdSectie()));
                    Product p2 = (Product)PdaLogic3.this.productsHash.get(new Integer(s2.getIdProduct()));
                    Categorie c2 = (Categorie)PdaLogic3.this.categoriesHash.get(new Integer(p2.getIdCategorie()));
                    Sectie se2 = (Sectie)PdaLogic3.this.sectionsHash.get(new Integer(c2.getIdSectie()));
                    if (se1.getId() == se2.getId()) {
                        if (s1.getIdPlatou() == s2.getIdPlatou()) {
                            if (c1.getIdCategorie() == c2.getIdCategorie()) {
                                return p1.getIdProduct() - p2.getIdProduct();
                            }
                            return c1.getIdCategorie() - c2.getIdCategorie();
                        }
                        return s1.getIdPlatou() - s2.getIdPlatou();
                    }
                    return se1.getId() - se2.getId();
                }
            });
            return sales;
        }
        return new Vector();
    }

    public String getWaiterNameAtTable(int idTable) {
        Table3 t3 = (Table3)this.tablesHash.get(new Integer(idTable));
        return t3.getUserName();
    }
}

