/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Mode;
import org.tigris.gef.base.ModeSelect;
import org.tigris.gef.base.Prefs;
import org.tigris.gef.ui.IStatusBar;

public class Globals {
    public static final String REMOVE = "remove";
    protected static Applet _applet;
    protected static MediaTracker _tracker;
    public static String defaultStatus;
    private static Log LOG;
    public static Vector clipBoard;
    public static boolean pastable;
    private static String LastDirectory;
    public static boolean ShowFigTips;
    public static IStatusBar _StatusBar;
    protected static Prefs _prefs;
    protected static boolean _sticky;
    protected static Mode _mode;
    protected static Editor _curEditor;
    protected static Hashtable _pcListeners;
    protected static PropertyChangeListener universalListener;
    public static int MAX_LISTENERS;
    static /* synthetic */ Class class$org$tigris$gef$base$Globals;

    public static void setApplet(Applet a) {
        _applet = a;
        Globals.clearStatus();
        _tracker = new MediaTracker(a);
    }

    public static AppletContext getAppletContext() {
        try {
            return _applet.getAppletContext();
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public static Applet getApplet() {
        return _applet;
    }

    public static String getLastDirectory() {
        if (LastDirectory == null) {
            LastDirectory = System.getProperty("user.home");
        }
        return LastDirectory;
    }

    public static void setLastDirectory(String s) {
        LastDirectory = s;
    }

    public static boolean getShowFigTips() {
        return ShowFigTips;
    }

    public static void setShowFigTips(boolean b) {
        ShowFigTips = b;
    }

    public static void setStatusBar(IStatusBar sb) {
        _StatusBar = sb;
    }

    public static void showStatus(String s) {
        if (_StatusBar != null) {
            _StatusBar.showStatus(s);
        } else if (Globals.getAppletContext() != null) {
            _applet.getAppletContext().showStatus(s);
        }
    }

    public static void clearStatus() {
        Globals.showStatus(defaultStatus);
    }

    public static void showDocument(URL url) {
        if (Globals.getAppletContext() != null) {
            _applet.getAppletContext().showDocument(url);
        }
    }

    public static void showDocument(URL url, String target) {
        if (Globals.getAppletContext() != null) {
            _applet.getAppletContext().showDocument(url, target);
        }
    }

    public static void showDocument(String urlString) {
        try {
            Globals.showDocument(new URL(urlString));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static Image getImage(URL url) {
        Image img = null;
        if (Globals.getAppletContext() != null) {
            img = Globals.getAppletContext().getImage(url);
        }
        if (_tracker != null && img != null) {
            _tracker.addImage(img, 1);
        }
        return img;
    }

    public static Image getImage(String urlStr) {
        try {
            Image img = null;
            if (Globals.getAppletContext() != null) {
                img = Globals.getAppletContext().getImage(new URL(urlStr));
            }
            if (_tracker != null && img != null) {
                _tracker.addImage(img, 1);
            }
            return img;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static void waitForImages() {
        if (_tracker == null) {
            return;
        }
        try {
            _tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void quit() {
        Globals.showStatus("Quiting");
        if (_applet.getAppletContext() != null) {
            _applet.destroy();
        }
        System.exit(0);
    }

    public static Prefs getPrefs() {
        return _prefs;
    }

    public static void startPropertySheet() {
    }

    public static Frame someFrame() {
        Container c;
        Editor ce = Globals.curEditor();
        if (ce == null) {
            return null;
        }
        for (c = ce.getJComponent(); c != null && !(c instanceof Frame); c = c.getParent()) {
        }
        return (Frame)c;
    }

    public static void setSticky(boolean b) {
        _sticky = b;
    }

    public static boolean getSticky() {
        return _sticky;
    }

    protected static Mode defaultMode() {
        return new ModeSelect();
    }

    public static void mode(Mode m) {
        _mode = m;
    }

    public static void mode(Mode m, boolean s) {
        _mode = m;
        _sticky = s;
    }

    public static Mode mode() {
        if (_mode == null) {
            _mode = Globals.defaultMode();
        }
        return _mode;
    }

    public static Mode nextMode() {
        if (!_sticky) {
            _mode = Globals.defaultMode();
        }
        return _mode;
    }

    public static void curEditor(Editor ce) {
        _curEditor = ce;
    }

    public static Editor curEditor() {
        return _curEditor;
    }

    public static void addPropertyChangeListener(Object src, PropertyChangeListener l) {
        PropertyChangeListener[] listeners = (PropertyChangeListener[])_pcListeners.get(src);
        if (listeners == null) {
            listeners = new PropertyChangeListener[MAX_LISTENERS];
            _pcListeners.put(src, listeners);
        }
        if (LOG.isDebugEnabled() && _pcListeners.size() > 100) {
            LOG.debug((Object)("_pcListeners size = " + _pcListeners.size()));
        }
        for (int i = 0; i < MAX_LISTENERS; ++i) {
            if (listeners[i] != null) continue;
            listeners[i] = l;
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ran out of listeners!");
        }
    }

    public static void addUniversalPropertyChangeListener(PropertyChangeListener pcl) {
        universalListener = pcl;
    }

    public static void removeUniversalPropertyChangeListener() {
        universalListener = null;
    }

    public static void removePropertyChangeListener(Object s, PropertyChangeListener listener) {
        int i;
        PropertyChangeListener[] listeners = (PropertyChangeListener[])_pcListeners.get(s);
        boolean found = false;
        if (listeners == null) {
            return;
        }
        for (i = 0; i < MAX_LISTENERS; ++i) {
            if (listeners[i] != listener) continue;
            listeners[i] = null;
            found = true;
        }
        if (LOG.isDebugEnabled() && !found) {
            LOG.debug((Object)"listener not found!");
        }
        for (i = 0; i < MAX_LISTENERS; ++i) {
            if (listeners[i] == null) continue;
            return;
        }
        _pcListeners.remove(s);
    }

    public static void firePropChange(Object src, String propName, boolean oldV, boolean newV) {
        Globals.firePropChange(src, propName, new Boolean(oldV), new Boolean(newV));
    }

    public static void firePropChange(Object src, String propName, int oldV, int newV) {
        Globals.firePropChange(src, propName, new Integer(oldV), new Integer(newV));
    }

    public static void firePropChange(Object src, String propName, Object oldValue, Object newValue) {
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        PropertyChangeListener[] listeners = (PropertyChangeListener[])_pcListeners.get(src);
        if (listeners == null && universalListener == null) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(src, propName, oldValue, newValue);
        if (listeners != null) {
            for (int i = 0; i < MAX_LISTENERS; ++i) {
                if (listeners[i] == null) continue;
                listeners[i].propertyChange(evt);
            }
        }
        if (universalListener != null) {
            universalListener.propertyChange(evt);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultStatus = "  ";
        LOG = LogFactory.getLog((Class)(class$org$tigris$gef$base$Globals == null ? (class$org$tigris$gef$base$Globals = Globals.class$("org.tigris.gef.base.Globals")) : class$org$tigris$gef$base$Globals));
        pastable = false;
        LastDirectory = null;
        ShowFigTips = true;
        _StatusBar = null;
        _prefs = new Prefs();
        _sticky = false;
        _pcListeners = new Hashtable();
        universalListener = null;
        MAX_LISTENERS = 4;
    }
}

