/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.plot2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import org.tigris.gef.plot2d.Plotter;

public class Java2d
implements Plotter {
    private static final String[] DASHED_CHOICES = new String[]{"Solid", "Dashed", "LongDashed", "Dotted", "DotDash"};
    private static final float[][] DASH_ARRAYS = new float[][]{null, {5.0f, 5.0f}, {15.0f, 5.0f}, {3.0f, 10.0f}, {3.0f, 6.0f, 10.0f, 6.0f}};
    private static final int[] DASH_PERIOD = new int[]{0, 10, 20, 13, 25};
    private static int SPLINE_THRESH = 2;

    public void drawLine(Object graphicsContext, int lineWidth, Color lineColor, int x1, int y1, int x2, int y2, boolean dashed, float[] dashes, int dashPeriod) {
        if (lineWidth <= 0) {
            return;
        }
        Graphics g = (Graphics)graphicsContext;
        if (dashed) {
            g.setColor(lineColor);
            this.drawDashedLine(g, lineWidth, x1, y1, x2, y2, 0, dashes, dashPeriod);
        } else {
            g.setColor(lineColor);
            g.drawLine(x1, y1, x2, y2);
        }
    }

    public int drawDashedLine(Object graphicsContext, int lineWidth, int x1, int y1, int x2, int y2, int phase, float[] dashes, int dashPeriod) {
        int d;
        if (graphicsContext instanceof Graphics2D) {
            return this.drawDashedLineG2D((Graphics2D)graphicsContext, lineWidth, phase, x1, y1, x2, y2, dashes, dashPeriod);
        }
        Graphics g = (Graphics)graphicsContext;
        int dxdx = (x2 - x1) * (x2 - x1);
        int dydy = (y2 - y1) * (y2 - y1);
        int length = (int)Math.sqrt(dxdx + dydy);
        int numDashes = dashes.length;
        int dashesDist = 0;
        for (d = 0; d < numDashes; ++d) {
            dashesDist = (int)((float)dashesDist + dashes[d]);
        }
        d = 0;
        int i = 0;
        while (i < length) {
            int segEndY;
            int segEndX;
            int segStartX = x1 + (x2 - x1) * i / length;
            int segStartY = y1 + (y2 - y1) * i / length;
            i = (int)((float)i + dashes[d]);
            d = (d + 1) % numDashes;
            if (i >= length) {
                segEndX = x2;
                segEndY = y2;
            } else {
                segEndX = x1 + (x2 - x1) * i / length;
                segEndY = y1 + (y2 - y1) * i / length;
            }
            g.drawLine(segStartX, segStartY, segEndX, segEndY);
            i = (int)((float)i + dashes[d]);
            d = (d + 1) % numDashes;
        }
        return (length + phase) % dashesDist;
    }

    private int drawDashedLineG2D(Graphics2D g, int lineWidth, int phase, int x1, int y1, int x2, int y2, float[] dashes, int dashPeriod) {
        int dxdx = (x2 - x1) * (x2 - x1);
        int dydy = (y2 - y1) * (y2 - y1);
        int length = (int)(Math.sqrt(dxdx + dydy) + 0.5);
        Graphics2D g2D = g;
        Stroke OriginalStroke = g2D.getStroke();
        BasicStroke DashedStroke = new BasicStroke(lineWidth, 2, 0, 10.0f, dashes, phase);
        g2D.setStroke(DashedStroke);
        g2D.drawLine(x1, y1, x2, y2);
        g2D.setStroke(OriginalStroke);
        return (length + phase) % dashPeriod;
    }

    public void drawOval(Object graphicsContext, boolean filled, Color fillColor, Color lineColor, int lineWidth, boolean dashed, int x, int y, int w, int h) {
        if (dashed && graphicsContext instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)graphicsContext;
            Stroke oldStroke = g2d.getStroke();
            float[] dash = new float[]{10.0f, 10.0f};
            BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f);
            g2d.setStroke(stroke);
            if (filled && fillColor != null) {
                g2d.setColor(fillColor);
                g2d.fillOval(x, y, w, h);
            }
            if (lineWidth > 0 && lineColor != null) {
                g2d.setColor(lineColor);
                g2d.drawOval(x, y, w - lineWidth, h - lineWidth);
            }
            g2d.setStroke(oldStroke);
        } else if (filled && fillColor != null) {
            Graphics g = (Graphics)graphicsContext;
            if (lineWidth > 0 && lineColor != null) {
                g.setColor(lineColor);
                g.fillOval(x, y, w, h);
            }
            if (!fillColor.equals(lineColor)) {
                g.setColor(fillColor);
                g.fillOval(x + lineWidth, y + lineWidth, w - lineWidth * 2, h - lineWidth * 2);
            }
        } else if (lineWidth > 0 && lineColor != null) {
            Graphics g = (Graphics)graphicsContext;
            g.setColor(lineColor);
            g.drawOval(x, y, w, h);
        }
    }

    public void drawRect(Object graphicsContext, boolean filled, Color fillColor, int lineWidth, Color lineColor, int x, int y, int w, int h, boolean dashed, float[] dashes, int dashPeriod) {
        Graphics g = (Graphics)graphicsContext;
        if (filled && fillColor != null) {
            int xx = x;
            int yy = y;
            int ww = w;
            int hh = h;
            if (lineColor != null && lineWidth > 1 && !dashed) {
                int lineWidth2 = lineWidth * 2;
                g.setColor(lineColor);
                g.fillRect(xx, yy, ww, hh);
                xx += lineWidth;
                yy += lineWidth;
                ww -= lineWidth2;
                hh -= lineWidth2;
            }
            g.setColor(fillColor);
            g.fillRect(xx, yy, ww, hh);
            if (lineColor != null && (lineWidth == 1 || dashed)) {
                this.paintRectLine(g, xx, yy, ww, hh, lineWidth, lineColor, dashed, dashes, dashPeriod);
            }
        } else {
            this.paintRectLine(g, x, y, w, h, lineWidth, lineColor, dashed, dashes, dashPeriod);
        }
    }

    private void paintRectLine(Graphics g, int x, int y, int w, int h, int lineWidth, Color lineColor, boolean dashed, float[] dashes, int dashPeriod) {
        if (lineWidth > 0 && lineColor != null) {
            g.setColor(lineColor);
            if (lineWidth == 1) {
                this.paintRectLine(g, x, y, w, h, dashed, lineWidth, dashes, dashPeriod);
            } else {
                int xx = x;
                int yy = y;
                int hh = h;
                int ww = w;
                for (int i = 0; i < lineWidth; ++i) {
                    this.paintRectLine(g, xx++, yy++, ww, hh, dashed, lineWidth, dashes, dashPeriod);
                    ww -= 2;
                    hh -= 2;
                }
            }
        }
    }

    private void paintRectLine(Graphics g, int x, int y, int w, int h, boolean dashed, int lineWidth, float[] dashes, int dashPeriod) {
        if (!dashed) {
            g.drawRect(x, y, w, h);
        } else {
            this.drawDashedRectangle(g, 0, x, y, w, h, lineWidth, dashes, dashPeriod);
        }
    }

    private void drawDashedRectangle(Graphics g, int phase, int x, int y, int w, int h, int lineWidth, float[] dashes, int dashPeriod) {
        phase = this.drawDashedLine(g, lineWidth, x, y, x + w, y, phase, dashes, dashPeriod);
        phase = this.drawDashedLine(g, lineWidth, x + w, y, x + w, y + h, phase, dashes, dashPeriod);
        phase = this.drawDashedLine(g, lineWidth, x + w, y + h, x, y + h, phase, dashes, dashPeriod);
        phase = this.drawDashedLine(g, lineWidth, x, y + h, x, y, phase, dashes, dashPeriod);
    }

    public void drawCube(Object graphicContext, Color lineColor, Color fillColor, int x, int y, int w, int h, int d) {
        Graphics g = (Graphics)graphicContext;
        g.setColor(fillColor);
        g.fillRect(x, y, w, h);
        g.setColor(lineColor);
        g.drawRect(x, y, w, h);
        g.setColor(fillColor);
        g.fillPolygon(new int[]{x, x + d, x + w + d, x + w}, new int[]{y, y - d, y - d, y}, 4);
        g.setColor(lineColor);
        g.drawPolygon(new int[]{x, x + d, x + w + d, x + w}, new int[]{y, y - d, y - d, y}, 4);
        g.setColor(fillColor);
        g.fillPolygon(new int[]{x + w + d, x + w + d, x + w, x + w}, new int[]{y - d, y + h - d, y + h, y}, 4);
        g.setColor(lineColor);
        g.drawPolygon(new int[]{x + w + d, x + w + d, x + w, x + w}, new int[]{y - d, y + h - d, y + h, y}, 4);
    }

    public void drawDiamond(Object graphicContext, boolean filled, Color fillColor, int lineWidth, Color lineColor, int x, int y, int w, int h) {
        Graphics g = (Graphics)graphicContext;
        int[] xs = new int[4];
        int[] ys = new int[4];
        xs[0] = x + w / 2;
        ys[0] = y;
        xs[1] = x + w;
        ys[1] = y + h / 2;
        xs[2] = x + w / 2;
        ys[2] = y + h;
        xs[3] = x;
        ys[3] = y + h / 2;
        if (filled && fillColor != null) {
            g.setColor(fillColor);
            g.fillPolygon(xs, ys, 4);
        }
        if (lineWidth > 0 && lineColor != null) {
            g.setColor(lineColor);
            g.drawPolygon(xs, ys, 4);
        }
    }

    public void drawPoly(Object graphicsContext, boolean filled, Color fillColor, int lineWidth, Color lineColor, int pointCount, int[] xPoints, int[] yPoints, boolean dashed, float[] dashes, int dashPeriod) {
        Graphics g = (Graphics)graphicsContext;
        if (filled && fillColor != null) {
            g.setColor(fillColor);
            g.fillPolygon(xPoints, yPoints, pointCount);
        }
        if (lineWidth > 0 && lineColor != null) {
            g.setColor(lineColor);
            if (dashed) {
                this.drawDashedPerimeter(g, lineWidth, pointCount, xPoints, yPoints, dashes, dashPeriod);
            } else {
                g.drawPolyline(xPoints, yPoints, pointCount);
            }
        }
    }

    private void drawDashedPerimeter(Graphics g, int lineWidth, int pointCount, int[] xPoints, int[] yPoints, float[] dashes, int dashPeriod) {
        int phase = 0;
        for (int i = 1; i < pointCount; ++i) {
            phase = this.drawDashedLine(g, lineWidth, xPoints[i - 1], yPoints[i - 1], xPoints[i], yPoints[i], phase, dashes, dashPeriod);
        }
    }

    private void drawBezier(Graphics g, boolean filled, Color fillColor, Polygon curve, int x1, int y1, int x2, int y2, int x3, int y3) {
        int xa = (x1 + x2) / 2;
        int ya = (y1 + y2) / 2;
        int xc = (x2 + x3) / 2;
        int yc = (y2 + y3) / 2;
        int xb = (xa + xc) / 2;
        int yb = (ya + yc) / 2;
        int xp = (x1 + xb) / 2;
        int yp = (y1 + yb) / 2;
        if (Math.abs(xa - xp) + Math.abs(ya - yp) > SPLINE_THRESH) {
            this.drawBezier(g, filled, fillColor, curve, x1, y1, xa, ya, xb, yb);
        } else {
            g.drawLine(x1, y1, xb, yb);
            curve.addPoint(xb, yb);
        }
        xp = (x3 + xb) / 2;
        yp = (y3 + yb) / 2;
        if (Math.abs(xc - xp) + Math.abs(yc - yp) > SPLINE_THRESH) {
            this.drawBezier(g, filled, fillColor, curve, xb, yb, xc, yc, x3, y3);
        } else {
            g.drawLine(xb, yb, x3, y3);
            curve.addPoint(x3, y3);
        }
    }

    public void drawCurve(Object graphicContext, Polygon curve, boolean filled, Color fillColor, Color lineColor, int npoints, int[] xKnots, int[] yKnots) {
        Graphics g = (Graphics)graphicContext;
        int nSegments = npoints - 2;
        curve = new Polygon();
        g.setColor(lineColor);
        for (int i = 0; i <= nSegments - 1; ++i) {
            this.drawBezier(g, filled, fillColor, curve, xKnots[2 * i], yKnots[2 * i], xKnots[2 * i + 1], yKnots[2 * i + 1], xKnots[2 * i + 2], yKnots[2 * i + 2]);
        }
        if (filled) {
            g.setColor(fillColor);
            g.fillPolygon(curve);
            g.setColor(lineColor);
            g.drawPolyline(curve.xpoints, curve.ypoints, curve.npoints);
        }
    }

    public void drawStraight(Object graphicContext, Color lineColor, int[] xKnots, int[] yKnots) {
        Graphics g = (Graphics)graphicContext;
        g.setColor(lineColor);
        g.drawLine(xKnots[0], yKnots[0], xKnots[1], yKnots[1]);
    }

    public void drawRRect(Object graphicsContext, boolean filled, Color fillColor, int lineWidth, Color lineColor, int x, int y, int w, int h, int radius) {
        Graphics g = (Graphics)graphicsContext;
        if (filled && fillColor != null) {
            if (lineColor != null && lineWidth > 1) {
                this.drawFilledRRectWithWideLine(g, fillColor, lineWidth, lineColor, x, y, w, h, radius);
            } else {
                this.drawFilledRRect(g, fillColor, lineWidth, lineColor, x, y, w, h, radius);
            }
        } else if (lineColor != null && lineWidth > 0) {
            this.drawEmptyRRectWithWideLine(g, lineWidth, lineColor, x, y, w, h, radius);
        } else {
            this.drawEmptyRRect(g, lineWidth, lineColor, x, y, w, h, radius);
        }
    }

    private void drawFilledRRect(Graphics g, Color fillColor, int lineWidth, Color lineColor, int x, int y, int w, int h, int radius) {
        g.setColor(fillColor);
        g.fillRoundRect(x, y, w, h, radius, radius);
        if (lineColor != null && lineWidth == 1) {
            g.setColor(lineColor);
            g.drawRoundRect(x, y, w, h, radius, radius);
        }
    }

    private void drawFilledRRectWithWideLine(Graphics g, Color fillColor, int lineWidth, Color lineColor, int x, int y, int w, int h, int radius) {
        int lineWidth2 = lineWidth * 2;
        g.setColor(lineColor);
        g.fillRoundRect(x, y, w, h, radius, radius);
        g.setColor(fillColor);
        g.fillRoundRect(x + lineWidth, y + lineWidth, w - lineWidth2, h - lineWidth2, radius, radius);
    }

    private void drawEmptyRRect(Graphics g, int lineWidth, Color lineColor, int x, int y, int w, int h, int radius) {
        if (lineColor != null && lineWidth == 1) {
            g.setColor(lineColor);
            g.drawRoundRect(x, y, w, h, radius, radius);
        }
    }

    private void drawEmptyRRectWithWideLine(Graphics g, int lineWidth, Color lineColor, int x, int y, int w, int h, int radius) {
        if (lineColor != null && lineWidth > 1) {
            int xx = x;
            int yy = y;
            int ww = w;
            int hh = h;
            g.setColor(lineColor);
            for (int i = 0; i < lineWidth; ++i) {
                g.drawRoundRect(xx++, yy++, ww, hh, radius, radius);
                ww -= 2;
                hh -= 2;
            }
        }
    }
}

