/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import ro.deversoft.odf.gearbox.common.domain.JsonNodeWithLanguageIndication;
import ro.deversoft.odf.gearbox.common.domain.LanguageDDD;

public class JsonNodeI18List {
    private transient Map<String, JsonNode> i18Nodes = new Hashtable<String, JsonNode>();
    List<JsonNodeWithLanguageIndication> items;

    public List<JsonNodeWithLanguageIndication> getItems() {
        this.ensureItemsNotNull();
        return this.items;
    }

    public JsonNodeI18List() {
        this.ensureItemsNotNull();
    }

    public JsonNodeI18List(List<JsonNodeWithLanguageIndication> items) {
        for (JsonNodeWithLanguageIndication item : items) {
            this.add(item);
        }
    }

    private void ensureItemsNotNull() {
        if (this.items == null) {
            this.items = new ArrayList<JsonNodeWithLanguageIndication>();
        }
    }

    public boolean add(JsonNodeWithLanguageIndication jsonNodeWithLanguageIndication) {
        this.ensureItemsNotNull();
        boolean result = this.items.add(jsonNodeWithLanguageIndication);
        if (result) {
            this.i18Nodes.put(jsonNodeWithLanguageIndication.lang.code, jsonNodeWithLanguageIndication.payload);
        }
        return result;
    }

    public JsonNode getForLang(String lang, String defaultLang) {
        JsonNode resultInRequestedLang = this.i18Nodes.get(lang);
        if (resultInRequestedLang == null) {
            resultInRequestedLang = this.i18Nodes.get(defaultLang);
        }
        return resultInRequestedLang;
    }

    public void setForLang(LanguageDDD lang, JsonNode value) {
        JsonNodeWithLanguageIndication toadd = new JsonNodeWithLanguageIndication(value, lang);
        this.add(toadd);
    }

    public Map<String, JsonNode> getI18Nodes() {
        return this.i18Nodes;
    }

    public JsonNodeI18List setI18Nodes(Map<String, JsonNode> i18Nodes) {
        this.i18Nodes = i18Nodes;
        return this;
    }

    public JsonNodeI18List setItems(List<JsonNodeWithLanguageIndication> items) {
        this.items = items;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonNodeI18List)) {
            return false;
        }
        JsonNodeI18List other = (JsonNodeI18List)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<JsonNodeWithLanguageIndication> this$items = this.getItems();
        List<JsonNodeWithLanguageIndication> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonNodeI18List;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<JsonNodeWithLanguageIndication> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String toString() {
        return "JsonNodeI18List(i18Nodes=" + this.getI18Nodes() + ", items=" + this.getItems() + ")";
    }
}

