/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain.promotion;

import java.time.DayOfWeek;
import java.time.ZonedDateTime;
import ro.deversoft.odf.gearbox.common.CommonUtils;
import ro.deversoft.odf.gearbox.common.domain.promotion.ActiveBetweenHoursDDD;

public class WeeklyScheduleDDD {
    ActiveBetweenHoursDDD sunday;
    ActiveBetweenHoursDDD monday;
    ActiveBetweenHoursDDD tuesday;
    ActiveBetweenHoursDDD wednesday;
    ActiveBetweenHoursDDD thursday;
    ActiveBetweenHoursDDD friday;
    ActiveBetweenHoursDDD saturday;
    String timezoneId;

    public ActiveBetweenHoursDDD getDaySchedule(ZonedDateTime now) {
        DayOfWeek dayOfWeek = now.getDayOfWeek();
        String dayOfWeekFromDate = dayOfWeek.name().toLowerCase();
        return (ActiveBetweenHoursDDD)CommonUtils.runGetter(dayOfWeekFromDate, this);
    }

    public boolean atLeastOneDayOfWeekIsCompleted() {
        ActiveBetweenHoursDDD[] allDays;
        for (ActiveBetweenHoursDDD day : allDays = new ActiveBetweenHoursDDD[]{this.sunday, this.monday, this.tuesday, this.wednesday, this.thursday, this.friday, this.saturday}) {
            if (day == null || day.getIntervals() == null || day.getIntervals().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private static String $default$timezoneId() {
        return "UTC";
    }

    public static WeeklyScheduleDDDBuilder builder() {
        return new WeeklyScheduleDDDBuilder();
    }

    public ActiveBetweenHoursDDD getSunday() {
        return this.sunday;
    }

    public ActiveBetweenHoursDDD getMonday() {
        return this.monday;
    }

    public ActiveBetweenHoursDDD getTuesday() {
        return this.tuesday;
    }

    public ActiveBetweenHoursDDD getWednesday() {
        return this.wednesday;
    }

    public ActiveBetweenHoursDDD getThursday() {
        return this.thursday;
    }

    public ActiveBetweenHoursDDD getFriday() {
        return this.friday;
    }

    public ActiveBetweenHoursDDD getSaturday() {
        return this.saturday;
    }

    public String getTimezoneId() {
        return this.timezoneId;
    }

    public WeeklyScheduleDDD setSunday(ActiveBetweenHoursDDD sunday) {
        this.sunday = sunday;
        return this;
    }

    public WeeklyScheduleDDD setMonday(ActiveBetweenHoursDDD monday) {
        this.monday = monday;
        return this;
    }

    public WeeklyScheduleDDD setTuesday(ActiveBetweenHoursDDD tuesday) {
        this.tuesday = tuesday;
        return this;
    }

    public WeeklyScheduleDDD setWednesday(ActiveBetweenHoursDDD wednesday) {
        this.wednesday = wednesday;
        return this;
    }

    public WeeklyScheduleDDD setThursday(ActiveBetweenHoursDDD thursday) {
        this.thursday = thursday;
        return this;
    }

    public WeeklyScheduleDDD setFriday(ActiveBetweenHoursDDD friday) {
        this.friday = friday;
        return this;
    }

    public WeeklyScheduleDDD setSaturday(ActiveBetweenHoursDDD saturday) {
        this.saturday = saturday;
        return this;
    }

    public WeeklyScheduleDDD setTimezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
        return this;
    }

    public WeeklyScheduleDDD() {
        this.timezoneId = WeeklyScheduleDDD.$default$timezoneId();
    }

    public WeeklyScheduleDDD(ActiveBetweenHoursDDD sunday, ActiveBetweenHoursDDD monday, ActiveBetweenHoursDDD tuesday, ActiveBetweenHoursDDD wednesday, ActiveBetweenHoursDDD thursday, ActiveBetweenHoursDDD friday, ActiveBetweenHoursDDD saturday, String timezoneId) {
        this.sunday = sunday;
        this.monday = monday;
        this.tuesday = tuesday;
        this.wednesday = wednesday;
        this.thursday = thursday;
        this.friday = friday;
        this.saturday = saturday;
        this.timezoneId = timezoneId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeeklyScheduleDDD)) {
            return false;
        }
        WeeklyScheduleDDD other = (WeeklyScheduleDDD)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ActiveBetweenHoursDDD this$sunday = this.getSunday();
        ActiveBetweenHoursDDD other$sunday = other.getSunday();
        if (this$sunday == null ? other$sunday != null : !((Object)this$sunday).equals(other$sunday)) {
            return false;
        }
        ActiveBetweenHoursDDD this$monday = this.getMonday();
        ActiveBetweenHoursDDD other$monday = other.getMonday();
        if (this$monday == null ? other$monday != null : !((Object)this$monday).equals(other$monday)) {
            return false;
        }
        ActiveBetweenHoursDDD this$tuesday = this.getTuesday();
        ActiveBetweenHoursDDD other$tuesday = other.getTuesday();
        if (this$tuesday == null ? other$tuesday != null : !((Object)this$tuesday).equals(other$tuesday)) {
            return false;
        }
        ActiveBetweenHoursDDD this$wednesday = this.getWednesday();
        ActiveBetweenHoursDDD other$wednesday = other.getWednesday();
        if (this$wednesday == null ? other$wednesday != null : !((Object)this$wednesday).equals(other$wednesday)) {
            return false;
        }
        ActiveBetweenHoursDDD this$thursday = this.getThursday();
        ActiveBetweenHoursDDD other$thursday = other.getThursday();
        if (this$thursday == null ? other$thursday != null : !((Object)this$thursday).equals(other$thursday)) {
            return false;
        }
        ActiveBetweenHoursDDD this$friday = this.getFriday();
        ActiveBetweenHoursDDD other$friday = other.getFriday();
        if (this$friday == null ? other$friday != null : !((Object)this$friday).equals(other$friday)) {
            return false;
        }
        ActiveBetweenHoursDDD this$saturday = this.getSaturday();
        ActiveBetweenHoursDDD other$saturday = other.getSaturday();
        if (this$saturday == null ? other$saturday != null : !((Object)this$saturday).equals(other$saturday)) {
            return false;
        }
        String this$timezoneId = this.getTimezoneId();
        String other$timezoneId = other.getTimezoneId();
        return !(this$timezoneId == null ? other$timezoneId != null : !this$timezoneId.equals(other$timezoneId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeeklyScheduleDDD;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ActiveBetweenHoursDDD $sunday = this.getSunday();
        result = result * 59 + ($sunday == null ? 43 : ((Object)$sunday).hashCode());
        ActiveBetweenHoursDDD $monday = this.getMonday();
        result = result * 59 + ($monday == null ? 43 : ((Object)$monday).hashCode());
        ActiveBetweenHoursDDD $tuesday = this.getTuesday();
        result = result * 59 + ($tuesday == null ? 43 : ((Object)$tuesday).hashCode());
        ActiveBetweenHoursDDD $wednesday = this.getWednesday();
        result = result * 59 + ($wednesday == null ? 43 : ((Object)$wednesday).hashCode());
        ActiveBetweenHoursDDD $thursday = this.getThursday();
        result = result * 59 + ($thursday == null ? 43 : ((Object)$thursday).hashCode());
        ActiveBetweenHoursDDD $friday = this.getFriday();
        result = result * 59 + ($friday == null ? 43 : ((Object)$friday).hashCode());
        ActiveBetweenHoursDDD $saturday = this.getSaturday();
        result = result * 59 + ($saturday == null ? 43 : ((Object)$saturday).hashCode());
        String $timezoneId = this.getTimezoneId();
        result = result * 59 + ($timezoneId == null ? 43 : $timezoneId.hashCode());
        return result;
    }

    public String toString() {
        return "WeeklyScheduleDDD(super=" + super.toString() + ", sunday=" + this.getSunday() + ", monday=" + this.getMonday() + ", tuesday=" + this.getTuesday() + ", wednesday=" + this.getWednesday() + ", thursday=" + this.getThursday() + ", friday=" + this.getFriday() + ", saturday=" + this.getSaturday() + ", timezoneId=" + this.getTimezoneId() + ")";
    }

    public static class WeeklyScheduleDDDBuilder {
        private ActiveBetweenHoursDDD sunday;
        private ActiveBetweenHoursDDD monday;
        private ActiveBetweenHoursDDD tuesday;
        private ActiveBetweenHoursDDD wednesday;
        private ActiveBetweenHoursDDD thursday;
        private ActiveBetweenHoursDDD friday;
        private ActiveBetweenHoursDDD saturday;
        private boolean timezoneId$set;
        private String timezoneId$value;

        WeeklyScheduleDDDBuilder() {
        }

        public WeeklyScheduleDDDBuilder setSunday(ActiveBetweenHoursDDD sunday) {
            this.sunday = sunday;
            return this;
        }

        public WeeklyScheduleDDDBuilder setMonday(ActiveBetweenHoursDDD monday) {
            this.monday = monday;
            return this;
        }

        public WeeklyScheduleDDDBuilder setTuesday(ActiveBetweenHoursDDD tuesday) {
            this.tuesday = tuesday;
            return this;
        }

        public WeeklyScheduleDDDBuilder setWednesday(ActiveBetweenHoursDDD wednesday) {
            this.wednesday = wednesday;
            return this;
        }

        public WeeklyScheduleDDDBuilder setThursday(ActiveBetweenHoursDDD thursday) {
            this.thursday = thursday;
            return this;
        }

        public WeeklyScheduleDDDBuilder setFriday(ActiveBetweenHoursDDD friday) {
            this.friday = friday;
            return this;
        }

        public WeeklyScheduleDDDBuilder setSaturday(ActiveBetweenHoursDDD saturday) {
            this.saturday = saturday;
            return this;
        }

        public WeeklyScheduleDDDBuilder setTimezoneId(String timezoneId) {
            this.timezoneId$value = timezoneId;
            this.timezoneId$set = true;
            return this;
        }

        public WeeklyScheduleDDD build() {
            String timezoneId$value = this.timezoneId$value;
            if (!this.timezoneId$set) {
                timezoneId$value = WeeklyScheduleDDD.$default$timezoneId();
            }
            return new WeeklyScheduleDDD(this.sunday, this.monday, this.tuesday, this.wednesday, this.thursday, this.friday, this.saturday, timezoneId$value);
        }

        public String toString() {
            return "WeeklyScheduleDDD.WeeklyScheduleDDDBuilder(sunday=" + this.sunday + ", monday=" + this.monday + ", tuesday=" + this.tuesday + ", wednesday=" + this.wednesday + ", thursday=" + this.thursday + ", friday=" + this.friday + ", saturday=" + this.saturday + ", timezoneId$value=" + this.timezoneId$value + ")";
        }
    }
}

