/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.eventsourcing;

import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.deversoft.odf.gearbox.common.exception.ODFRuntimeException;
import ro.deversoft.odf.gearbox.eventsourcing.EventSourcingLedger;
import ro.deversoft.odf.gearbox.eventsourcing.LedgerEvent;
import ro.deversoft.odf.gearbox.eventsourcing.LedgerException;
import ro.deversoft.odf.gearbox.eventsourcing.LedgerSnapshot;

public abstract class AbstractEventSourcingLedger<LE extends LedgerEvent<LE, LS>, LS extends LedgerSnapshot<LE, LS>>
implements EventSourcingLedger<LE, LS> {
    private static final Logger log = LoggerFactory.getLogger(AbstractEventSourcingLedger.class);
    static final String CANNOT_INITIALIZE_THE_LEDGER_SNAPSHOT_SINCE_ONE_THERE_IS_ALREADY_IN_PLACE = "Cannot initialize the ledger snapshot since one there is already in place!";
    private AtomicReference<LS> ledgerSnapshotRef = new AtomicReference<Object>(null);

    @Override
    public final void setInitialLedgerSnapshot(@NonNull LS initialLedgerSnapshot) {
        if (initialLedgerSnapshot == null) {
            throw new NullPointerException("initialLedgerSnapshot is marked non-null but is null");
        }
        boolean wasSet = this.ledgerSnapshotRef.compareAndSet(null, initialLedgerSnapshot);
        if (!wasSet) {
            throw new ODFRuntimeException(CANNOT_INITIALIZE_THE_LEDGER_SNAPSHOT_SINCE_ONE_THERE_IS_ALREADY_IN_PLACE);
        }
    }

    @Override
    public LS acceptNewLedgerEvent(@NonNull LE ledgerEvent) throws LedgerException {
        Object advancedStepSnapshot;
        LedgerSnapshot existingSnaphot;
        boolean wasSnapshotAdvanced;
        if (ledgerEvent == null) {
            throw new NullPointerException("ledgerEvent is marked non-null but is null");
        }
        if (this.ledgerSnapshotRef.get() == null) {
            throw LedgerException.UNINITIALZED_LEDGER_EXCEPTION;
        }
        while (!(wasSnapshotAdvanced = this.ledgerSnapshotRef.compareAndSet(existingSnaphot = (LedgerSnapshot)this.ledgerSnapshotRef.get(), advancedStepSnapshot = existingSnaphot.applyLedgerEvent(ledgerEvent)))) {
        }
        log.trace("Event applied, new state : {}", advancedStepSnapshot);
        return advancedStepSnapshot;
    }

    @Override
    public LS getCurrentLedgerSnapshot() throws LedgerException {
        return (LS)((LedgerSnapshot)this.ledgerSnapshotRef.get());
    }
}

