/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import javax.imageio.ImageIO;

public final class MatrixToImageWriter {
    private static final MatrixToImageConfig a = new MatrixToImageConfig();

    private MatrixToImageWriter() {
    }

    public static BufferedImage toBufferedImage(BitMatrix bitMatrix) {
        return MatrixToImageWriter.toBufferedImage(bitMatrix, a);
    }

    public static BufferedImage toBufferedImage(BitMatrix bitMatrix, MatrixToImageConfig matrixToImageConfig) {
        int n2 = bitMatrix.getWidth();
        int n3 = bitMatrix.getHeight();
        Object object = matrixToImageConfig;
        object = new BufferedImage(n2, n3, ((MatrixToImageConfig)object).a == -16777216 && ((MatrixToImageConfig)object).b == -1 ? 12 : (MatrixToImageConfig.a(((MatrixToImageConfig)object).a) || MatrixToImageConfig.a(((MatrixToImageConfig)object).b) ? 2 : 1));
        int n4 = matrixToImageConfig.getPixelOnColor();
        int n5 = matrixToImageConfig.getPixelOffColor();
        int[] nArray = new int[n2];
        BitArray bitArray = new BitArray(n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            bitArray = bitMatrix.getRow(i2, bitArray);
            for (int i3 = 0; i3 < n2; ++i3) {
                nArray[i3] = bitArray.get(i3) ? n4 : n5;
            }
            ((BufferedImage)object).setRGB(0, i2, n2, 1, nArray, 0, n2);
        }
        return object;
    }

    @Deprecated
    public static void writeToFile(BitMatrix bitMatrix, String string, File file) {
        MatrixToImageWriter.writeToPath(bitMatrix, string, file.toPath());
    }

    public static void writeToPath(BitMatrix bitMatrix, String string, Path path) {
        MatrixToImageWriter.writeToPath(bitMatrix, string, path, a);
    }

    @Deprecated
    public static void writeToFile(BitMatrix bitMatrix, String string, File file, MatrixToImageConfig matrixToImageConfig) {
        MatrixToImageWriter.writeToPath(bitMatrix, string, file.toPath(), matrixToImageConfig);
    }

    public static void writeToPath(BitMatrix bitMatrix, String string, Path path, MatrixToImageConfig matrixToImageConfig) {
        if (!ImageIO.write((RenderedImage)MatrixToImageWriter.toBufferedImage(bitMatrix, matrixToImageConfig), string, path.toFile())) {
            throw new IOException("Could not write an image of format " + string + " to " + path);
        }
    }

    public static void writeToStream(BitMatrix bitMatrix, String string, OutputStream outputStream) {
        MatrixToImageWriter.writeToStream(bitMatrix, string, outputStream, a);
    }

    public static void writeToStream(BitMatrix bitMatrix, String string, OutputStream outputStream, MatrixToImageConfig matrixToImageConfig) {
        if (!ImageIO.write((RenderedImage)MatrixToImageWriter.toBufferedImage(bitMatrix, matrixToImageConfig), string, outputStream)) {
            throw new IOException("Could not write an image of format " + string);
        }
    }
}

