/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.encoder.Compaction;
import com.google.zxing.pdf417.encoder.Dimensions;
import com.google.zxing.pdf417.encoder.PDF417;
import java.nio.charset.Charset;
import java.util.Map;

public final class PDF417Writer
implements Writer {
    @Override
    public final BitMatrix encode(String object, BarcodeFormat object2, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (object2 != BarcodeFormat.PDF_417) {
            throw new IllegalArgumentException("Can only encode PDF_417, but got " + (Object)object2);
        }
        object2 = new PDF417();
        int n4 = 30;
        int n5 = 2;
        if (map != null) {
            Object object3;
            if (map.containsKey((Object)EncodeHintType.PDF417_COMPACT)) {
                ((PDF417)object2).setCompact(Boolean.valueOf(map.get((Object)EncodeHintType.PDF417_COMPACT).toString()));
            }
            if (map.containsKey((Object)EncodeHintType.PDF417_COMPACTION)) {
                ((PDF417)object2).setCompaction(Compaction.valueOf(map.get((Object)EncodeHintType.PDF417_COMPACTION).toString()));
            }
            if (map.containsKey((Object)EncodeHintType.PDF417_DIMENSIONS)) {
                object3 = (Dimensions)map.get((Object)EncodeHintType.PDF417_DIMENSIONS);
                ((PDF417)object2).setDimensions(((Dimensions)object3).getMaxCols(), ((Dimensions)object3).getMinCols(), ((Dimensions)object3).getMaxRows(), ((Dimensions)object3).getMinRows());
            }
            if (map.containsKey((Object)EncodeHintType.MARGIN)) {
                n4 = Integer.parseInt(map.get((Object)EncodeHintType.MARGIN).toString());
            }
            if (map.containsKey((Object)EncodeHintType.ERROR_CORRECTION)) {
                n5 = Integer.parseInt(map.get((Object)EncodeHintType.ERROR_CORRECTION).toString());
            }
            if (map.containsKey((Object)EncodeHintType.CHARACTER_SET)) {
                object3 = Charset.forName(map.get((Object)EncodeHintType.CHARACTER_SET).toString());
                ((PDF417)object2).setEncoding((Charset)object3);
            }
        }
        BarcodeFormat barcodeFormat = object2;
        int n6 = n3;
        n3 = n2;
        n2 = n5;
        object2 = object;
        object = barcodeFormat;
        ((PDF417)((Object)barcodeFormat)).generateBarcodeLogic((String)object2, n2);
        object2 = ((PDF417)object).getBarcodeMatrix().getScaledMatrix(1, 4);
        n2 = 0;
        if (n6 > n3 != ((BarcodeFormat)object2[0]).length < ((BarcodeFormat)object2).length) {
            object2 = PDF417Writer.a((byte[][])object2);
            n2 = 1;
        }
        if ((n3 /= ((Object)object2[0]).length) >= (n6 /= ((BarcodeFormat)object2).length)) {
            n3 = n6;
        }
        if (n3 > 1) {
            object = ((PDF417)object).getBarcodeMatrix().getScaledMatrix(n3, n3 << 2);
            if (n2 != 0) {
                object = PDF417Writer.a((byte[][])object);
            }
            return PDF417Writer.a((byte[][])object, n4);
        }
        return PDF417Writer.a((byte[][])object2, n4);
    }

    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string, barcodeFormat, n2, n3, null);
    }

    private static BitMatrix a(byte[][] byArray, int n2) {
        BitMatrix bitMatrix = new BitMatrix(byArray[0].length + 2 * n2, byArray.length + 2 * n2);
        bitMatrix.clear();
        int n3 = 0;
        int n4 = bitMatrix.getHeight() - n2 - 1;
        while (n3 < byArray.length) {
            byte[] byArray2 = byArray[n3];
            for (int i2 = 0; i2 < byArray[0].length; ++i2) {
                if (byArray2[i2] != 1) continue;
                bitMatrix.set(i2 + n2, n4);
            }
            ++n3;
            --n4;
        }
        return bitMatrix;
    }

    private static byte[][] a(byte[][] byArray) {
        byte[][] byArray2 = new byte[byArray[0].length][byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray.length - i2 - 1;
            for (int i3 = 0; i3 < byArray[0].length; ++i3) {
                byArray2[i3][n2] = byArray[i2][i3];
            }
        }
        return byArray2;
    }
}

