/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.encoder;

import com.google.zxing.WriterException;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.pdf417.encoder.Compaction;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
final class PDF417HighLevelEncoder {
    private static final byte[] a;
    private static final byte[] b;
    private static final byte[] c;
    private static final byte[] d;
    private static final Charset a;

    private PDF417HighLevelEncoder() {
    }

    static String a(String string, Compaction compaction, Charset charset) {
        CharacterSetECI characterSetECI;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        if (charset == null) {
            charset = a;
        } else if (!a.equals(charset) && (characterSetECI = CharacterSetECI.getCharacterSetECIByName(charset.name())) != null) {
            StringBuilder stringBuilder2 = stringBuilder;
            int n2 = characterSetECI.getValue();
            if (n2 >= 0 && n2 < 900) {
                stringBuilder2.append('\u039f');
                stringBuilder2.append((char)n2);
            } else if (n2 < 810900) {
                stringBuilder2.append('\u039e');
                stringBuilder2.append((char)(n2 / 900 - 1));
                stringBuilder2.append((char)(n2 % 900));
            } else if (n2 < 811800) {
                stringBuilder2.append('\u039d');
                stringBuilder2.append((char)(810900 - n2));
            } else {
                throw new WriterException("ECI number not in valid range from 0..811799, but was " + n2);
            }
        }
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        switch (compaction) {
            case TEXT: {
                PDF417HighLevelEncoder.a(string, 0, n3, stringBuilder, 0);
                break;
            }
            case BYTE: {
                byte[] byArray = string.getBytes(charset);
                PDF417HighLevelEncoder.a(byArray, byArray.length, 1, stringBuilder);
                break;
            }
            case NUMERIC: {
                stringBuilder.append('\u0386');
                PDF417HighLevelEncoder.a(string, 0, n3, stringBuilder);
                break;
            }
            default: {
                int n6 = 0;
                while (n4 < n3) {
                    byte[] byArray;
                    int n7 = PDF417HighLevelEncoder.a(string, n4);
                    if (n7 >= 13) {
                        stringBuilder.append('\u0386');
                        n6 = 2;
                        n5 = 0;
                        PDF417HighLevelEncoder.a(string, n4, n7, stringBuilder);
                        n4 += n7;
                        continue;
                    }
                    int n8 = PDF417HighLevelEncoder.b(string, n4);
                    if (n8 >= 5 || n7 == n3) {
                        if (n6 != 0) {
                            stringBuilder.append('\u0384');
                            n6 = 0;
                            n5 = 0;
                        }
                        n5 = PDF417HighLevelEncoder.a(string, n4, n8, stringBuilder, n5);
                        n4 += n8;
                        continue;
                    }
                    n7 = PDF417HighLevelEncoder.a(string, n4, charset);
                    if (n7 == 0) {
                        n7 = 1;
                    }
                    if ((byArray = string.substring(n4, n4 + n7).getBytes(charset)).length == 1 && n6 == 0) {
                        PDF417HighLevelEncoder.a(byArray, 1, 0, stringBuilder);
                    } else {
                        PDF417HighLevelEncoder.a(byArray, byArray.length, n6, stringBuilder);
                        n6 = 1;
                        n5 = 0;
                    }
                    n4 += n7;
                }
                break block0;
            }
        }
        return stringBuilder.toString();
    }

    private static int a(CharSequence charSequence, int n2, int n3, StringBuilder stringBuilder, int n4) {
        char c2;
        StringBuilder stringBuilder2 = new StringBuilder(n3);
        int n5 = 0;
        block5: while (true) {
            c2 = charSequence.charAt(n2 + n5);
            switch (n4) {
                case 0: {
                    if (PDF417HighLevelEncoder.b(c2)) {
                        if (c2 == ' ') {
                            stringBuilder2.append('\u001a');
                            break;
                        }
                        stringBuilder2.append((char)(c2 - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.c(c2)) {
                        n4 = 1;
                        stringBuilder2.append('\u001b');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.d(c2)) {
                        n4 = 2;
                        stringBuilder2.append('\u001c');
                        continue block5;
                    }
                    stringBuilder2.append('\u001d');
                    stringBuilder2.append((char)d[c2]);
                    break;
                }
                case 1: {
                    if (PDF417HighLevelEncoder.c(c2)) {
                        if (c2 == ' ') {
                            stringBuilder2.append('\u001a');
                            break;
                        }
                        stringBuilder2.append((char)(c2 - 97));
                        break;
                    }
                    if (PDF417HighLevelEncoder.b(c2)) {
                        stringBuilder2.append('\u001b');
                        stringBuilder2.append((char)(c2 - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.d(c2)) {
                        n4 = 2;
                        stringBuilder2.append('\u001c');
                        continue block5;
                    }
                    stringBuilder2.append('\u001d');
                    stringBuilder2.append((char)d[c2]);
                    break;
                }
                case 2: {
                    if (PDF417HighLevelEncoder.d(c2)) {
                        stringBuilder2.append((char)c[c2]);
                        break;
                    }
                    if (PDF417HighLevelEncoder.b(c2)) {
                        n4 = 0;
                        stringBuilder2.append('\u001c');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.c(c2)) {
                        n4 = 1;
                        stringBuilder2.append('\u001b');
                        continue block5;
                    }
                    if (n2 + n5 + 1 < n3 && PDF417HighLevelEncoder.e(charSequence.charAt(n2 + n5 + 1))) {
                        n4 = 3;
                        stringBuilder2.append('\u0019');
                        continue block5;
                    }
                    stringBuilder2.append('\u001d');
                    stringBuilder2.append((char)d[c2]);
                    break;
                }
                default: {
                    if (PDF417HighLevelEncoder.e(c2)) {
                        stringBuilder2.append((char)d[c2]);
                        break;
                    }
                    n4 = 0;
                    stringBuilder2.append('\u001d');
                    continue block5;
                }
            }
            if (++n5 >= n3) break;
        }
        c2 = '\u0000';
        n2 = stringBuilder2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 % 2 != 0) {
                c2 = (char)(c2 * 30 + stringBuilder2.charAt(i2));
                stringBuilder.append(c2);
                continue;
            }
            c2 = stringBuilder2.charAt(i2);
        }
        if (n2 % 2 != 0) {
            stringBuilder.append((char)(c2 * 30 + 29));
        }
        return n4;
    }

    private static void a(byte[] byArray, int n2, int n3, StringBuilder stringBuilder) {
        if (n2 == 1 && n3 == 0) {
            stringBuilder.append('\u0391');
        } else if (n2 % 6 == 0) {
            stringBuilder.append('\u039c');
        } else {
            stringBuilder.append('\u0385');
        }
        int n4 = 0;
        if (n2 >= 6) {
            char[] cArray = new char[5];
            while (n2 - n4 >= 6) {
                int n5;
                long l2 = 0L;
                for (n5 = 0; n5 < 6; ++n5) {
                    l2 = (l2 << 8) + (long)(byArray[n4 + n5] & 0xFF);
                }
                for (n5 = 0; n5 < 5; ++n5) {
                    cArray[n5] = (char)(l2 % 900L);
                    l2 /= 900L;
                }
                for (n5 = 4; n5 >= 0; --n5) {
                    stringBuilder.append(cArray[n5]);
                }
                n4 += 6;
            }
        }
        for (n3 = n4; n3 < n2; ++n3) {
            int n6 = byArray[n3] & 0xFF;
            stringBuilder.append((char)n6);
        }
    }

    private static void a(String string, int n2, int n3, StringBuilder stringBuilder) {
        int n4;
        StringBuilder stringBuilder2 = new StringBuilder(n3 / 3 + 1);
        BigInteger bigInteger = BigInteger.valueOf(900L);
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        for (int i2 = 0; i2 < n3; i2 += n4) {
            stringBuilder2.setLength(0);
            n4 = Math.min(44, n3 - i2);
            Object object = "1" + string.substring(n2 + i2, n2 + i2 + n4);
            object = new BigInteger((String)object);
            do {
                stringBuilder2.append((char)((BigInteger)object).mod(bigInteger).intValue());
            } while (!((BigInteger)(object = ((BigInteger)object).divide(bigInteger))).equals(bigInteger2));
            for (int i3 = stringBuilder2.length() - 1; i3 >= 0; --i3) {
                stringBuilder.append(stringBuilder2.charAt(i3));
            }
        }
    }

    private static boolean a(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static boolean b(char c2) {
        return c2 == ' ' || c2 >= 'A' && c2 <= 'Z';
    }

    private static boolean c(char c2) {
        return c2 == ' ' || c2 >= 'a' && c2 <= 'z';
    }

    private static boolean d(char c2) {
        return c[c2] != -1;
    }

    private static boolean e(char c2) {
        return d[c2] != -1;
    }

    private static int a(CharSequence charSequence, int n2) {
        int n3 = 0;
        int n4 = charSequence.length();
        if (n2 < n4) {
            char c2 = charSequence.charAt(n2);
            while (PDF417HighLevelEncoder.a(c2) && n2 < n4) {
                ++n3;
                if (++n2 >= n4) continue;
                c2 = charSequence.charAt(n2);
            }
        }
        return n3;
    }

    private static int b(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        int n4 = n2;
        while (n4 < n3) {
            int n5;
            char c2 = charSequence.charAt(n4);
            for (n5 = 0; n5 < 13 && PDF417HighLevelEncoder.a(c2) && n4 < n3; ++n5) {
                if (++n4 >= n3) continue;
                c2 = charSequence.charAt(n4);
            }
            if (n5 >= 13) {
                return n4 - n2 - n5;
            }
            if (n5 > 0) continue;
            c2 = charSequence.charAt(n4);
            if (!(c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 >= ' ' && c2 <= '~')) break;
            ++n4;
        }
        return n4 - n2;
    }

    private static int a(String string, int n2, Charset object) {
        int n3;
        object = ((Charset)object).newEncoder();
        int n4 = string.length();
        for (n3 = n2; n3 < n4; ++n3) {
            char c2 = string.charAt(n3);
            int n5 = 0;
            while (n5 < 13 && PDF417HighLevelEncoder.a(c2) && (c2 = n3 + ++n5) < n4) {
                c2 = string.charAt(c2);
            }
            if (n5 >= 13) {
                return n3 - n2;
            }
            c2 = string.charAt(n3);
            if (((CharsetEncoder)object).canEncode(c2)) continue;
            throw new WriterException("Non-encodable character detected: " + c2 + " (Unicode: " + c2 + ')');
        }
        return n3 - n2;
    }

    static {
        byte by2;
        int n2;
        a = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 38, 13, 9, 44, 58, 35, 45, 46, 36, 47, 43, 37, 42, 61, 94, 0, 32, 0, 0, 0};
        b = new byte[]{59, 60, 62, 64, 91, 92, 93, 95, 96, 126, 33, 13, 9, 44, 58, 10, 45, 46, 36, 47, 34, 124, 42, 40, 41, 63, 123, 125, 39, 0};
        c = new byte[128];
        d = new byte[128];
        a = Charset.forName("ISO-8859-1");
        Arrays.fill(c, (byte)-1);
        for (n2 = 0; n2 < 30; ++n2) {
            by2 = a[n2];
            if (by2 <= 0) continue;
            PDF417HighLevelEncoder.c[by2] = (byte)n2;
        }
        Arrays.fill(d, (byte)-1);
        for (n2 = 0; n2 < 30; ++n2) {
            by2 = b[n2];
            if (by2 <= 0) continue;
            PDF417HighLevelEncoder.d[by2] = (byte)n2;
        }
    }
}

