/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import java.sql.SQLException;

public abstract class BaseArgumentHolder
implements w {
    private String columnName = null;
    private FieldType fieldType = null;
    private SqlType sqlType = null;

    public BaseArgumentHolder() {
    }

    public BaseArgumentHolder(String string) {
        this.columnName = string;
    }

    public BaseArgumentHolder(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    protected abstract Object getValue();

    @Override
    public abstract void setValue(Object var1);

    protected abstract boolean isValueSet();

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    public void setMetaInfo(String string) {
        if (this.columnName != null && !this.columnName.equals(string)) {
            throw new IllegalArgumentException("Column name cannot be set twice from " + this.columnName + " to " + string + ".  Using a SelectArg twice in query with different columns?");
        }
        this.columnName = string;
    }

    @Override
    public void setMetaInfo(FieldType fieldType) {
        if (this.fieldType != null && this.fieldType != fieldType) {
            throw new IllegalArgumentException("FieldType name cannot be set twice from " + this.fieldType + " to " + fieldType + ".  Using a SelectArg twice in query with different columns?");
        }
        this.fieldType = fieldType;
    }

    @Override
    public void setMetaInfo(String string, FieldType fieldType) {
        this.setMetaInfo(string);
        this.setMetaInfo(fieldType);
    }

    @Override
    public Object getSqlArgValue() {
        if (!this.isValueSet()) {
            throw new SQLException("Column value has not been set for " + this.columnName);
        }
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        if (this.fieldType == null) {
            return object;
        }
        if (this.fieldType.isForeign() && this.fieldType.getType() == object.getClass()) {
            return this.fieldType.getForeignIdField().extractJavaFieldValue(object);
        }
        return this.fieldType.convertJavaFieldToSqlArgValue(object);
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    public String toString() {
        if (!this.isValueSet()) {
            return "[unset]";
        }
        try {
            Object object = this.getSqlArgValue();
            if (object == null) {
                return "[null]";
            }
            return object.toString();
        }
        catch (SQLException sQLException) {
            return "[could not get value: " + sQLException + "]";
        }
    }
}

