/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.internal.AgiChannelFactory;
import org.asteriskjava.fastagi.internal.DefaultAgiChannelFactory;
import org.asteriskjava.util.DaemonThreadFactory;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class AbstractAgiServer {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = 100;
    private int poolSize = 10;
    private int maximumPoolSize = 100;
    private ThreadPoolExecutor pool;
    private MappingStrategy mappingStrategy;
    private final AgiChannelFactory agiChannelFactory;
    private volatile boolean die = false;

    public AbstractAgiServer() {
        this(new DefaultAgiChannelFactory());
    }

    public AbstractAgiServer(AgiChannelFactory agiChannelFactory) {
        if (agiChannelFactory == null) {
            throw new IllegalArgumentException("AgiChannelFactory must not be null");
        }
        this.logger.debug("Using channelFactory " + agiChannelFactory.getClass().getCanonicalName());
        this.agiChannelFactory = agiChannelFactory;
    }

    protected AgiChannelFactory getAgiChannelFactory() {
        return this.agiChannelFactory;
    }

    public synchronized int getPoolSize() {
        return this.poolSize;
    }

    public synchronized void setPoolSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("New poolSize (" + n2 + ") is must not be negative");
        }
        if (this.pool != null) {
            this.pool.setCorePoolSize(n2);
        }
        this.poolSize = n2;
    }

    public synchronized int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public synchronized void setMaximumPoolSize(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("New maximumPoolSize (" + n2 + ") is must be positive");
        }
        if (n2 < this.poolSize) {
            throw new IllegalArgumentException("New maximumPoolSize (" + n2 + ") is less than current pool size (" + this.poolSize + ")");
        }
        if (this.pool != null) {
            this.pool.setMaximumPoolSize(n2);
        }
        this.maximumPoolSize = n2;
    }

    public void setMappingStrategy(MappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    protected MappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    protected boolean isDie() {
        return this.die;
    }

    protected synchronized void shutdown() {
        this.die = true;
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    protected void finalize() {
        super.finalize();
        this.die = true;
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    protected void execute(Runnable runnable) {
        if (this.isDie()) {
            this.logger.warn("AgiServer is shutting down: Refused to execute AgiScript");
            return;
        }
        this.getPool().execute(runnable);
    }

    protected void handleException(String string, Exception exception) {
        this.logger.warn(string, exception);
    }

    private synchronized ThreadPoolExecutor getPool() {
        if (this.pool == null) {
            this.pool = this.createPool();
            this.logger.info("Thread pool started.");
        }
        return this.pool;
    }

    public int getPoolActiveTaskCount() {
        if (this.pool != null) {
            return this.pool.getActiveCount();
        }
        return -1;
    }

    public int getPoolActiveThreadCount() {
        if (this.pool != null) {
            return this.pool.getPoolSize();
        }
        return -1;
    }

    protected ThreadPoolExecutor createPool() {
        return new ThreadPoolExecutor(this.poolSize, this.maximumPoolSize < this.poolSize ? this.poolSize : this.maximumPoolSize, 50000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory());
    }
}

