/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class AbstractMappingStrategy
implements MappingStrategy {
    protected Log logger = LogFactory.getLog(this.getClass());
    private static final String[] DEFAULT_SCRIPT_PATH = new String[]{"agi"};
    private ClassLoader defaultClassLoader = null;

    @Override
    public AgiScript determineScript(AgiRequest agiRequest, AgiChannel agiChannel) {
        return this.determineScript(agiRequest);
    }

    public abstract AgiScript determineScript(AgiRequest var1);

    protected synchronized ClassLoader getClassLoader() {
        if (this.defaultClassLoader == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ArrayList<URL> arrayList = new ArrayList<URL>();
            String[] stringArray = DEFAULT_SCRIPT_PATH;
            int n2 = DEFAULT_SCRIPT_PATH.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = stringArray[i2];
                if (!((File)(object = new File((String)object))).isDirectory()) continue;
                try {
                    arrayList.add(((File)object).toURI().toURL());
                    continue;
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (arrayList.size() == 0) {
                return classLoader;
            }
            this.defaultClassLoader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), classLoader);
        }
        return this.defaultClassLoader;
    }

    protected AgiScript createAgiScriptInstance(String string) {
        Class<?> clazz;
        AgiScript agiScript = null;
        try {
            clazz = this.getClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.debug("Unable to create AgiScript instance of type " + string + ": Class not found, make sure the class exists and is available on the CLASSPATH");
            return null;
        }
        if (!AgiScript.class.isAssignableFrom(clazz)) {
            this.logger.warn("Unable to create AgiScript instance of type " + string + ": Class does not implement the AgiScript interface");
            return null;
        }
        try {
            agiScript = (AgiScript)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            this.logger.warn("Unable to create AgiScript instance of type " + string, exception);
        }
        return agiScript;
    }
}

