/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Timer;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.util.Localizer;

public class ModeDragScroll
extends FigModifyingModeImpl
implements ActionListener {
    private static final long serialVersionUID = -3744868964626889125L;
    private Dimension _viewportExtent;
    private boolean autoscroll = false;
    private Timer autoTimer;
    private int recentX;
    private int recentY;
    private static final int AUTOSCROLL_DELAY = 200;
    private static final int SCROLL_INCREMENT = 10;
    private boolean _isScrolling = false;
    private JViewport _viewport = null;
    private Cursor _oldCursor = null;
    private JComponent _component = null;
    private Dimension componentSize = null;
    private Point viewPosition = new Point();
    private int deltaX;
    private int deltaY;
    private int lastX;
    private int lastY;
    private boolean simpleDrag = false;

    public ModeDragScroll(Editor editor) {
        super(editor);
        this.autoTimer = new Timer(200, this);
    }

    public ModeDragScroll() {
        this((Editor)null);
    }

    @Override
    public boolean canExit() {
        return false;
    }

    @Override
    public String instructions() {
        return Localizer.localize("GefBase", "ModeDragScrollInstructions");
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl2 = (mouseEvent.getModifiersEx() & 0xA80) == 2048;
        boolean bl3 = this.simpleDrag = (mouseEvent.getModifiersEx() & 0x1CC0) == 1024;
        if (!bl2) {
            return;
        }
        this._component = this.editor.getJComponent();
        if (this._component == null) {
            return;
        }
        Container container = this._component.getParent();
        if (!(container instanceof JViewport)) {
            return;
        }
        this._isScrolling = true;
        mouseEvent = this.editor.retranslateMouseEvent(mouseEvent);
        this._viewport = (JViewport)container;
        this.viewPosition = this._viewport.getViewPosition();
        this._viewportExtent = this._viewport.getExtentSize();
        this.componentSize = this._component.getSize();
        this.deltaX = 0;
        this.deltaY = 0;
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        this._oldCursor = this._component.getCursor();
        this._component.setCursor(Cursor.getPredefinedCursor(13));
        mouseEvent.consume();
        this.editor.translateMouseEvent(mouseEvent);
        if (this.simpleDrag) {
            this.autoTimer.stop();
            this.autoscroll = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.simpleDrag) {
            mouseEvent = this.editor.retranslateMouseEvent(mouseEvent);
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            this.recentX = n2;
            this.recentY = n3;
            JComponent jComponent = this.editor.getJComponent();
            if (jComponent != null && jComponent.getParent() instanceof JViewport) {
                boolean bl2 = this.doScroll(jComponent, n2, n3);
                if (bl2 && !this.autoscroll) {
                    this.autoscroll = true;
                    this.autoTimer.start();
                    return;
                }
                if (!bl2) {
                    this.autoscroll = false;
                    this.autoTimer.stop();
                }
            }
            return;
        }
        if (!this._isScrolling) {
            return;
        }
        mouseEvent = this.editor.retranslateMouseEvent(mouseEvent);
        int n4 = mouseEvent.getX();
        int n5 = mouseEvent.getY();
        int n6 = mouseEvent.isShiftDown() ? 4 : 1;
        this.deltaX = n6 * (this.lastX - n4);
        this.deltaY = n6 * (this.lastY - n5);
        this.deltaX = Math.max(-this.viewPosition.x, this.deltaX);
        this.deltaX = Math.min(this.componentSize.width - (this.viewPosition.x + this._viewportExtent.width), this.deltaX);
        this.deltaY = Math.max(-this.viewPosition.y, this.deltaY);
        this.deltaY = Math.min(this.componentSize.height - (this.viewPosition.y + this._viewportExtent.height), this.deltaY);
        this.viewPosition.x += this.deltaX;
        this.viewPosition.y += this.deltaY;
        this._viewport.setViewPosition(this.viewPosition);
        if (this.deltaX != 0) {
            this.lastX = n4 + this.deltaX;
        }
        if (this.deltaY != 0) {
            this.lastY = n5 + this.deltaY;
        }
        mouseEvent.consume();
        this.editor.translateMouseEvent(mouseEvent);
    }

    private final boolean doScroll(JComponent jComponent, int n2, int n3) {
        if (jComponent != null && jComponent.getParent() instanceof JViewport) {
            Dimension dimension = jComponent.getSize();
            jComponent = (JViewport)jComponent.getParent();
            Rectangle rectangle = ((JViewport)jComponent).getViewRect();
            int n4 = rectangle.x + rectangle.width;
            int n5 = rectangle.y + rectangle.height;
            if (n2 > n4 && n4 <= dimension.width - 10) {
                ((JViewport)jComponent).setViewPosition(new Point(rectangle.x + 10, rectangle.y));
                return true;
            }
            if (n2 < rectangle.x && rectangle.x - 10 >= 0) {
                ((JViewport)jComponent).setViewPosition(new Point(rectangle.x - 10, rectangle.y));
                return true;
            }
            if (n3 > n5 && n5 <= dimension.height - 10) {
                ((JViewport)jComponent).setViewPosition(new Point(rectangle.x, rectangle.y + 10));
                return true;
            }
            if (n3 < rectangle.y && rectangle.y - 10 >= 0) {
                ((JViewport)jComponent).setViewPosition(new Point(rectangle.x, rectangle.y - 10));
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.autoscroll) {
            this.autoTimer.stop();
            this.autoscroll = false;
            this.simpleDrag = false;
        }
        if (!this._isScrolling) {
            return;
        }
        this._isScrolling = false;
        this.viewPosition = null;
        this._component.setCursor(this._oldCursor);
        this._component = null;
        this.componentSize = null;
        this._viewport = null;
        this._oldCursor = null;
        mouseEvent.consume();
    }

    @Override
    public void actionPerformed(ActionEvent aWTEvent) {
        aWTEvent = new MouseEvent(this.getEditor().getJComponent(), 506, 0L, 16, this.recentX, this.recentY, 0, false);
        this.getEditor().mouseDragged((MouseEvent)aWTEvent);
    }
}

