/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import org.tigris.gef.base.Editor;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.undo.Memento;
import org.tigris.gef.undo.UndoManager;

class PlaceMemento
extends Memento {
    private FigNode nodePlaced;
    private Object node;
    private Editor editor;

    PlaceMemento(Editor editor, Object object, FigNode figNode) {
        this.nodePlaced = figNode;
        this.node = object;
        this.editor = editor;
    }

    @Override
    public void undo() {
        UndoManager.getInstance().addMementoLock(this);
        this.editor.getSelectionManager().deselect(this.nodePlaced);
        ((MutableGraphModel)this.editor.getGraphModel()).removeNode(this.node);
        this.editor.remove(this.nodePlaced);
        UndoManager.getInstance().removeMementoLock(this);
    }

    @Override
    public void redo() {
        UndoManager.getInstance().addMementoLock(this);
        this.editor.add(this.nodePlaced);
        ((MutableGraphModel)this.editor.getGraphModel()).addNode(this.node);
        this.editor.getSelectionManager().select(this.nodePlaced);
        UndoManager.getInstance().removeMementoLock(this);
    }

    @Override
    public void dispose() {
    }

    @Override
    public String toString() {
        return (this.isStartChain() ? "*" : " ") + "PlaceMemento " + this.nodePlaced.getBounds();
    }
}

