/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.ocl.ExpansionException;
import org.tigris.gef.ocl.OCLExpander;
import org.tigris.gef.ocl.TemplateReader;
import org.tigris.gef.util.Localizer;

public class SavePGMLAction
extends AbstractAction
implements FilenameFilter {
    private static final long serialVersionUID = 8033817528836858940L;
    private static OCLExpander _expander = null;

    public SavePGMLAction() {
    }

    public SavePGMLAction(String string) {
        this(string, false);
    }

    public SavePGMLAction(String string, Icon icon) {
        this(string, icon, false);
    }

    public SavePGMLAction(String string, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string);
    }

    public SavePGMLAction(String string, Icon icon, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        try {
            _expander = new OCLExpander(TemplateReader.getInstance().read("/org/tigris/gef/xml/dtd/PGML.tee"));
            object = Globals.curEditor();
            Diagram diagram = new Diagram("junk", ((Editor)object).getGraphModel(), (LayerPerspective)((Editor)object).getLayerManager().getActiveLayer());
            object = new FileDialog(((Editor)object).findFrame(), "Save Diagram in PGML format", 1);
            ((FileDialog)object).setFilenameFilter(this);
            ((FileDialog)object).setDirectory(Globals.getLastDirectory());
            ((Dialog)object).setVisible(true);
            String string = ((FileDialog)object).getFile();
            object = ((FileDialog)object).getDirectory();
            Globals.setLastDirectory((String)object);
            if (string != null) {
                Globals.showStatus("Writing " + (String)object + string + "...");
                FileWriter fileWriter = new FileWriter((String)object + string);
                System.out.println("Action save in PGML...");
                _expander.expand(fileWriter, (Object)diagram);
                System.out.println("save done");
                Globals.showStatus("Wrote " + (String)object + string);
                fileWriter.close();
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("got an FileNotFoundException");
            return;
        }
        catch (IOException iOException) {
            System.out.println("got an IOException");
            iOException.printStackTrace();
            return;
        }
        catch (ExpansionException expansionException) {
            System.out.println("got an Exception");
            expansionException.printStackTrace();
            return;
        }
    }

    @Override
    public boolean accept(File file, String string) {
        return true;
    }
}

