/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import org.tigris.gef.di.GraphElement;
import org.tigris.gef.graph.ConnectionConstrainer;
import org.tigris.gef.graph.GraphEvent;
import org.tigris.gef.graph.GraphListener;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;

public abstract class MutableGraphSupport
implements Serializable,
MutableGraphModel {
    private Vector _graphListeners;
    private ConnectionConstrainer connectionConstrainer;
    private static Action saveAction;

    public MutableGraphSupport() {
    }

    public MutableGraphSupport(ConnectionConstrainer connectionConstrainer) {
        this.connectionConstrainer = connectionConstrainer;
    }

    public List getGraphListeners() {
        return this._graphListeners;
    }

    @Override
    public Object createNode(String string, Hashtable hashtable) {
        try {
            string = Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        if (string instanceof GraphNodeHooks) {
            ((GraphNodeHooks)((Object)string)).initialize(hashtable);
        }
        return string;
    }

    protected ConnectionConstrainer getConnectionConstrainer() {
        return this.connectionConstrainer;
    }

    @Override
    public void setConnectionConstrainer(ConnectionConstrainer connectionConstrainer) {
        this.connectionConstrainer = connectionConstrainer;
    }

    @Override
    public boolean canDragNode(Object object) {
        return false;
    }

    @Override
    public void dragNode(Object object) {
    }

    @Override
    public boolean canChangeConnectedNode(Object object, Object object2, Object object3) {
        return false;
    }

    @Override
    public boolean canConnect(Object object, Object object2, Object object3) {
        boolean bl2 = this.connectionConstrainer != null ? this.connectionConstrainer.isConnectionValid(object3, object, object2) : this.canConnect(object, object2);
        return bl2;
    }

    public boolean canConnect(Object object, Object object2, Class clazz) {
        boolean bl2 = this.connectionConstrainer != null ? this.connectionConstrainer.isConnectionValid(clazz, object, object2) : this.canConnect(object, object2);
        return bl2;
    }

    @Override
    public void changeConnectedNode(Object object, Object object2, Object object3, boolean bl2) {
    }

    @Override
    public Object connect(Object object, Object object2, Object object3) {
        return this.connect(object, object2);
    }

    @Override
    public Object connect(Object object, Object object2, Object object3, Map map) {
        return this.connect(object, object2);
    }

    @Override
    public boolean containsNode(Object object) {
        return this.getNodes().contains(object);
    }

    @Override
    public boolean containsEdge(Object object) {
        return this.getEdges().contains(object);
    }

    public boolean containsNodePort(Object object) {
        List list = this.getNodes();
        if (list == null) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List list2 = this.getPorts(list.get(i2));
            if (list2 == null || !list2.contains(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEdgePort(Object object) {
        List list = this.getNodes();
        if (list == null) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List list2 = this.getPorts(list.get(i2));
            if (list2 == null || !list2.contains(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPort(Object object) {
        return this.containsNodePort(object) || this.containsEdgePort(object);
    }

    @Override
    public void addGraphEventListener(GraphListener graphListener) {
        if (this._graphListeners == null) {
            this._graphListeners = new Vector();
        }
        this._graphListeners.addElement(graphListener);
    }

    @Override
    public void removeGraphEventListener(GraphListener graphListener) {
        if (this._graphListeners == null) {
            return;
        }
        this._graphListeners.removeElement(graphListener);
    }

    public void fireNodeAdded(Object object) {
        if (saveAction != null && !saveAction.isEnabled()) {
            saveAction.setEnabled(true);
        }
        if (this._graphListeners == null) {
            return;
        }
        object = new GraphEvent(this, object);
        Enumeration enumeration = this._graphListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GraphListener)enumeration.nextElement()).nodeAdded((GraphEvent)object);
        }
    }

    public void fireNodeRemoved(Object object) {
        if (saveAction != null && !saveAction.isEnabled()) {
            saveAction.setEnabled(true);
        }
        if (this._graphListeners == null) {
            return;
        }
        object = new GraphEvent(this, object);
        Enumeration enumeration = this._graphListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GraphListener)enumeration.nextElement()).nodeRemoved((GraphEvent)object);
        }
    }

    public void fireEdgeAdded(Object object) {
        if (saveAction != null && !saveAction.isEnabled()) {
            saveAction.setEnabled(true);
        }
        if (this._graphListeners == null) {
            return;
        }
        object = new GraphEvent(this, object);
        Enumeration enumeration = this._graphListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GraphListener)enumeration.nextElement()).edgeAdded((GraphEvent)object);
        }
    }

    public void fireEdgeRemoved(Object object) {
        if (saveAction != null && !saveAction.isEnabled()) {
            saveAction.setEnabled(true);
        }
        if (this._graphListeners == null) {
            return;
        }
        object = new GraphEvent(this, object);
        Enumeration enumeration = this._graphListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GraphListener)enumeration.nextElement()).edgeRemoved((GraphEvent)object);
        }
    }

    public void fireGraphChanged() {
        if (saveAction != null && !saveAction.isEnabled()) {
            saveAction.setEnabled(true);
        }
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent graphEvent = new GraphEvent(this, null);
        Enumeration enumeration = this._graphListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GraphListener)enumeration.nextElement()).graphChanged(graphEvent);
        }
    }

    public static void setSaveAction(Action action) {
        saveAction = action;
    }

    public static void enableSaveAction() {
        if (saveAction != null) {
            saveAction.setEnabled(true);
        }
    }

    @Override
    public void removeNode(Object object) {
        this.fireNodeRemoved(object);
    }

    @Override
    public void addNode(Object object) {
        this.fireNodeAdded(object);
    }

    @Override
    public void addEdge(Object object) {
        this.fireEdgeAdded(object);
    }

    @Override
    public void removeEdge(Object object) {
        this.fireEdgeRemoved(object);
    }

    public void removeFig(Fig fig) {
        if (fig instanceof GraphElement) {
            throw new IllegalArgumentException("Use removeEdge or removeNode to remove a complex Fig");
        }
        fig.removeFromDiagram();
        this.fireGraphChanged();
    }

    public void removeAllNodes() {
        this.fireGraphChanged();
    }

    public void removeAllEdges() {
        this.fireGraphChanged();
    }

    public void removeAll() {
        this.fireGraphChanged();
    }

    @Override
    public boolean isEnclosable(Object object, Object object2) {
        return true;
    }
}

