/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import ro.deversoft.odf.gearbox.common.domain.MeasurementUnitEnumDDD;
import ro.deversoft.odf.gearbox.common.domain.MeasurementUnitSystemEnum;

public class MeasurementUnitDDD
implements Serializable {
    private String symbol;
    private String description;
    private MeasurementUnitSystemEnum unitSystem;
    private MeasurementUnitEnumDDD standardizedSymbol;

    public static Map<String, MeasurementUnitDDD> getAllAvailableUnits() {
        Map<String, MeasurementUnitDDD> result = Collections.synchronizedMap(new LinkedHashMap());
        Arrays.stream(MeasurementUnitEnumDDD.values()).forEach(k -> {
            if (k == MeasurementUnitEnumDDD.UNRECOGNIZED) {
                return;
            }
            MeasurementUnitDDD build = MeasurementUnitDDD.build(k);
            if (build == null) {
                return;
            }
            result.put(build.getSymbol(), build);
        });
        return result;
    }

    private static MeasurementUnitDDD build(MeasurementUnitEnumDDD unitEnumDDD) {
        MeasurementUnitDDD kg = new MeasurementUnitDDD(unitEnumDDD.name(), unitEnumDDD.name(), unitEnumDDD.measurementUnitSystemEnum, unitEnumDDD);
        return kg;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getDescription() {
        return this.description;
    }

    public MeasurementUnitSystemEnum getUnitSystem() {
        return this.unitSystem;
    }

    public MeasurementUnitEnumDDD getStandardizedSymbol() {
        return this.standardizedSymbol;
    }

    public MeasurementUnitDDD(String symbol, String description, MeasurementUnitSystemEnum unitSystem, MeasurementUnitEnumDDD standardizedSymbol) {
        this.symbol = symbol;
        this.description = description;
        this.unitSystem = unitSystem;
        this.standardizedSymbol = standardizedSymbol;
    }

    public MeasurementUnitDDD() {
    }

    public MeasurementUnitDDD setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public MeasurementUnitDDD setDescription(String description) {
        this.description = description;
        return this;
    }

    public MeasurementUnitDDD setUnitSystem(MeasurementUnitSystemEnum unitSystem) {
        this.unitSystem = unitSystem;
        return this;
    }

    public MeasurementUnitDDD setStandardizedSymbol(MeasurementUnitEnumDDD standardizedSymbol) {
        this.standardizedSymbol = standardizedSymbol;
        return this;
    }
}

