/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.deversoft.odf.gearbox.common.domain.LanguageDDD;
import ro.deversoft.odf.gearbox.common.domain.StringWithLanguageIndication;

public class StringI18List {
    private transient Map<String, String> i18Nodes = null;
    List<StringWithLanguageIndication> itemsList;

    public StringI18List() {
        this(new ArrayList<StringWithLanguageIndication>());
    }

    public StringI18List(List<StringWithLanguageIndication> items) {
        this.itemsList = items;
        this.rebuildNodesIfNeeded();
    }

    private void rebuildNodesIfNeeded() {
        if (this.i18Nodes == null || this.i18Nodes.size() != this.itemsList.size()) {
            this.rebuildNodes();
        }
    }

    private void rebuildNodes() {
        if (this.i18Nodes == null) {
            this.i18Nodes = new HashMap<String, String>();
        }
        for (StringWithLanguageIndication item : this.itemsList) {
            this.i18Nodes.put(item.getLang().code, item.getPayload());
        }
    }

    public boolean add(StringWithLanguageIndication jsonNodeWithLanguageIndication) {
        this.rebuildNodesIfNeeded();
        boolean result = this.itemsList.add(jsonNodeWithLanguageIndication);
        if (result) {
            this.i18Nodes.put(jsonNodeWithLanguageIndication.lang.code, jsonNodeWithLanguageIndication.payload);
        }
        return result;
    }

    public StringWithLanguageIndication getValueForLang(LanguageDDD languageDDD, LanguageDDD defaultLanguage) {
        for (StringWithLanguageIndication item : this.itemsList) {
            LanguageDDD lang = item.getLang();
            String code = lang.getCode();
            if (!code.equalsIgnoreCase(languageDDD.getCode())) continue;
            return item;
        }
        for (StringWithLanguageIndication item : this.itemsList) {
            if (!item.getLang().getCode().equalsIgnoreCase(defaultLanguage.getCode())) continue;
            return item;
        }
        return null;
    }

    public String getForLang(String lang, String defaultLang) {
        this.rebuildNodesIfNeeded();
        String resultInRequestedLang = this.i18Nodes.get(lang);
        if (resultInRequestedLang == null) {
            resultInRequestedLang = this.i18Nodes.get(defaultLang);
        }
        return resultInRequestedLang;
    }

    public void setForLang(LanguageDDD lang, String value) {
        this.rebuildNodesIfNeeded();
        StringWithLanguageIndication toadd = new StringWithLanguageIndication(value, lang);
        this.add(toadd);
    }

    public Map<String, String> getI18Nodes() {
        return this.i18Nodes;
    }

    public List<StringWithLanguageIndication> getItemsList() {
        return this.itemsList;
    }

    public StringI18List setI18Nodes(Map<String, String> i18Nodes) {
        this.i18Nodes = i18Nodes;
        return this;
    }

    public StringI18List setItemsList(List<StringWithLanguageIndication> itemsList) {
        this.itemsList = itemsList;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringI18List)) {
            return false;
        }
        StringI18List other = (StringI18List)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringI18List;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "StringI18List(i18Nodes=" + this.getI18Nodes() + ", itemsList=" + this.getItemsList() + ")";
    }
}

