/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.jsonified;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import lombok.NonNull;
import ro.deversoft.odf.gearbox.common.JSONCommon;
import ro.deversoft.odf.gearbox.common.exception.ODFRuntimeException;
import ro.deversoft.odf.gearbox.common.jsonified.JsonDiscriminatorEnum;
import ro.deversoft.odf.gearbox.common.jsonified.Jsonifiable;
import ro.deversoft.odf.gearbox.common.jsonified.JsonifiedBasedOnDiscriminator;

public abstract class CommonJsonifiableMapper<DiscriminatorEnum extends Enum<DiscriminatorEnum>, JsonifiedRepres extends JsonifiedBasedOnDiscriminator<DiscriminatorEnum, JsonifiedRepres>, GeneralizedJsonifiable extends Jsonifiable> {
    protected final Map<?, DiscriminatorEnum> classToDiscriminatorMapping = this.extractMappingFromJsonifiedClassToEnum();
    private Constructor<JsonifiedRepres> defaultDeclaredConstructor = this.extractDefaultConstructorForJsonifiableRepresentation();

    protected DiscriminatorEnum getDiscriminatorBasedOnEnumConstant(@NonNull GeneralizedJsonifiable generalizedJsonifiable) {
        if (generalizedJsonifiable == null) {
            throw new NullPointerException("generalizedJsonifiable is marked non-null but is null");
        }
        Class<?> classOfJsonifiableObj = generalizedJsonifiable.getClass();
        return (DiscriminatorEnum)((Enum)this.classToDiscriminatorMapping.get(classOfJsonifiableObj));
    }

    protected CommonJsonifiableMapper() {
    }

    private Constructor<JsonifiedRepres> extractDefaultConstructorForJsonifiableRepresentation() {
        Type genericType = ((ParameterizedType)this.getClass().getSuperclass().getGenericSuperclass()).getActualTypeArguments()[1];
        Class jsonifiedReprezClass = (Class)genericType;
        try {
            return jsonifiedReprezClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e1) {
            throw new ODFRuntimeException(e1);
        }
    }

    protected JsonifiedRepres jsonifiedRepresentationFactory() {
        try {
            return (JsonifiedRepres)((JsonifiedBasedOnDiscriminator)this.defaultDeclaredConstructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new ODFRuntimeException(e);
        }
    }

    protected Map<?, DiscriminatorEnum> extractMappingFromJsonifiedClassToEnum() {
        Type genericType = ((ParameterizedType)this.getClass().getSuperclass().getGenericSuperclass()).getActualTypeArguments()[0];
        Class enumClass = (Class)genericType;
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        HashMap map = new HashMap();
        Stream.of(enumConstants).forEach(k -> {
            Class<? extends Jsonifiable> key = ((JsonDiscriminatorEnum)((Object)k)).getClassForJsonifiedObject();
            if (map.containsKey(key)) {
                throw new ODFRuntimeException("defined data should not repeat the same map key");
            }
            map.put(key, k);
        });
        return map;
    }

    protected ObjectMapper acquireJsonObjectMapper() {
        return JSONCommon.acquireJsonObjectMapper();
    }

    public JsonifiedRepres jsonifiableToJsonRepresentation(@NonNull GeneralizedJsonifiable generalizedJsonifiable) {
        if (generalizedJsonifiable == null) {
            throw new NullPointerException("generalizedJsonifiable is marked non-null but is null");
        }
        JsonifiedRepres jsonifiedRepres = this.jsonifiedRepresentationFactory();
        jsonifiedRepres.setDiscriminator(this.getDiscriminatorBasedOnEnumConstant(generalizedJsonifiable));
        jsonifiedRepres.setJsonObjectRepresentation(this.acquireJsonObjectMapper().valueToTree(generalizedJsonifiable));
        return jsonifiedRepres;
    }

    public GeneralizedJsonifiable jsonRepresentationToJsonifiable(@NonNull JsonifiedRepres jsonifiedRepr) {
        if (jsonifiedRepr == null) {
            throw new NullPointerException("jsonifiedRepr is marked non-null but is null");
        }
        Object discriminator = jsonifiedRepr.getDiscriminator();
        Class<? extends Jsonifiable> classForJsonifiedObject = ((JsonDiscriminatorEnum)discriminator).getClassForJsonifiedObject();
        Jsonifiable jsonifiable = null;
        JsonNode jsonObjectRepresentation = jsonifiedRepr.getJsonObjectRepresentation();
        try {
            jsonifiable = (Jsonifiable)this.acquireJsonObjectMapper().treeToValue((TreeNode)jsonObjectRepresentation, classForJsonifiedObject);
        }
        catch (JsonProcessingException e) {
            throw new ODFRuntimeException(e);
        }
        return (GeneralizedJsonifiable)jsonifiable;
    }
}

