/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.util.Localizer;

public class PrintAction
extends AbstractAction
implements Printable {
    private static final long serialVersionUID = 3600929184215942819L;
    private PrinterJob printerJob;
    private PageFormat pageFormat;
    private int maxPageIndex = 1;
    private boolean fitDiagramToPage = true;
    private boolean isFirstPrintCall = true;
    private double scale;
    private int nCol;
    private double pageX;
    private double pageY;
    private double pageWidth;
    private double pageHeight;
    private double diagramX;
    private double diagramY;
    private double diagramWidth;
    private double diagramHeight;

    public PrintAction() {
    }

    public PrintAction(String name, String diagramName) {
        this(name, diagramName, false);
    }

    public PrintAction(String name, String diagramName, Icon icon) {
        this(name, icon, diagramName, false);
    }

    public PrintAction(String name, String diagramName, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public PrintAction(String name, Icon icon, String diagramName, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    public void setDiagramName(String diagramName) {
    }

    public void actionPerformed(ActionEvent arg0) {
        PrinterJob printerJob = this.getPrinterJob();
        printerJob.setPrintable(new PrintAction(), this.getPageFormat());
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException pe) {
                Globals.showStatus("Error got a Printer exception");
            }
        }
        Globals.showStatus("Printing finished");
    }

    private boolean isFirstPrintCall() {
        return this.isFirstPrintCall;
    }

    private void setFirstPrintCall(boolean b) {
        this.isFirstPrintCall = b;
    }

    private boolean fitDiagramToPage() {
        return this.fitDiagramToPage;
    }

    private void setFitDiagramToPage(boolean b) {
        this.fitDiagramToPage = b;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= this.maxPageIndex) {
            return 1;
        }
        Editor editor = Globals.curEditor();
        Graphics2D g2d = (Graphics2D)graphics;
        Rectangle drawingArea = null;
        SelectionManager sm = editor.getSelectionManager();
        Vector selectedFigs = sm.getFigs();
        Enumeration iter = null;
        if (selectedFigs.size() > 0) {
            iter = selectedFigs.elements();
        } else {
            iter = editor.figs();
            drawingArea = new Rectangle();
        }
        while (iter.hasMoreElements()) {
            Fig fig = (Fig)iter.nextElement();
            Rectangle rect = fig.getBounds();
            if (drawingArea == null) {
                drawingArea = new Rectangle(rect);
            }
            drawingArea.add(rect);
        }
        if (drawingArea == null || drawingArea.width == 0 || drawingArea.height == 0) {
            return 1;
        }
        boolean h = editor.getGridHidden();
        editor.setGridHidden(true);
        if (this.isFirstPrintCall()) {
            this.setFirstPrintCall(false);
            this.pageWidth = pageFormat.getImageableWidth();
            this.pageHeight = pageFormat.getImageableHeight();
            this.pageX = pageFormat.getImageableX();
            this.pageY = pageFormat.getImageableY();
            this.diagramWidth = drawingArea.width;
            this.diagramHeight = drawingArea.height;
            this.diagramX = drawingArea.x;
            this.diagramY = drawingArea.y;
            this.scale = Math.min(this.pageWidth / (double)(drawingArea.width + 1), this.pageHeight / (double)(drawingArea.height + 1));
            if (this.scale < 1.0 && !this.promptFitToPage()) {
                editor.setGridHidden(h);
                return 1;
            }
            if (this.fitDiagramToPage()) {
                this.maxPageIndex = 1;
            } else {
                this.nCol = Math.max((int)Math.ceil(this.diagramWidth / this.pageWidth), 1);
                int nRow = Math.max((int)Math.ceil(this.diagramHeight / this.pageHeight), 1);
                this.maxPageIndex = this.nCol * nRow;
            }
        }
        if (this.fitDiagramToPage()) {
            if (this.scale < 1.0) {
                g2d.scale(this.scale, this.scale);
                g2d.translate(this.pageX / this.scale - this.diagramX + 1.0, this.pageY / this.scale - this.diagramY + 1.0);
            } else {
                g2d.translate(this.pageX - this.diagramX + 1.0, this.pageY - this.diagramY + 1.0);
            }
        } else {
            double iCol = pageIndex % this.nCol;
            double iRow = pageIndex / this.nCol;
            double x = iCol * this.pageWidth;
            double y = iRow * this.pageHeight;
            g2d.translate(this.pageX - x + 1.0, this.pageY - y + 1.0);
        }
        g2d.setClip(drawingArea);
        editor.print(g2d);
        editor.setGridHidden(h);
        return 0;
    }

    PrinterJob getPrinterJob() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        return this.printerJob;
    }

    PageFormat getPageFormat() {
        PrinterJob pj;
        if (this.pageFormat == null && (pj = this.getPrinterJob()) != null) {
            this.pageFormat = pj.defaultPage();
        }
        return this.pageFormat;
    }

    void setPageFormat(PageFormat pf) {
        this.pageFormat = pf;
    }

    public void doPageSetup() {
        this.setPageFormat(this.getPrinterJob().pageDialog(this.getPageFormat()));
    }

    private boolean promptFitToPage() {
        Object[] options = new Object[]{"Fit to page", "Multiple Pages", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, "The diagram exceeds the current page size. Select option?", "Print", 1, 3, null, options, options[0]);
        if (n == 2) {
            return false;
        }
        if (n == 1) {
            this.setFitDiagramToPage(false);
        } else {
            this.setFitDiagramToPage(true);
        }
        return true;
    }
}

