/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.ui.FhSysButton;
import com.shfarr.ui.plaf.fh.borders.FHMultiMatrixBorder;
import com.shfarr.ui.plaf.fh.ext.FhDefaults;
import com.shfarr.ui.plaf.fh.ext.ResourceApplicationForm;
import com.shfarr.ui.plaf.fh.ext.ResourceCandidate;
import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class FhScrollBarUI
extends BasicScrollBarUI
implements ResourceCandidate {
    protected int scrollBarWidth = 14;
    protected double mx = Double.POSITIVE_INFINITY;
    protected double my = Double.POSITIVE_INFINITY;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void installDefaults() {
        super.installDefaults();
        this.scrollbar.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent me) {
                if (FhScrollBarUI.this.scrollbar != null) {
                    FhScrollBarUI.this.scrollbar.repaint();
                }
            }

            public void mouseExited(MouseEvent me) {
                FhScrollBarUI.this.mx = Double.POSITIVE_INFINITY;
                FhScrollBarUI.this.my = Double.POSITIVE_INFINITY;
                if (FhScrollBarUI.this.scrollbar != null) {
                    FhScrollBarUI.this.scrollbar.repaint();
                }
            }
        });
        this.scrollbar.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent me) {
                FhScrollBarUI.this.mx = me.getX();
                FhScrollBarUI.this.my = me.getY();
                if (FhScrollBarUI.this.scrollbar != null) {
                    FhScrollBarUI.this.scrollbar.repaint();
                }
            }
        });
    }

    public ResourceApplicationForm getApplicationForm() {
        Object[] objectArray = new Object[4];
        objectArray[0] = "highlight";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[1] = clazz;
        objectArray[2] = "thumbTexture";
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.shfarr.ui.plaf.fh.textures.Texture");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[3] = clazz2;
        return new ResourceApplicationForm(objectArray);
    }

    protected JButton createDecreaseButton(int orientation) {
        FhSysButton sb = new FhSysButton(this.scrollbar.getOrientation() == 0 ? 4 : 1, 1);
        sb.setForeground((Color)UIManager.getDefaults().get("ScrollBar.highlight"));
        return sb;
    }

    protected JButton createIncreaseButton(int orientation) {
        FhSysButton sb = new FhSysButton(this.scrollbar.getOrientation() == 0 ? 2 : 3, 1);
        sb.setForeground((Color)UIManager.getDefaults().get("ScrollBar.highlight"));
        return sb;
    }

    public static ComponentUI createUI(JComponent c) {
        return new FhScrollBarUI();
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.scrollbar.getOrientation() == 1 ? new Dimension(this.scrollBarWidth, 48) : new Dimension(48, this.scrollBarWidth);
    }

    protected void layoutHScrollbar(JScrollBar sb) {
        int sbAvailButtonW;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = this.scrollBarWidth;
        int itemY = sbInsets.top;
        int decrButtonW = this.scrollBarWidth;
        int decrButtonX = sbInsets.left;
        int incrButtonW = this.scrollBarWidth;
        int incrButtonX = sbSize.width - (sbInsets.right + incrButtonW);
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = decrButtonW + incrButtonW;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int thumbX = incrButtonX - thumbW;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbX += decrButtonX + decrButtonW;
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            incrButtonW = decrButtonW = sbAvailButtonW / 2;
            incrButtonX = sbSize.width - (sbInsets.right + incrButtonW);
        }
        this.decrButton.setBounds(decrButtonX, itemY, decrButtonW, itemH);
        this.incrButton.setBounds(incrButtonX, itemY, incrButtonW, itemH);
        int itrackX = decrButtonX + decrButtonW;
        int itrackW = incrButtonX - itrackX;
        this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbX + thumbW > incrButtonX) {
                thumbX = incrButtonX - thumbW;
            }
            if (thumbX < decrButtonX + decrButtonW) {
                thumbX = decrButtonX + decrButtonW + 1;
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    protected void layoutVScrollbar(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = this.scrollBarWidth;
        int itemX = sbInsets.left;
        int decrButtonH = this.scrollBarWidth;
        int decrButtonY = sbInsets.top;
        int incrButtonH = this.scrollBarWidth;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButtonH + incrButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = incrButtonY - thumbH;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += decrButtonY + decrButtonH;
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            incrButtonH = decrButtonH = sbAvailButtonH / 2;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        int itrackY = decrButtonY + decrButtonH;
        int itrackH = incrButtonY - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > incrButtonY) {
                thumbY = incrButtonY - thumbH;
            }
            if (thumbY < decrButtonY + decrButtonH) {
                thumbY = decrButtonY + decrButtonH + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void paintDecreaseHighlight(Graphics g) {
        Insets insets = this.scrollbar.getInsets();
        Rectangle thumbR = this.getThumbBounds();
        g.setColor(UIManager.getColor("Component.lightShadow"));
        if (this.scrollbar.getOrientation() == 1) {
            int x = insets.left;
            int y = this.decrButton.getY() + this.decrButton.getHeight();
            int w = this.scrollbar.getWidth() - (insets.left + insets.right);
            int h = thumbR.y - y;
            g.fillRect(x, y, w, h);
        } else {
            int x = this.decrButton.getX() + this.decrButton.getHeight();
            int y = insets.top;
            int w = thumbR.x - x;
            int h = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            g.fillRect(x, y, w, h);
        }
    }

    protected void paintIncreaseHighlight(Graphics g) {
        Insets insets = this.scrollbar.getInsets();
        Rectangle thumbR = this.getThumbBounds();
        g.setColor(UIManager.getColor("Component.lightShadow"));
        if (this.scrollbar.getOrientation() == 1) {
            int x = insets.left;
            int y = thumbR.y + thumbR.height;
            int w = this.scrollbar.getWidth() - (insets.left + insets.right);
            int h = this.incrButton.getY() - y;
            g.fillRect(x, y, w, h);
        } else {
            int x = thumbR.x + thumbR.width;
            int y = insets.top;
            int w = this.incrButton.getX() - x;
            int h = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            g.fillRect(x, y, w, h);
        }
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        g.translate(thumbBounds.x, thumbBounds.y);
        g.setColor(UIManager.getColor("Component.background"));
        g.fillRect(0, 0, w, h);
        Border thumbBorder = UIManager.getDefaults().getBorder("ScrollBar.thumbBorder");
        if (thumbBorder instanceof FHMultiMatrixBorder) {
            if (thumbBounds.contains(this.mx, this.my) || this.isDragging) {
                ((FHMultiMatrixBorder)thumbBorder).selectMatrix("thumb.selected");
            } else {
                ((FHMultiMatrixBorder)thumbBorder).selectMatrix("thumb");
            }
        }
        thumbBorder.paintBorder(c, g, 0, 0, w, h);
        Texture thumbTexture = (Texture)UIManager.getDefaults().get("ScrollBar.thumbTexture");
        if (thumbTexture != null && ThemeManager.instance().probeSmallTextures()) {
            if (this.scrollbar.getOrientation() == 1) {
                thumbTexture.rotate(-1);
            }
            thumbTexture.apply(new Rectangle(2, 2, w - 4, h - 4), (Graphics2D)g, c);
        }
        g.setColor(UIManager.getColor("Component.background"));
        if (this.scrollbar.getOrientation() == 0) {
            g.fillRect(Math.max(3, w / 2 - 9), 3, Math.min(20, w - 6), h - 6);
            int i = Math.max(3, w / 2 - 7);
            while (i < Math.min(w / 2 + 7, w - 4)) {
                FhDefaults.paintTouch(c, g, i, 3, 3, h - 6);
                i += 3;
            }
        } else {
            g.fillRect(3, Math.max(3, h / 2 - 9), w - 6, Math.min(20, h - 6));
            int i = Math.max(3, h / 2 - 7);
            while (i < Math.min(h / 2 + 7, h - 4)) {
                FhDefaults.paintTouch(c, g, 3, i, w - 6, 3);
                i += 3;
            }
        }
        if (thumbTexture != null && ThemeManager.instance().probeSmallTextures() && this.scrollbar.getOrientation() == 1) {
            thumbTexture.rotate(1);
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor((Color)UIManager.getDefaults().get("Component.lightHighlight"));
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        if (this.trackHighlight == 1) {
            this.paintDecreaseHighlight(g);
        } else if (this.trackHighlight == 2) {
            this.paintIncreaseHighlight(g);
        }
    }
}

