/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.table;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.logger.LoggerFactory$1;
import com.j256.ormlite.stmt.StatementBuilder$StatementType;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TableUtils {
    private static Logger logger = LoggerFactory.getLogger(TableUtils.class);
    private static final FieldType[] noFieldTypes = new FieldType[0];

    private TableUtils() {
    }

    public static <T> int createTable(L l2, Class<T> clazz) {
        return TableUtils.createTable(l2, clazz, false);
    }

    public static <T> int createTableIfNotExists(L l2, Class<T> clazz) {
        return TableUtils.createTable(l2, clazz, true);
    }

    public static <T> int createTable(L l2, DatabaseTableConfig<T> databaseTableConfig) {
        return TableUtils.createTable(l2, databaseTableConfig, false);
    }

    public static <T> int createTableIfNotExists(L l2, DatabaseTableConfig<T> databaseTableConfig) {
        return TableUtils.createTable(l2, databaseTableConfig, true);
    }

    public static <T, ID> List<String> getCreateTableStatements(L l2, Class<T> object) {
        Object d2 = DaoManager.createDao(l2, object);
        if (d2 instanceof BaseDaoImpl) {
            return TableUtils.addCreateTableStatements(l2, ((BaseDaoImpl)d2).getTableInfo(), false);
        }
        object = new TableInfo(l2, null, object);
        return TableUtils.addCreateTableStatements(l2, object, false);
    }

    public static <T, ID> List<String> getCreateTableStatements(L l2, DatabaseTableConfig<T> object) {
        Object d2 = DaoManager.createDao(l2, object);
        if (d2 instanceof BaseDaoImpl) {
            return TableUtils.addCreateTableStatements(l2, ((BaseDaoImpl)d2).getTableInfo(), false);
        }
        ((DatabaseTableConfig)object).extractFieldTypes(l2);
        object = new TableInfo(l2.a(), null, object);
        return TableUtils.addCreateTableStatements(l2, object, false);
    }

    public static <T, ID> int dropTable(L l2, Class<T> object, boolean bl2) {
        m m2 = l2.a();
        Object d2 = DaoManager.createDao(l2, object);
        if (d2 instanceof BaseDaoImpl) {
            return TableUtils.doDropTable(m2, l2, ((BaseDaoImpl)d2).getTableInfo(), bl2);
        }
        object = new TableInfo(l2, null, object);
        return TableUtils.doDropTable(m2, l2, object, bl2);
    }

    public static <T, ID> int dropTable(L l2, DatabaseTableConfig<T> object, boolean bl2) {
        m m2 = l2.a();
        Object d2 = DaoManager.createDao(l2, object);
        if (d2 instanceof BaseDaoImpl) {
            return TableUtils.doDropTable(m2, l2, ((BaseDaoImpl)d2).getTableInfo(), bl2);
        }
        ((DatabaseTableConfig)object).extractFieldTypes(l2);
        object = new TableInfo(m2, null, object);
        return TableUtils.doDropTable(m2, l2, object, bl2);
    }

    public static <T> int clearTable(L l2, Class<T> object) {
        object = DatabaseTableConfig.extractTableName(object);
        if (l2.a().isEntityNamesMustBeUpCase()) {
            object = ((String)object).toUpperCase();
        }
        return TableUtils.clearTable(l2, (String)object);
    }

    public static <T> int clearTable(L l2, DatabaseTableConfig<T> databaseTableConfig) {
        return TableUtils.clearTable(l2, databaseTableConfig.getTableName());
    }

    private static <T, ID> int createTable(L l2, Class<T> object, boolean bl2) {
        Object d2 = DaoManager.createDao(l2, object);
        if (d2 instanceof BaseDaoImpl) {
            return TableUtils.doCreateTable(l2, ((BaseDaoImpl)d2).getTableInfo(), bl2);
        }
        object = new TableInfo(l2, null, object);
        return TableUtils.doCreateTable(l2, object, bl2);
    }

    private static <T, ID> int createTable(L l2, DatabaseTableConfig<T> object, boolean bl2) {
        Object d2 = DaoManager.createDao(l2, object);
        if (d2 instanceof BaseDaoImpl) {
            return TableUtils.doCreateTable(l2, ((BaseDaoImpl)d2).getTableInfo(), bl2);
        }
        ((DatabaseTableConfig)object).extractFieldTypes(l2);
        object = new TableInfo(l2.a(), null, object);
        return TableUtils.doCreateTable(l2, object, bl2);
    }

    private static <T> int clearTable(L object, String string) {
        Object object2 = object.a();
        StringBuilder stringBuilder = new StringBuilder(48);
        if (object2.isTruncateSupported()) {
            stringBuilder.append("TRUNCATE TABLE ");
        } else {
            stringBuilder.append("DELETE FROM ");
        }
        object2.appendEscapedEntityName(stringBuilder, string);
        object2 = stringBuilder.toString();
        logger.info("clearing table '{}' with '{}", (Object)string, object2);
        object = object.b();
        int n2 = object.compileStatement$74b6de7e((String)object2, StatementBuilder$StatementType.EXECUTE, noFieldTypes, -1).b();
        return n2;
    }

    private static <T, ID> int doDropTable(m m2, L object, TableInfo<T, ID> tableInfo, boolean bl2) {
        logger.info("dropping table '{}'", (Object)tableInfo.getTableName());
        ArrayList<String> arrayList = new ArrayList<String>();
        TableUtils.addDropIndexStatements(m2, tableInfo, arrayList);
        TableUtils.addDropTableStatements(m2, tableInfo, arrayList);
        object = object.b();
        int n2 = TableUtils.doStatements((DatabaseConnection)object, "drop", arrayList, bl2, m2.isCreateTableReturnsNegative(), false);
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    private static <T, ID> void addDropIndexStatements(m m2, TableInfo<T, ID> tableInfo, List<String> list) {
        void string;
        HashSet<String> hashSet = new HashSet<String>();
        Object stringBuilder = tableInfo.getFieldTypes();
        int n2 = ((FieldType[])stringBuilder).length;
        boolean bl2 = false;
        while (string < n2) {
            String string2;
            FieldType fieldType = stringBuilder[string];
            String string3 = fieldType.getIndexName();
            if (string3 != null) {
                hashSet.add(string3);
            }
            if ((string2 = fieldType.getUniqueIndexName()) != null) {
                hashSet.add(string2);
            }
            ++string;
        }
        stringBuilder = new StringBuilder(48);
        for (String string4 : hashSet) {
            logger.info("dropping index '{}' for table '{}", (Object)string4, (Object)tableInfo.getTableName());
            ((StringBuilder)stringBuilder).append("DROP INDEX ");
            m2.appendEscapedEntityName((StringBuilder)stringBuilder, string4);
            list.add(((StringBuilder)stringBuilder).toString());
            ((StringBuilder)stringBuilder).setLength(0);
        }
    }

    private static <T, ID> void addCreateTableStatements(m m2, TableInfo<T, ID> tableInfo, List<String> list, List<String> list2, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("CREATE TABLE ");
        if (bl2 && m2.isCreateIfNotExistsSupported()) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        m2.appendEscapedEntityName(stringBuilder, tableInfo.getTableName());
        stringBuilder.append(" (");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        boolean bl3 = true;
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            if (fieldType.isForeignCollection()) continue;
            if (bl3) {
                bl3 = false;
            } else {
                stringBuilder.append(", ");
            }
            String string = fieldType.getColumnDefinition();
            if (string == null) {
                m2.appendColumnArg(tableInfo.getTableName(), stringBuilder, fieldType, arrayList, arrayList2, arrayList3, list2);
                continue;
            }
            m2.appendEscapedEntityName(stringBuilder, fieldType.getColumnName());
            stringBuilder.append(' ').append(string).append(' ');
        }
        m2.addPrimaryKeySql(tableInfo.getFieldTypes(), arrayList, arrayList2, arrayList3, list2);
        m2.addUniqueComboSql(tableInfo.getFieldTypes(), arrayList, arrayList2, arrayList3, list2);
        for (String string : arrayList) {
            stringBuilder.append(", ").append(string);
        }
        stringBuilder.append(") ");
        m2.appendCreateTableSuffix(stringBuilder);
        list.addAll(arrayList2);
        list.add(stringBuilder.toString());
        list.addAll(arrayList3);
        TableUtils.addCreateIndexStatements(m2, tableInfo, list, bl2, false);
        TableUtils.addCreateIndexStatements(m2, tableInfo, list, bl2, true);
    }

    private static <T, ID> void addCreateIndexStatements(m m2, TableInfo<T, ID> tableInfo, List<String> list, boolean bl2, boolean bl3) {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            String string = bl3 ? fieldType.getUniqueIndexName() : fieldType.getIndexName();
            if (string == null) continue;
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(fieldType.getColumnName());
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        for (Map.Entry entry : hashMap.entrySet()) {
            logger.info("creating index '{}' for table '{}", entry.getKey(), (Object)tableInfo.getTableName());
            stringBuilder.append("CREATE ");
            if (bl3) {
                stringBuilder.append("UNIQUE ");
            }
            stringBuilder.append("INDEX ");
            if (bl2 && m2.isCreateIndexIfNotExistsSupported()) {
                stringBuilder.append("IF NOT EXISTS ");
            }
            m2.appendEscapedEntityName(stringBuilder, (String)entry.getKey());
            stringBuilder.append(" ON ");
            m2.appendEscapedEntityName(stringBuilder, tableInfo.getTableName());
            stringBuilder.append(" ( ");
            boolean bl4 = true;
            for (ArrayList<String> arrayList : (List)entry.getValue()) {
                if (bl4) {
                    bl4 = false;
                } else {
                    stringBuilder.append(", ");
                }
                m2.appendEscapedEntityName(stringBuilder, (String)((Object)arrayList));
            }
            stringBuilder.append(" )");
            list.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
    }

    private static <T, ID> void addDropTableStatements(m m2, TableInfo<T, ID> tableInfo, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            m2.dropColumnArg(fieldType, arrayList, arrayList2);
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("DROP TABLE ");
        m2.appendEscapedEntityName(stringBuilder, tableInfo.getTableName());
        stringBuilder.append(' ');
        list.addAll(arrayList);
        list.add(stringBuilder.toString());
        list.addAll(arrayList2);
    }

    private static <T, ID> int doCreateTable(L object, TableInfo<T, ID> tableInfo, boolean bl2) {
        m m2 = object.a();
        logger.info("creating table '{}'", (Object)tableInfo.getTableName());
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        TableUtils.addCreateTableStatements(m2, tableInfo, arrayList, arrayList2, bl2);
        object = object.b();
        int n2 = TableUtils.doStatements((DatabaseConnection)object, "create", arrayList, false, m2.isCreateTableReturnsNegative(), m2.isCreateTableReturnsZero()) + TableUtils.doCreateTestQueries((DatabaseConnection)object, m2, arrayList2);
        return n2;
    }

    private static int doStatements(DatabaseConnection databaseConnection, String string, Collection<String> object, boolean bl2, boolean bl3, boolean bl4) {
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            int n3 = 0;
            k k2 = null;
            try {
                k2 = databaseConnection.compileStatement$74b6de7e(string2, StatementBuilder$StatementType.EXECUTE, noFieldTypes, -1);
                n3 = k2.b();
                logger.info("executed {} table statement changed {} rows: {}", (Object)string, (Object)n3, (Object)string2);
                if (k2 != null) {
                    // empty if block
                }
            }
            catch (SQLException sQLException) {
                if (!bl2) {
                    throw LoggerFactory$1.create("SQL statement failed: " + string2, sQLException);
                }
                logger.info("ignoring {} error '{}' for statement: {}", (Object)string, (Object)sQLException, (Object)string2);
                if (k2 != null) {
                    // empty if block
                }
            }
            if (n3 < 0) {
                if (!bl3) {
                    throw new SQLException("SQL statement " + string2 + " updated " + n3 + " rows, we were expecting >= 0");
                }
            } else if (n3 > 0 && bl4) {
                throw new SQLException("SQL statement updated " + n3 + " rows, we were expecting == 0: " + string2);
            }
            ++n2;
        }
        return n2;
    }

    private static int doCreateTestQueries(DatabaseConnection databaseConnection, m m2, List<String> object) {
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            try {
                k k2 = databaseConnection.compileStatement$74b6de7e(string, StatementBuilder$StatementType.SELECT, noFieldTypes, -1);
                k k3 = k2.a();
                int n3 = 0;
                boolean bl2 = k3.a();
                while (bl2) {
                    ++n3;
                    bl2 = k3.c();
                }
                logger.info("executing create table after-query got {} results: {}", n3, (Object)string);
                if (k2 != null) {
                    // empty if block
                }
            }
            catch (SQLException sQLException) {
                throw LoggerFactory$1.create("executing create table after-query failed: " + string, sQLException);
            }
            ++n2;
        }
        return n2;
    }

    private static <T, ID> List<String> addCreateTableStatements(L l2, TableInfo<T, ID> tableInfo, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        TableUtils.addCreateTableStatements(l2.a(), tableInfo, arrayList, arrayList2, bl2);
        return arrayList;
    }
}

