/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.Date;
import org.asteriskjava.live.AsteriskQueueEntry;
import org.asteriskjava.live.QueueEntryState;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskQueueImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;

class AsteriskQueueEntryImpl
extends AbstractLiveObject
implements AsteriskQueueEntry {
    private final AsteriskQueueImpl queue;
    private final AsteriskChannelImpl channel;
    private final Date dateJoined;
    private Date dateLeft;
    private QueueEntryState state;
    private int reportedPosition;
    private int position = -1;

    AsteriskQueueEntryImpl(AsteriskServerImpl asteriskServerImpl, AsteriskQueueImpl asteriskQueueImpl, AsteriskChannelImpl asteriskChannelImpl, int n2, Date date) {
        super(asteriskServerImpl);
        this.queue = asteriskQueueImpl;
        this.channel = asteriskChannelImpl;
        this.dateJoined = date;
        this.state = QueueEntryState.JOINED;
        this.reportedPosition = n2;
    }

    @Override
    public String getChannelName() {
        return this.channel.getName();
    }

    @Override
    public AsteriskQueueImpl getQueue() {
        return this.queue;
    }

    @Override
    public AsteriskChannelImpl getChannel() {
        return this.channel;
    }

    @Override
    public Date getDateJoined() {
        return this.dateJoined;
    }

    @Override
    public Date getDateLeft() {
        return this.dateLeft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void left(Date date) {
        QueueEntryState queueEntryState;
        AsteriskQueueEntryImpl asteriskQueueEntryImpl = this;
        synchronized (asteriskQueueEntryImpl) {
            queueEntryState = this.state;
            this.dateLeft = date;
            this.state = QueueEntryState.LEFT;
        }
        this.firePropertyChange("state", (Object)queueEntryState, (Object)this.state);
    }

    @Override
    public QueueEntryState getState() {
        return this.state;
    }

    public int getReportedPosition() {
        return this.reportedPosition;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    void setPosition(int n2) {
        int n3 = this.position;
        this.position = n2;
        this.firePropertyChange("position", n3, n2);
    }

    void setReportedPosition(int n2) {
        int n3 = this.reportedPosition;
        this.reportedPosition = n2;
        this.firePropertyChange("reportedPosition", n3, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("AsteriskQueueEntry[");
        AbstractLiveObject abstractLiveObject = this;
        synchronized (abstractLiveObject) {
            stringBuffer.append("dateJoined=").append(this.getDateJoined()).append(",");
            stringBuffer.append("postition=").append(this.getPosition()).append(",");
            stringBuffer.append("dateLeft=").append(this.getDateLeft()).append(",");
            n2 = System.identityHashCode(this);
        }
        if (this.channel != null) {
            stringBuffer.append("channel=AsteriskChannel[");
            abstractLiveObject = this.channel;
            synchronized (abstractLiveObject) {
                stringBuffer.append("id='").append(this.channel.getId()).append("',");
                stringBuffer.append("name='").append(this.channel.getName()).append("'],");
            }
        } else {
            stringBuffer.append("channel=null,");
        }
        stringBuffer.append("systemHashcode=").append(n2);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

