/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    private static final String DATE_TIME_PATTERN = "yy-MM-dd HH:mm:ss";
    private static Date currentDate;

    private DateUtil() {
    }

    public static void overrideCurrentDate(Date date) {
        currentDate = date;
    }

    public static Date getDate() {
        if (currentDate == null) {
            return new Date();
        }
        return currentDate;
    }

    public static Date parseDateTime(String string) {
        return DateUtil.parseDateTime(string, null);
    }

    public static Date parseDateTime(String string, TimeZone timeZone) {
        if (string == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TIME_PATTERN);
        if (timeZone != null) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

