/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence.svg;

import java.awt.Color;

public class SvgUtility {
    public static String getColor(Color color) {
        String string = SvgUtility.getColorName(color);
        if (string != null) {
            return string;
        }
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        if (n2 < 15 && n3 < 15 && n4 < 15) {
            return "#" + Integer.toHexString(color.getRed()) + " " + Integer.toHexString(color.getGreen()) + " " + Integer.toHexString(color.getBlue());
        }
        return "#" + SvgUtility.colorToHex(color.getRed()) + " " + SvgUtility.colorToHex(color.getGreen()) + " " + SvgUtility.colorToHex(color.getBlue());
    }

    private static String colorToHex(int n2) {
        if (n2 > 255) {
            throw new IllegalArgumentException("Color value cannot be great than 255");
        }
        if (n2 > 15) {
            return Integer.toHexString(n2);
        }
        return "0" + Integer.toHexString(n2);
    }

    private static String getColorName(Color color) {
        String string = null;
        if (color.equals(Color.white)) {
            string = "white";
        } else if (color.equals(Color.black)) {
            string = "black";
        } else if (color.equals(Color.red)) {
            string = "red";
        } else if (color.equals(Color.green)) {
            string = "green";
        } else if (color.equals(Color.blue)) {
            string = "blue";
        }
        return string;
    }
}

