/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigText;
import org.tigris.gef.presentation.TextEditor;
import org.tigris.gef.undo.UndoManager;

public class FigTextEditor
extends JTextPane
implements FocusListener,
KeyListener,
PropertyChangeListener,
DocumentListener,
TextEditor {
    private static final long serialVersionUID = 7350660058167121420L;
    private FigText figText;
    private JPanel drawingPanel;
    private JLayeredPane layeredPane;
    private static int _extraSpace = 2;
    private static Border _border = BorderFactory.createLineBorder(Color.gray);
    private static boolean _makeBrighter = false;
    private static Color _backgroundColor = null;
    private static Log LOG = LogFactory.getLog(FigTextEditor.class);

    public FigTextEditor(FigText serializable, InputEvent inputEvent) {
        Object object;
        this.setVisible(true);
        this.figText = serializable;
        Serializable serializable2 = Globals.curEditor();
        this.drawingPanel = (JPanel)serializable2.getJComponent();
        UndoManager.getInstance().startChain();
        this.figText.firePropChange("editing", false, true);
        this.figText.addPropertyChangeListener(this);
        for (object = this.drawingPanel; !(object instanceof RootPaneContainer) && object != null; object = ((Component)object).getParent()) {
        }
        if (!(object instanceof RootPaneContainer)) {
            LOG.warn((Object)"no RootPaneContainer");
            return;
        }
        this.layeredPane = ((RootPaneContainer)object).getLayeredPane();
        ((FigText)serializable).calcBounds();
        object = ((Fig)serializable).getBounds();
        Color color = ((Fig)serializable).getFillColor();
        if (_makeBrighter && !color.equals(Color.white)) {
            color = color.brighter();
        } else if (_backgroundColor != null) {
            color = _backgroundColor;
        }
        this.setBackground(color);
        this.setBorder(_border);
        double d2 = serializable2.getScale();
        ((Rectangle)object).x = (int)Math.round((double)((Rectangle)object).x * d2);
        ((Rectangle)object).y = (int)Math.round((double)((Rectangle)object).y * d2);
        if (d2 > 1.0) {
            ((Rectangle)object).width = (int)Math.round((double)((Rectangle)object).width * d2);
            ((Rectangle)object).height = (int)Math.round((double)((Rectangle)object).height * d2);
        }
        object = SwingUtilities.convertRectangle(this.drawingPanel, (Rectangle)object, this.layeredPane);
        this.setBounds(((Rectangle)object).x - _extraSpace, ((Rectangle)object).y - _extraSpace, ((Rectangle)object).width + (_extraSpace << 1), ((Rectangle)object).height + (_extraSpace << 1));
        this.layeredPane.add(this, JLayeredPane.POPUP_LAYER, 0);
        object = ((FigText)serializable).getTextFriend();
        this.setText((String)object);
        this.addKeyListener(this);
        this.requestFocus();
        this.getDocument().addDocumentListener(this);
        serializable2.setActiveTextEditor(this);
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getDocument().getLength());
        serializable2 = new SimpleAttributeSet();
        if (((FigText)serializable).getJustification() == 2) {
            StyleConstants.setAlignment((MutableAttributeSet)((Object)serializable2), 1);
        }
        if (((FigText)serializable).getJustification() == 1) {
            StyleConstants.setAlignment((MutableAttributeSet)((Object)serializable2), 2);
        }
        serializable = ((FigText)serializable).getFont();
        StyleConstants.setFontFamily((MutableAttributeSet)((Object)serializable2), ((Font)serializable).getFamily());
        StyleConstants.setFontSize((MutableAttributeSet)((Object)serializable2), ((Font)serializable).getSize());
        this.setParagraphAttributes((AttributeSet)((Object)serializable2), true);
        if (inputEvent instanceof KeyEvent) {
            this.setSelectionStart(this.getDocument().getLength());
            this.setSelectionEnd(this.getDocument().getLength());
        }
        this.addFocusListener(this);
    }

    public static void configure(int n2, Border border, boolean bl2, Color color) {
        _extraSpace = n2;
        _border = border;
        _makeBrighter = bl2;
        _backgroundColor = color;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateFigText();
    }

    @Override
    public void endEditing() {
        if (this.figText == null) {
            return;
        }
        this.updateFigText();
        FigText figText = this.figText;
        this.cancelEditingInternal();
        figText.firePropChange("editing", true, false);
        Globals.curEditor().setActiveTextEditor(null);
    }

    @Override
    public void cancelEditing() {
        if (this.figText == null) {
            return;
        }
        this.cancelEditingInternal();
    }

    private void cancelEditingInternal() {
        this.removeFocusListener(this);
        this.setVisible(false);
        this.figText.endTrans();
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
        this.figText.removePropertyChangeListener(this);
        this.removeKeyListener(this);
        this.layeredPane.remove(this);
        this.drawingPanel.requestFocus();
        this.figText = null;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            if (this.figText.getReturnAction() == 2) {
                this.endEditing();
                keyEvent.consume();
                return;
            }
        } else if (keyEvent.getKeyCode() == 9) {
            if (this.figText.getTabAction() == 2) {
                this.endEditing();
                keyEvent.consume();
                return;
            }
        } else {
            if (keyEvent.getKeyCode() == 113) {
                this.endEditing();
                keyEvent.consume();
                return;
            }
            if (keyEvent.getKeyCode() == 27) {
                this.cancelEditing();
                keyEvent.consume();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateFigText();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateFigText();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateFigText();
    }

    protected void updateFigText() {
        if (this.figText == null) {
            return;
        }
        Object object = this.getText();
        this.figText.setTextFriend((String)object, this.getGraphics());
        if (this.figText.getReturnAction() == 1 && this.figText.isWordWrap()) {
            return;
        }
        object = this.figText.getBounds();
        double d2 = Globals.curEditor().getScale();
        ((Rectangle)object).x = (int)Math.round((double)((Rectangle)object).x * d2);
        ((Rectangle)object).y = (int)Math.round((double)((Rectangle)object).y * d2);
        if (d2 > 1.0) {
            ((Rectangle)object).width = (int)Math.round((double)((Rectangle)object).width * d2);
            ((Rectangle)object).height = (int)Math.round((double)((Rectangle)object).height * d2);
        }
        object = SwingUtilities.convertRectangle(this.drawingPanel, (Rectangle)object, this.layeredPane);
        this.setBounds(((Rectangle)object).x - _extraSpace, ((Rectangle)object).y - _extraSpace, ((Rectangle)object).width + (_extraSpace << 1), ((Rectangle)object).height + (_extraSpace << 1));
        this.setFont(this.figText.getFont());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.endEditing();
    }

    public FigText getFigText() {
        return this.figText;
    }
}

