/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.xml.svg;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigCircle;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigEdgePoly;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.FigInk;
import org.tigris.gef.presentation.FigLine;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.FigRRect;
import org.tigris.gef.presentation.FigRect;
import org.tigris.gef.presentation.FigSpline;
import org.tigris.gef.presentation.FigText;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class SVGParser
extends DefaultHandler {
    public static SVGParser SINGLETON = new SVGParser();
    protected Diagram _diagram = null;
    protected int _nestedGroups = 0;
    protected HashMap _figRegistry = null;
    protected Map _ownerRegistry = new HashMap();
    private int _elementState = 0;
    private static final int DEFAULT_STATE = 0;
    private static final int TEXT_STATE = 1;
    private static final int LINE_STATE = 2;
    private static final int POLY_STATE = 3;
    private static final int NODE_STATE = 4;
    private static final int EDGE_STATE = 5;
    private static final int PRIVATE_STATE = 6;
    private static final int PRIVATE_NODE_STATE = 64;
    private static final int PRIVATE_EDGE_STATE = 65;
    private static final int TEXT_NODE_STATE = 14;
    private static final int TEXT_EDGE_STATE = 15;
    private FigLine _currentLine = null;
    private int _x1Int = 0;
    private int _y1Int = 0;
    private FigText _currentText = null;
    private StringBuffer _textBuf = null;
    private FigPoly _currentPoly = null;
    private FigNode _currentNode = null;
    private FigEdge _currentEdge = null;
    private String[] _entityPaths = new String[]{"/org/tigris/gef/xml/dtd/"};

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        if ((this._elementState == 1 || this._elementState == 6 || this._elementState == 14 || this._elementState == 15 || this._elementState == 64 || this._elementState == 65) && this._textBuf != null) {
            this._textBuf.append(cArray, n2, n3);
        }
    }

    protected Color colorByName(String string, Color color) {
        if (string.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        try {
            return Color.decode(string);
        }
        catch (Exception exception) {
            System.out.println("invalid color code string: " + string);
            return color;
        }
    }

    private void edgeStateStartElement(String object, Attributes attributes) {
        if (!((String)object).equals("desc") && !((String)object).equals("title")) {
            if (((String)object).equals("path")) {
                object = this.handlePath(attributes);
                this._currentEdge.setFig((Fig)object);
                ((FigPoly)object).setComplete(true);
                this._currentEdge.calcBounds();
                if (this._currentEdge instanceof FigEdgePoly) {
                    ((FigEdgePoly)this._currentEdge).setInitiallyLaidOut(true);
                }
                return;
            }
            if (((String)object).equals("switch")) {
                this._elementState = 65;
                this._textBuf = new StringBuffer();
                return;
            }
            if (((String)object).equals("text")) {
                this._elementState = 15;
                this._textBuf = new StringBuffer();
                this.handleText(attributes);
            }
        }
    }

    public void endElement(String string) {
        switch (this._elementState) {
            case 0: {
                if (!"g".equals(string)) break;
                --this._nestedGroups;
                return;
            }
            case 3: {
                if (!string.equals("path")) break;
                this._elementState = 0;
                this._currentPoly = null;
                return;
            }
            case 2: {
                if (!string.equals("line")) break;
                this._elementState = 0;
                this._currentLine = null;
                return;
            }
            case 1: {
                if (!string.equals("text")) break;
                this._currentText.setText(this._textBuf.toString());
                this._elementState = 0;
                this._currentText = null;
                this._textBuf = null;
                return;
            }
            case 14: {
                if (!string.equals("text")) break;
                this._currentText.setText(this._textBuf.toString());
                this._elementState = 4;
                this._currentText = null;
                this._textBuf = null;
                return;
            }
            case 15: {
                if (!string.equals("text")) break;
                this._currentText.setText(this._textBuf.toString());
                this._elementState = 5;
                this._currentText = null;
                this._textBuf = null;
                return;
            }
            case 4: {
                this._elementState = 0;
                this._currentNode = null;
                this._textBuf = null;
                return;
            }
            case 6: {
                this.privateStateEndElement(string);
                this._textBuf = null;
                this._elementState = 0;
                return;
            }
            case 64: {
                this.privateStateEndElement(string);
                this._textBuf = null;
                this._elementState = 4;
                return;
            }
            case 65: {
                this.privateStateEndElement(string);
                this._textBuf = null;
                this._elementState = 5;
            }
        }
    }

    protected Fig findFig(String object) {
        if (((String)object).indexOf(".") == -1) {
            object = (Fig)this._figRegistry.get(object);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ".");
            object = stringTokenizer.nextToken();
            if ((object = (Fig)this._figRegistry.get(object)) instanceof FigEdge) {
                return ((FigEdge)object).getFig();
            }
            while (stringTokenizer.hasMoreElements()) {
                if (!(object instanceof FigGroup)) continue;
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                object = ((FigGroup)object).getFigAt(n2);
            }
        }
        return object;
    }

    protected Object findOwner(String string) {
        return this._ownerRegistry.get(string);
    }

    protected String[] getEntityPaths() {
        return this._entityPaths;
    }

    protected GraphModel getGraphModelFor(String string) {
        System.out.println("should be: " + string);
        return new DefaultGraphModel();
    }

    protected FigCircle handleEllipse(Attributes object) {
        FigCircle figCircle = new FigCircle(0, 0, 50, 50);
        this.setAttrs(figCircle, (Attributes)object);
        String string = object.getValue("cx");
        String string2 = object.getValue("cy");
        String string3 = object.getValue("rx");
        object = object.getValue("ry");
        int n2 = string == null || string.equals("") ? 0 : Integer.parseInt(string);
        int n3 = string2 == null || string2.equals("") ? 0 : Integer.parseInt(string2);
        int n4 = string3 == null || string3.equals("") ? 10 : Integer.parseInt(string3);
        int n5 = object == null || ((String)object).equals("") ? 10 : Integer.parseInt((String)object);
        figCircle.setBounds(n2 - n4, n3 - n5, n4 << 1, n5 << 1);
        return figCircle;
    }

    protected Fig handleGroup(Attributes attributes) {
        Fig fig = null;
        Object object = attributes.getValue("class");
        object = new StringTokenizer((String)object, ",;[] ");
        String string = this.translateClassName(((StringTokenizer)object).nextToken());
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (((StringTokenizer)object).hasMoreElements()) {
            string2 = ((StringTokenizer)object).nextToken();
            string3 = ((StringTokenizer)object).nextToken();
            string4 = ((StringTokenizer)object).nextToken();
            string5 = ((StringTokenizer)object).nextToken();
        }
        try {
            fig = (Fig)Class.forName(this.translateClassName(string)).newInstance();
            if (string2 != null && !string2.equals("")) {
                int n2 = Integer.parseInt(string2);
                int n3 = Integer.parseInt(string3);
                int n4 = Integer.parseInt(string4);
                int n5 = Integer.parseInt(string5);
                fig.setBounds(n2, n3, n4, n5);
            }
            if (fig instanceof FigNode) {
                FigNode figNode;
                this._currentNode = figNode = (FigNode)fig;
                this._elementState = 4;
                this._textBuf = new StringBuffer();
            }
            if (fig instanceof FigEdge) {
                this._currentEdge = (FigEdge)fig;
                this._elementState = 5;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in handleGroup");
            exception.printStackTrace();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            System.out.println("No constructor() in class " + string);
            noSuchMethodError.printStackTrace();
        }
        this.setAttrs(fig, attributes);
        return fig;
    }

    protected FigLine handleLine(Attributes attributes) {
        this._currentLine = new FigLine(0, 0, 100, 100);
        this.setAttrs(this._currentLine, attributes);
        this._x1Int = 0;
        this._y1Int = 0;
        this._elementState = 2;
        return this._currentLine;
    }

    protected FigPoly handlePath(Attributes object) {
        String string = object.getValue("class");
        FigPoly figPoly = null;
        if (string.equals("org.tigris.gef.presentation.FigPoly")) {
            figPoly = new FigPoly();
        } else if (string.equals("org.tigris.gef.presentation.FigSpline")) {
            figPoly = new FigSpline();
        } else if (string.equals("org.tigris.gef.presentation.FigInk")) {
            figPoly = new FigInk();
        }
        if (figPoly != null) {
            this.setAttrs(figPoly, (Attributes)object);
            this._currentPoly = figPoly;
            this._elementState = 3;
            object = object.getValue("d");
            int n2 = -1;
            int n3 = -1;
            try {
                object = new StringReader((String)object);
                object = new StreamTokenizer((Reader)object);
                int n4 = ((StreamTokenizer)object).nextToken();
                while (n4 != -1) {
                    if (n4 == -2) {
                        if (n2 == -1) {
                            n2 = (int)((StreamTokenizer)object).nval;
                        } else {
                            n3 = (int)((StreamTokenizer)object).nval;
                        }
                        if (n2 != -1 && n3 != -1) {
                            figPoly.addPoint(n2, n3);
                            n2 = -1;
                            n3 = -1;
                        }
                    }
                    n4 = ((StreamTokenizer)object).nextToken();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return figPoly;
    }

    protected Fig handlePolyLine(Attributes attributes) {
        String string = this.translateClassName(attributes.getValue("description"));
        if (string != null && string.indexOf("FigLine") != -1) {
            return this.handleLine(attributes);
        }
        return this.handlePath(attributes);
    }

    protected FigRect handleRect(Attributes attributes) {
        FigRect figRect;
        String string = attributes.getValue("rx");
        if (string == null || string.equals("")) {
            figRect = new FigRect(0, 0, 80, 80);
        } else {
            figRect = new FigRRect(0, 0, 80, 80);
            int n2 = Integer.parseInt(string);
            ((FigRRect)figRect).setCornerRadius(n2);
        }
        this.setAttrs(figRect, attributes);
        return figRect;
    }

    protected void handleSVG(Attributes object) {
        String string = object.getValue("id");
        object = object.getValue("class");
        try {
            if (object != null && !((String)object).equals("")) {
                this.initDiagram((String)object);
            }
            if (string != null && !string.equals("")) {
                this._diagram.setName(string);
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception in handleSVG");
            return;
        }
    }

    protected FigText handleText(Attributes object) {
        FigText figText = new FigText(100, 100, 90, 45);
        this.setAttrs(figText, (Attributes)object);
        this._elementState = 1;
        this._textBuf = new StringBuffer();
        this._currentText = figText;
        object = object.getValue("style");
        if (object != null) {
            String string = this.parseStyle("font", (String)object);
            if (string != null) {
                figText.setFontFamily(string);
            }
            if ((object = this.parseStyle("font-size", (String)object)) != null) {
                int n2 = Integer.parseInt((String)object);
                figText.setFontSize(n2);
            }
        }
        return figText;
    }

    protected void initDiagram(String string) {
        Object object = string;
        String string2 = null;
        int n2 = string.indexOf("|");
        if (n2 != -1) {
            object = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        }
        string = this.translateClassName((String)object);
        try {
            object = Class.forName(string);
            this._diagram = (Diagram)((Class)object).newInstance();
            if (string2 != null && !string2.equals("")) {
                this._diagram.initialize(this.findOwner(string2));
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("could not set diagram type to " + string);
            exception.printStackTrace();
            return;
        }
    }

    protected void lineStateStartElement(String string, Attributes object) {
        if (this._currentLine != null) {
            if (!string.equals("desc")) {
                string.equals("title");
            }
            if (string.equals("moveto")) {
                string = object.getValue("x");
                object = object.getValue("y");
                this._x1Int = string == null || string.equals("") ? 0 : Integer.parseInt(string);
                this._y1Int = object == null || ((String)object).equals("") ? 0 : Integer.parseInt((String)object);
                this._currentLine.setX1(this._x1Int);
                this._currentLine.setY1(this._y1Int);
                return;
            }
            if (string.equals("lineto")) {
                string = object.getValue("x");
                object = object.getValue("y");
                int n2 = string == null || string.equals("") ? this._x1Int : Integer.parseInt(string);
                int n3 = object == null || ((String)object).equals("") ? this._y1Int : Integer.parseInt((String)object);
                this._currentLine.setX2(n2);
                this._currentLine.setY2(n3);
            }
        }
    }

    private void nodeStateStartElement(String string, Attributes attributes) {
        if (!string.equals("desc") && !string.equals("title")) {
            if (string.equals("switch")) {
                this._textBuf = new StringBuffer();
                this._elementState = 64;
                return;
            }
            if (string.equals("text")) {
                this._textBuf = new StringBuffer();
                this._elementState = 14;
                this.handleText(attributes);
            }
        }
    }

    protected Color parseColor(String string, Color color) {
        try {
            int n2 = string.indexOf("rgb", 0);
            if (n2 != -1) {
                n2 = string.indexOf("(", n2);
                int n3 = string.indexOf(",", n2);
                if (n2 != -1) {
                    int n4 = Integer.parseInt(string.substring(++n2, n3).trim());
                    n2 = n3 + 1;
                    n3 = string.indexOf(",", n2);
                    int n5 = Integer.parseInt(string.substring(n2, n3).trim());
                    n2 = n3 + 1;
                    n3 = string.indexOf(")", n2);
                    n2 = Integer.parseInt(string.substring(n2, n3).trim());
                    return new Color(n4, n5, n2);
                }
                return color;
            }
        }
        catch (Exception exception) {
            System.out.println("invalid rgb() sequence: " + string);
            return color;
        }
        if (string.equalsIgnoreCase("none")) {
            return null;
        }
        if (string.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        try {
            return Color.decode(string);
        }
        catch (Exception exception) {
            System.out.println("invalid color code string: " + string);
            return color;
        }
    }

    protected String parseStyle(String string, String string2) {
        int n2 = string2.indexOf(string = string + ":", 0);
        if (n2 != -1) {
            int n3 = string2.indexOf(";", n2);
            if (n3 != -1) {
                return string2.substring(n2 + string.length(), n3).trim();
            }
            return string2.substring(n2 + string.length(), string2.length() - 1).trim();
        }
        return null;
    }

    private void polyStateStartElement(String string, Attributes object) {
        if (this._currentPoly != null && !string.equals("desc") && !string.equals("title")) {
            if (string.equals("moveto")) {
                string = object.getValue("x");
                object = object.getValue("y");
                this._x1Int = string == null || string.equals("") ? 0 : Integer.parseInt(string);
                this._y1Int = object == null || ((String)object).equals("") ? 0 : Integer.parseInt((String)object);
                this._currentPoly.addPoint(this._x1Int, this._y1Int);
                return;
            }
            if (string.equals("lineto")) {
                string = object.getValue("x");
                object = object.getValue("y");
                int n2 = string == null || string.equals("") ? this._x1Int : Integer.parseInt(string);
                int n3 = object == null || ((String)object).equals("") ? this._y1Int : Integer.parseInt((String)object);
                this._currentPoly.addPoint(n2, n3);
            }
        }
    }

    private void privateStateEndElement(String object) {
        Object object2;
        Object object3;
        Fig fig;
        Object object4;
        if (this._currentNode != null) {
            if (this._currentEdge != null) {
                this._currentEdge = null;
            }
            this._currentNode.setPrivateData(this._textBuf.toString());
            object = this._textBuf.toString();
            object4 = new StringTokenizer((String)object, "=\"' \t\n");
            fig = null;
            while (((StringTokenizer)object4).hasMoreElements()) {
                object3 = ((StringTokenizer)object4).nextToken();
                object2 = "no such fig";
                if (((StringTokenizer)object4).hasMoreElements()) {
                    object2 = ((StringTokenizer)object4).nextToken();
                }
                if (((String)object3).equals("enclosingFig")) {
                    fig = this.findFig((String)object2);
                }
                ((String)object3).equals("text");
            }
            this._currentNode.setEnclosingFig(fig);
        }
        if (this._currentEdge != null) {
            this._currentEdge.setPrivateData(this._textBuf.toString());
            object = null;
            object4 = null;
            fig = null;
            object3 = null;
            object2 = this._textBuf.toString();
            object2 = new StringTokenizer((String)object2, "=\"' \t\n");
            while (((StringTokenizer)object2).hasMoreElements()) {
                String string = ((StringTokenizer)object2).nextToken();
                String string2 = ((StringTokenizer)object2).nextToken();
                if (string.equals("sourcePortFig")) {
                    object = this.findFig(string2);
                }
                if (string.equals("destPortFig")) {
                    object4 = this.findFig(string2);
                }
                if (string.equals("sourceFigNode")) {
                    fig = (FigNode)this.findFig(string2);
                }
                if (!string.equals("destFigNode")) continue;
                object3 = (FigNode)this.findFig(string2);
            }
            this._currentEdge.setSourcePortFig((Fig)object);
            this._currentEdge.setDestPortFig((Fig)object4);
            this._currentEdge.setSourceFigNode((FigNode)fig);
            this._currentEdge.setDestFigNode((FigNode)object3);
        }
    }

    public synchronized Diagram readDiagram(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            uRL.getFile();
            System.out.println("=======================================");
            System.out.println("== READING DIAGRAM: " + uRL);
            Object object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(false);
            ((SAXParserFactory)object).setValidating(false);
            this.initDiagram("org.tigris.gef.base.Diagram");
            this._figRegistry = new HashMap();
            object = ((SAXParserFactory)object).newSAXParser();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(uRL.toString());
            ((SAXParser)object).parse(inputSource, (DefaultHandler)this);
            inputStream.close();
            return this._diagram;
        }
        catch (Exception exception) {
            System.out.println("Exception in readDiagram");
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        InputSource inputSource = null;
        try {
            URL uRL = new URL(string2);
            try {
                inputSource = new InputSource(uRL.openStream());
                inputSource.setSystemId(string2);
                if (string != null) {
                    inputSource.setPublicId(string);
                }
            }
            catch (IOException iOException) {
                if (string2.endsWith(".dtd")) {
                    int n2 = string2.lastIndexOf(47);
                    ++n2;
                    String[] stringArray = this.getEntityPaths();
                    InputStream inputStream = null;
                    for (int i2 = 0; i2 < stringArray.length && inputStream == null; ++i2) {
                        String string3 = stringArray[i2];
                        inputStream = this.getClass().getResourceAsStream(string3 + string2.substring(n2));
                        if (inputStream != null) continue;
                        try {
                            inputStream = new FileInputStream(string3.substring(1) + string2.substring(n2));
                            continue;
                        }
                        catch (Exception exception) {}
                    }
                    if (inputStream != null) {
                        inputSource = new InputSource(inputStream);
                        inputSource.setSystemId(string2);
                        if (string != null) {
                            inputSource.setPublicId(string);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {}
        if (inputSource == null) {
            inputSource = new InputSource();
            inputSource.setSystemId(string2);
        }
        return inputSource;
    }

    protected void setAttrs(Fig fig, Attributes attributes) {
        String string;
        String string2;
        String string3 = attributes.getValue("id");
        if (string3 != null && !string3.equals("")) {
            this._figRegistry.put(string3, fig);
        }
        if ((string3 = attributes.getValue("x")) != null && !string3.equals("")) {
            String string4 = attributes.getValue("y");
            String string5 = attributes.getValue("width");
            String string6 = attributes.getValue("height");
            int n2 = Integer.parseInt(string3);
            int n3 = string4 == null || string4.equals("") ? 0 : Integer.parseInt(string4);
            int n4 = string5 == null || string5.equals("") ? 20 : Integer.parseInt(string5);
            int n5 = string6 == null || string6.equals("") ? 20 : Integer.parseInt(string6);
            fig.setBounds(n2, n3, n4, n5);
        }
        if ((string2 = attributes.getValue("style")) != null) {
            String string7 = this.parseStyle("fill", string2);
            if (string7 != null && !string7.equals("")) {
                fig.setFillColor(this.parseColor(string7, Color.blue));
            }
            if (!(fig instanceof FigNode)) {
                String string8;
                String string9 = this.parseStyle("stroke-width", string2);
                if (string9 != null && !string9.equals("")) {
                    fig.setLineWidth(Integer.parseInt(string9));
                }
                if ((string8 = this.parseStyle("stroke", string2)) != null && !string8.equals("")) {
                    fig.setLineColor(this.parseColor(string8, Color.blue));
                }
                if ((string2 = this.parseStyle("stroke-dash-array", string2)) != null && !string2.equals("") && !string2.equals("1")) {
                    fig.setDashed(true);
                }
            }
        }
        if ((string = attributes.getValue("dynobjects")) != null && string.length() != 0 && fig instanceof FigGroup) {
            ((FigGroup)fig).parseDynObjects(string);
        }
        this.setOwnerAttr(fig, attributes);
    }

    protected void setOwnerAttr(Fig fig, Attributes object) {
        try {
            object = object.getValue("href");
            if (object != null && !((String)object).equals("")) {
                fig.setOwner(this.findOwner((String)object));
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("could not set owner");
            return;
        }
    }

    public void setOwnerRegistry(Map map) {
        this._ownerRegistry = map;
    }

    public void startElement(String string, Attributes attributes) {
        switch (this._elementState) {
            case 0: {
                if ("g".equals(string)) {
                    ++this._nestedGroups;
                    this._diagram.add(this.handleGroup(attributes));
                    return;
                }
                if (string.equals("svg")) {
                    this.handleSVG(attributes);
                    return;
                }
                if (this._nestedGroups == 0) {
                    if (string.equals("path")) {
                        this._diagram.add(this.handlePolyLine(attributes));
                        return;
                    }
                    if (string.equals("ellipse")) {
                        this._diagram.add(this.handleEllipse(attributes));
                        return;
                    }
                    if (string.equals("rect")) {
                        this._diagram.add(this.handleRect(attributes));
                        return;
                    }
                    if (string.equals("text")) {
                        this._elementState = 1;
                        this._diagram.add(this.handleText(attributes));
                        return;
                    }
                    if (string.equals("line") || string.equals("line") || string.equals("path")) break;
                    System.out.println("unknown top-level tag: " + string);
                    return;
                }
                if (this._nestedGroups <= 0) break;
                return;
            }
            case 2: {
                this.lineStateStartElement(string, attributes);
                return;
            }
            case 3: {
                this.polyStateStartElement(string, attributes);
                return;
            }
            case 4: {
                this.nodeStateStartElement(string, attributes);
                return;
            }
            case 5: {
                this.edgeStateStartElement(string, attributes);
            }
        }
    }

    protected String translateClassName(String string) {
        return string;
    }
}

