/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.COM4J;
import com4j.Com4jObject;
import com4j.ComException;
import com4j.ComMethod;
import com4j.ComThread;
import com4j.DISPID;
import com4j.DefaultedComMethod;
import com4j.DispatchComMethod;
import com4j.EventProxy;
import com4j.ExecutionException;
import com4j.GUID;
import com4j.IConnectionPointContainer;
import com4j.IllegalAnnotationException;
import com4j.Native;
import com4j.ReturnValue;
import com4j.StandardComMethod;
import com4j.Task;
import com4j.UseDefaultValues;
import com4j.VTID;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

final class Wrapper
implements InvocationHandler,
Com4jObject {
    private String name;
    private final long ptr;
    private boolean isDisposed = false;
    private long hashCode = 0L;
    final ComThread thread;
    private Map<Method, ComMethod> cache = Collections.synchronizedMap(new WeakHashMap());
    private static final Object[] EMPTY_ARRAY = new Object[0];
    InvocationThunk invCache;

    private Wrapper(long ptr) {
        if (ptr == 0L) {
            throw new IllegalArgumentException();
        }
        assert (ComThread.isComThread());
        this.ptr = ptr;
        this.thread = ComThread.get();
        this.thread.addLiveObject(this);
    }

    static <T extends Com4jObject> T create(Class<T> primaryInterface, long ptr) {
        Wrapper w = new Wrapper(ptr);
        Com4jObject r = (Com4jObject)primaryInterface.cast(Proxy.newProxyInstance(primaryInterface.getClassLoader(), new Class[]{primaryInterface}, (InvocationHandler)w));
        return (T)r;
    }

    static Com4jObject create(int ptr) {
        return Wrapper.create((long)ptr);
    }

    static Com4jObject create(long ptr) {
        Wrapper w = new Wrapper(ptr);
        return w;
    }

    @Override
    public int getPtr() {
        return (int)this.ptr;
    }

    @Override
    public long getPointer() {
        return this.ptr;
    }

    @Override
    public ComThread getComThread() {
        return this.thread;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declClazz;
        if (this.isDisposed) {
            throw new IllegalStateException("COM object is already disposed");
        }
        if (args == null) {
            args = EMPTY_ARRAY;
        }
        if ((declClazz = method.getDeclaringClass()) == Com4jObject.class || declClazz == Object.class) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        UseDefaultValues useDefaultValues = method.getAnnotation(UseDefaultValues.class);
        if (useDefaultValues != null) {
            int defValCount = useDefaultValues.optParamIndex().length;
            Object[] newArgs = new Object[args.length + defValCount];
            for (int i = 0; i < args.length; ++i) {
                newArgs[useDefaultValues.paramIndexMapping()[i]] = args[i];
            }
            ComMethod comMethod = this.getMethod(method);
            for (int i = 0; i < defValCount; ++i) {
                Object defParam;
                newArgs[useDefaultValues.optParamIndex()[i]] = defParam = comMethod.defaultParameters[i];
            }
            args = newArgs;
        }
        if (this.invCache == null) {
            this.invCache = new InvocationThunk();
        }
        try {
            return this.invCache.invoke(this.getMethod(method), args);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ComException) {
                throw new ComException((ComException)e.getCause());
            }
            throw e;
        }
    }

    private ComMethod getMethod(Method method) {
        ComMethod r = this.cache.get(method);
        if (r != null) {
            return r;
        }
        r = this.createComMethod(method);
        this.cache.put(method, r);
        return r;
    }

    private ComMethod createComMethod(Method method) {
        ReturnValue rv = method.getAnnotation(ReturnValue.class);
        if (rv != null && rv.defaultPropertyThrough().length > 0) {
            return new DefaultedComMethod(method, rv);
        }
        VTID vtid = method.getAnnotation(VTID.class);
        if (vtid != null) {
            return new StandardComMethod(method);
        }
        DISPID dispid = method.getAnnotation(DISPID.class);
        if (dispid != null) {
            return new DispatchComMethod(method);
        }
        throw new IllegalAnnotationException("Missing annotation: You need to specify at least one of @DISPID or @VTID");
    }

    @Override
    public void dispose() {
        if (!this.isDisposed) {
            new Task<Void>(){

                @Override
                public Void call() {
                    Wrapper.this.dispose0();
                    return null;
                }
            }.execute(this.thread);
        }
    }

    void dispose0() {
        if (!this.isDisposed) {
            Native.release(this.ptr);
            this.isDisposed = true;
            this.thread.removeLiveObject(this);
        }
    }

    @Override
    public <T extends Com4jObject> boolean is(Class<T> comInterface) {
        try {
            GUID iid = COM4J.getIID(comInterface);
            return (Long)new QITestTask(iid).execute(this.thread) != 0L;
        }
        catch (ComException e) {
            return false;
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public <T extends Com4jObject> T queryInterface(final Class<T> comInterface) {
        return (T)((Com4jObject)new Task<T>(){

            @Override
            public T call() {
                GUID iid = COM4J.getIID(comInterface);
                long nptr = Native.queryInterface(Wrapper.this.ptr, iid);
                if (nptr == 0L) {
                    return null;
                }
                return Wrapper.create(comInterface, nptr);
            }
        }.execute(this.thread));
    }

    @Override
    public <T> EventProxy<?> advise(final Class<T> eventInterface, final T object) {
        return (EventProxy)new Task<EventProxy<?>>(){

            @Override
            public EventProxy<?> call() {
                IConnectionPointContainer cpc = Wrapper.this.queryInterface(IConnectionPointContainer.class);
                if (cpc == null) {
                    throw new ComException("This object doesn't have event source", -1);
                }
                GUID iid = COM4J.getIID(eventInterface);
                Com4jObject cp = cpc.FindConnectionPoint(iid);
                EventProxy<Object> proxy = new EventProxy<Object>(eventInterface, object);
                proxy.nativeProxy = Native.advise(cp.getPointer(), proxy, iid.v[0], iid.v[1]);
                cpc.dispose();
                cp.dispose();
                return proxy;
            }
        }.execute();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        if (this.name == null) {
            return "ComObject:" + Long.toHexString(this.ptr);
        }
        return this.name + ":" + Long.toHexString(this.ptr);
    }

    @Override
    public final int hashCode() {
        long l = this.getIUnknownPointer();
        return (int)(l ^ l >>> 32);
    }

    @Override
    public long getIUnknownPointer() {
        if (this.hashCode == 0L) {
            this.hashCode = this.isDisposed ? 0L : (Long)new QITestTask(COM4J.IID_IUnknown).execute(this.thread);
        }
        return this.hashCode;
    }

    @Override
    public final boolean equals(Object rhs) {
        if (!(rhs instanceof Com4jObject)) {
            return false;
        }
        return this.getIUnknownPointer() == ((Com4jObject)rhs).getIUnknownPointer();
    }

    private final class QITestTask
    extends Task<Long> {
        private final GUID iid;

        public QITestTask(GUID iid) {
            this.iid = iid;
        }

        @Override
        public Long call() {
            long nptr = Native.queryInterface(Wrapper.this.ptr, this.iid);
            if (nptr != 0L) {
                Native.release(nptr);
            }
            return nptr;
        }
    }

    private class InvocationThunk
    extends Task<Object> {
        private ComMethod method;
        private Object[] args;

        private InvocationThunk() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Object invoke(ComMethod method, Object[] args) {
            Wrapper.this.invCache = null;
            this.method = method;
            this.args = args;
            try {
                Object t = this.execute(Wrapper.this.thread);
                return t;
            }
            finally {
                Wrapper.this.invCache = this;
            }
        }

        @Override
        public synchronized Object call() {
            Object r = this.method.invoke(Wrapper.this.ptr, this.args);
            this.method = null;
            this.args = null;
            return r;
        }
    }
}

