/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

final class DefaultDateTypeAdapter
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    private final DateFormat a;
    private final DateFormat b;
    private final DateFormat c;

    DefaultDateTypeAdapter() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    DefaultDateTypeAdapter(String string) {
        this(new SimpleDateFormat(string, Locale.US), new SimpleDateFormat(string));
    }

    public DefaultDateTypeAdapter(int n2, int n3) {
        this(DateFormat.getDateTimeInstance(n2, n3, Locale.US), DateFormat.getDateTimeInstance(n2, n3));
    }

    private DefaultDateTypeAdapter(DateFormat dateFormat, DateFormat dateFormat2) {
        this.a = dateFormat;
        this.b = dateFormat2;
        this.c = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        this.c.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JsonElement serialize(Date object, Type object2, JsonSerializationContext jsonSerializationContext) {
        object2 = this.b;
        synchronized (object2) {
            object = this.a.format((Date)object);
            return new JsonPrimitive((String)object);
        }
    }

    @Override
    public final Date deserialize(JsonElement object, Type type, JsonDeserializationContext jsonDeserializationContext) {
        if (!(object instanceof JsonPrimitive)) {
            throw new JsonParseException("The date should be a string value");
        }
        object = this.a((JsonElement)object);
        if (type == Date.class) {
            return object;
        }
        if (type == Timestamp.class) {
            return new Timestamp(((Date)object).getTime());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(((Date)object).getTime());
        }
        throw new IllegalArgumentException(this.getClass() + " cannot deserialize to " + type);
    }

    private Date a(JsonElement jsonElement) {
        DateFormat dateFormat = this.b;
        synchronized (dateFormat) {
            try {
                return this.b.parse(jsonElement.getAsString());
            }
            catch (ParseException parseException) {
                try {
                    return this.a.parse(jsonElement.getAsString());
                }
                catch (ParseException parseException2) {
                    try {
                        return this.c.parse(jsonElement.getAsString());
                    }
                    catch (ParseException parseException3) {
                        throw new JsonSyntaxException(jsonElement.getAsString(), parseException3);
                    }
                }
            }
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DefaultDateTypeAdapter.class.getSimpleName());
        stringBuilder.append('(').append(this.b.getClass().getSimpleName()).append(')');
        return stringBuilder.toString();
    }
}

