/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
final class MapTypeAdapterFactory$Adapter<K, V>
extends TypeAdapter<Map<K, V>> {
    private final TypeAdapter<K> a;
    private final TypeAdapter<V> b;
    private final ObjectConstructor<? extends Map<K, V>> a;
    private /* synthetic */ MapTypeAdapterFactory a;

    public MapTypeAdapterFactory$Adapter(MapTypeAdapterFactory mapTypeAdapterFactory, Gson gson, Type type, TypeAdapter<K> typeAdapter, Type type2, TypeAdapter<V> typeAdapter2, ObjectConstructor<? extends Map<K, V>> objectConstructor) {
        this.a = mapTypeAdapterFactory;
        this.a = new TypeAdapterRuntimeTypeWrapper<K>(gson, typeAdapter, type);
        this.b = new TypeAdapterRuntimeTypeWrapper<V>(gson, typeAdapter2, type2);
        this.a = objectConstructor;
    }

    @Override
    public final Map<K, V> read(JsonReader jsonReader) {
        JsonToken jsonToken = jsonReader.peek();
        if (jsonToken == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        Map map = (Map)this.a.construct();
        if (jsonToken == JsonToken.BEGIN_ARRAY) {
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                jsonReader.beginArray();
                jsonToken = this.a.read(jsonReader);
                V v2 = this.b.read(jsonReader);
                if (map.put(jsonToken, v2) != null) {
                    throw new JsonSyntaxException("duplicate key: " + (Object)((Object)jsonToken));
                }
                jsonReader.endArray();
            }
            jsonReader.endArray();
        } else {
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                V v3;
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue(jsonReader);
                jsonToken = this.a.read(jsonReader);
                if (map.put(jsonToken, v3 = this.b.read(jsonReader)) == null) continue;
                throw new JsonSyntaxException("duplicate key: " + (Object)((Object)jsonToken));
            }
            jsonReader.endObject();
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void write(JsonWriter jsonWriter, Map<K, V> iterator) {
        if (iterator == null) {
            jsonWriter.nullValue();
            return;
        }
        if (!MapTypeAdapterFactory.a(this.a)) {
            jsonWriter.beginObject();
            for (Map.Entry entry : iterator.entrySet()) {
                jsonWriter.name(String.valueOf(entry.getKey()));
                this.b.write(jsonWriter, entry.getValue());
            }
            jsonWriter.endObject();
            return;
        }
        boolean bl2 = false;
        ArrayList<JsonElement> arrayList = new ArrayList<JsonElement>(iterator.size());
        ArrayList arrayList2 = new ArrayList(iterator.size());
        for (Map.Entry entry : iterator.entrySet()) {
            JsonElement jsonElement = this.a.toJsonTree(entry.getKey());
            arrayList.add(jsonElement);
            arrayList2.add(entry.getValue());
            bl2 |= jsonElement.isJsonArray() || jsonElement.isJsonObject();
        }
        if (bl2) {
            jsonWriter.beginArray();
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                jsonWriter.beginArray();
                Streams.write((JsonElement)arrayList.get(i2), jsonWriter);
                this.b.write(jsonWriter, arrayList2.get(i2));
                jsonWriter.endArray();
            }
            jsonWriter.endArray();
            return;
        }
        jsonWriter.beginObject();
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            String string;
            JsonElement jsonElement = (JsonElement)arrayList.get(i3);
            JsonElement jsonElement2 = jsonElement;
            if (jsonElement2.isJsonPrimitive()) {
                if (((JsonPrimitive)(jsonElement2 = jsonElement2.getAsJsonPrimitive())).isNumber()) {
                    string = String.valueOf(((JsonPrimitive)jsonElement2).getAsNumber());
                } else if (((JsonPrimitive)jsonElement2).isBoolean()) {
                    string = Boolean.toString(((JsonPrimitive)jsonElement2).getAsBoolean());
                } else {
                    if (!((JsonPrimitive)jsonElement2).isString()) throw new AssertionError();
                    string = ((JsonPrimitive)jsonElement2).getAsString();
                }
            } else {
                if (!jsonElement2.isJsonNull()) throw new AssertionError();
                string = "null";
            }
            jsonWriter.name(string);
            this.b.write(jsonWriter, arrayList2.get(i3));
        }
        jsonWriter.endObject();
    }
}

