/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.detector.MathUtils;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class WhiteRectangleDetector {
    private final BitMatrix a;
    private final int a;
    private final int b;
    private final int c;
    private final int d;
    private final int e;
    private final int f;

    public WhiteRectangleDetector(BitMatrix bitMatrix) {
        this(bitMatrix, 10, bitMatrix.getWidth() / 2, bitMatrix.getHeight() / 2);
    }

    public WhiteRectangleDetector(BitMatrix bitMatrix, int n2, int n3, int n4) {
        this.a = bitMatrix;
        this.a = bitMatrix.getHeight();
        this.b = bitMatrix.getWidth();
        int n5 = n2 / 2;
        this.c = n3 - n5;
        this.d = n3 + n5;
        this.f = n4 - n5;
        this.e = n4 + n5;
        if (this.f < 0 || this.c < 0 || this.e >= this.a || this.d >= this.b) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    public final ResultPoint[] detect() {
        int n2;
        int n3;
        int n4;
        int n5 = this.c;
        int n6 = this.d;
        int n7 = this.f;
        int n8 = this.e;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        while (bl3) {
            bl3 = false;
            n4 = 1;
            while (!(n4 == 0 && bl5 || n6 >= this.b)) {
                boolean bl9 = this.a(n7, n8, n6, false);
                n4 = bl9 ? 1 : 0;
                if (bl9) {
                    ++n6;
                    bl3 = true;
                    bl5 = true;
                    continue;
                }
                if (bl5) continue;
                ++n6;
            }
            if (n6 >= this.b) {
                bl2 = true;
                break;
            }
            boolean bl10 = true;
            while ((bl10 || !bl6) && n8 < this.a) {
                bl10 = this.a(n5, n6, n8, true);
                if (bl10) {
                    ++n8;
                    bl3 = true;
                    bl6 = true;
                    continue;
                }
                if (bl6) continue;
                ++n8;
            }
            if (n8 >= this.a) {
                bl2 = true;
                break;
            }
            n3 = 1;
            while (!(n3 == 0 && bl7 || n5 < 0)) {
                boolean bl11 = this.a(n7, n8, n5, false);
                n3 = bl11 ? 1 : 0;
                if (bl11) {
                    --n5;
                    bl3 = true;
                    bl7 = true;
                    continue;
                }
                if (bl7) continue;
                --n5;
            }
            if (n5 < 0) {
                bl2 = true;
                break;
            }
            n2 = 1;
            while (!(n2 == 0 && bl8 || n7 < 0)) {
                boolean bl12 = this.a(n5, n6, n7, true);
                n2 = bl12 ? 1 : 0;
                if (bl12) {
                    --n7;
                    bl3 = true;
                    bl8 = true;
                    continue;
                }
                if (bl8) continue;
                --n7;
            }
            if (n7 < 0) {
                bl2 = true;
                break;
            }
            if (!bl3) continue;
            bl4 = true;
        }
        if (!bl2 && bl4) {
            n4 = n6 - n5;
            ResultPoint resultPoint = null;
            for (n3 = 1; resultPoint == null && n3 < n4; ++n3) {
                resultPoint = this.a((float)n5, (float)(n8 - n3), (float)(n5 + n3), n8);
            }
            if (resultPoint == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint resultPoint2 = null;
            for (n2 = 1; resultPoint2 == null && n2 < n4; ++n2) {
                resultPoint2 = this.a((float)n5, (float)(n7 + n2), (float)(n5 + n2), n7);
            }
            if (resultPoint2 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint resultPoint3 = null;
            for (n5 = 1; resultPoint3 == null && n5 < n4; ++n5) {
                resultPoint3 = this.a((float)n6, (float)(n7 + n5), (float)(n6 - n5), n7);
            }
            if (resultPoint3 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            Object object = null;
            for (n7 = 1; object == null && n7 < n4; ++n7) {
                object = this.a((float)n6, (float)(n8 - n7), (float)(n6 - n7), n8);
            }
            if (object == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint resultPoint4 = resultPoint2;
            ResultPoint resultPoint5 = resultPoint3;
            ResultPoint resultPoint6 = resultPoint;
            WhiteRectangleDetector whiteRectangleDetector = object;
            object = this;
            float f2 = ((ResultPoint)((Object)whiteRectangleDetector)).getX();
            float f3 = ((ResultPoint)((Object)whiteRectangleDetector)).getY();
            float f4 = resultPoint6.getX();
            float f5 = resultPoint6.getY();
            float f6 = resultPoint5.getX();
            float f7 = resultPoint5.getY();
            float f8 = resultPoint4.getX();
            float f9 = resultPoint4.getY();
            if (f2 < (float)((WhiteRectangleDetector)object).b / 2.0f) {
                return new ResultPoint[]{new ResultPoint(f8 - 1.0f, f9 + 1.0f), new ResultPoint(f4 + 1.0f, f5 + 1.0f), new ResultPoint(f6 - 1.0f, f7 - 1.0f), new ResultPoint(f2 + 1.0f, f3 - 1.0f)};
            }
            return new ResultPoint[]{new ResultPoint(f8 + 1.0f, f9 + 1.0f), new ResultPoint(f4 + 1.0f, f5 - 1.0f), new ResultPoint(f6 - 1.0f, f7 + 1.0f), new ResultPoint(f2 - 1.0f, f3 - 1.0f)};
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private ResultPoint a(float f2, float f3, float f4, float f5) {
        int n2 = MathUtils.round(MathUtils.distance(f2, f3, f4, f5));
        f4 = (f4 - f2) / (float)n2;
        f5 = (f5 - f3) / (float)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4 = MathUtils.round(f2 + (float)i2 * f4);
            if (!this.a.get(n4, n3 = MathUtils.round(f3 + (float)i2 * f5))) continue;
            return new ResultPoint(n4, n3);
        }
        return null;
    }

    private boolean a(int n2, int n3, int n4, boolean bl2) {
        if (bl2) {
            while (n2 <= n3) {
                if (this.a.get(n2, n4)) {
                    return true;
                }
                ++n2;
            }
        } else {
            while (n2 <= n3) {
                if (this.a.get(n4, n2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

