/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.multi.qrcode.detector.MultiFinderPatternFinder$ModuleSizeComparator;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternFinder;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class MultiFinderPatternFinder
extends FinderPatternFinder {
    private static final FinderPatternInfo[] a = new FinderPatternInfo[0];

    MultiFinderPatternFinder(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        super(bitMatrix, resultPointCallback);
    }

    public final FinderPatternInfo[] findMulti(Map<DecodeHintType, ?> map) {
        FinderPattern[][] finderPatternArrayArray;
        boolean bl2 = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        boolean bl3 = map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE);
        Cloneable cloneable = this.getImage();
        int n2 = ((BitMatrix)cloneable).getHeight();
        int n3 = ((BitMatrix)cloneable).getWidth();
        int n4 = (int)((float)n2 / 228.0f * 3.0f);
        if (n4 < 3 || bl2) {
            n4 = 3;
        }
        int[] nArray = new int[5];
        for (int i2 = n4 - 1; i2 < n2; i2 += n4) {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 0;
            nArray[4] = 0;
            int n5 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (((BitMatrix)cloneable).get(i3, i2)) {
                    if (n5 & true) {
                        // empty if block
                    }
                    int n6 = ++n5;
                    nArray[n6] = nArray[n6] + 1;
                    continue;
                }
                if (!(n5 & true)) {
                    if (n5 == 4) {
                        if (MultiFinderPatternFinder.foundPatternCross(nArray) && this.handlePossibleCenter(nArray, i2, i3, bl3)) {
                            n5 = 0;
                            nArray[0] = 0;
                            nArray[1] = 0;
                            nArray[2] = 0;
                            nArray[3] = 0;
                            nArray[4] = 0;
                            continue;
                        }
                        nArray[0] = nArray[2];
                        nArray[1] = nArray[3];
                        nArray[2] = nArray[4];
                        nArray[3] = 1;
                        nArray[4] = 0;
                        n5 = 3;
                        continue;
                    }
                    int n7 = ++n5;
                    nArray[n7] = nArray[n7] + 1;
                    continue;
                }
                int n8 = n5;
                nArray[n8] = nArray[n8] + 1;
            }
            if (!MultiFinderPatternFinder.foundPatternCross(nArray)) continue;
            this.handlePossibleCenter(nArray, i2, n3, bl3);
        }
        List<FinderPattern> list = this.getPossibleCenters();
        int n9 = list.size();
        if (n9 < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n9 == 3) {
            FinderPattern[][] finderPatternArrayArray2 = new FinderPattern[1][];
            finderPatternArrayArray = finderPatternArrayArray2;
            finderPatternArrayArray2[0] = new FinderPattern[]{list.get(0), list.get(1), list.get(2)};
        } else {
            Collections.sort(list, new MultiFinderPatternFinder$ModuleSizeComparator(0));
            cloneable = new ArrayList();
            block2: for (n2 = 0; n2 < n9 - 2; ++n2) {
                FinderPattern finderPattern = list.get(n2);
                if (finderPattern == null) continue;
                block3: for (n4 = n2 + 1; n4 < n9 - 1; ++n4) {
                    FinderPattern finderPattern2 = list.get(n4);
                    if (finderPattern2 == null) continue;
                    float f2 = (finderPattern.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize()) / Math.min(finderPattern.getEstimatedModuleSize(), finderPattern2.getEstimatedModuleSize());
                    if (Math.abs(finderPattern.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize()) > 0.5f && f2 >= 0.05f) continue block2;
                    for (int i4 = n4 + 1; i4 < n9; ++i4) {
                        ResultPoint[] resultPointArray = list.get(i4);
                        if (resultPointArray == null) continue;
                        float f3 = (finderPattern2.getEstimatedModuleSize() - resultPointArray.getEstimatedModuleSize()) / Math.min(finderPattern2.getEstimatedModuleSize(), resultPointArray.getEstimatedModuleSize());
                        if (Math.abs(finderPattern2.getEstimatedModuleSize() - resultPointArray.getEstimatedModuleSize()) > 0.5f && f3 >= 0.05f) continue block3;
                        resultPointArray = new FinderPattern[]{finderPattern, finderPattern2, resultPointArray};
                        ResultPoint.orderBestPatterns(resultPointArray);
                        FinderPatternInfo finderPatternInfo = new FinderPatternInfo((FinderPattern[])resultPointArray);
                        float f4 = ResultPoint.distance(finderPatternInfo.getTopLeft(), finderPatternInfo.getBottomLeft());
                        float f5 = ResultPoint.distance(finderPatternInfo.getTopRight(), finderPatternInfo.getBottomLeft());
                        f3 = ResultPoint.distance(finderPatternInfo.getTopLeft(), finderPatternInfo.getTopRight());
                        float f6 = (f4 + f3) / (finderPattern.getEstimatedModuleSize() * 2.0f);
                        if (f6 > 180.0f || f6 < 9.0f || Math.abs((f4 - f3) / Math.min(f4, f3)) >= 0.1f || Math.abs((f5 - (f3 = (float)Math.sqrt(f4 * f4 + f3 * f3))) / Math.min(f5, f3)) >= 0.1f) continue;
                        cloneable.add(resultPointArray);
                    }
                }
            }
            if (!cloneable.isEmpty()) {
                finderPatternArrayArray = (FinderPattern[][])cloneable.toArray((T[])new FinderPattern[cloneable.size()][]);
            } else {
                throw NotFoundException.getNotFoundInstance();
            }
        }
        FinderPattern[][] finderPatternArrayArray3 = finderPatternArrayArray;
        ArrayList<FinderPatternInfo> arrayList = new ArrayList<FinderPatternInfo>();
        FinderPattern[][] finderPatternArrayArray4 = finderPatternArrayArray3;
        int n10 = finderPatternArrayArray3.length;
        for (n9 = 0; n9 < n10; ++n9) {
            cloneable = finderPatternArrayArray4[n9];
            ResultPoint.orderBestPatterns((ResultPoint[])cloneable);
            arrayList.add(new FinderPatternInfo((FinderPattern[])cloneable));
        }
        if (arrayList.isEmpty()) {
            return a;
        }
        return arrayList.toArray(new FinderPatternInfo[arrayList.size()]);
    }
}

