/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.util.AstUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AgiRequestImpl
implements AgiRequest {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final Pattern SCRIPT_PATTERN = Pattern.compile("^([^\\?]*)\\?(.*)$");
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("^(.*)=(.*)$");
    private String rawCallerId;
    private Map<String, String> request;
    private Map<String, String[]> parameterMap;
    private String[] arguments;
    private String parameters;
    private String script;
    private boolean callerIdCreated;
    private InetAddress localAddress;
    private int localPort;
    private InetAddress remoteAddress;
    private int remotePort;

    AgiRequestImpl(List<String> list) {
        this(AgiRequestImpl.buildMap(list));
    }

    private AgiRequestImpl(Map<String, String> object) {
        this.request = object;
        this.script = object.get("network_script");
        if (this.script != null && ((Matcher)(object = SCRIPT_PATTERN.matcher(this.script))).matches()) {
            this.script = ((Matcher)object).group(1);
            this.parameters = ((Matcher)object).group(2);
        }
    }

    private static Map<String, String> buildMap(Collection<String> object) {
        if (object == null) {
            throw new IllegalArgumentException("Environment must not be null.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            int n2 = string.indexOf(58);
            if (n2 < 0 || !string.startsWith("agi_") && !string.startsWith("ogi_") || string.length() < n2 + 2) continue;
            String string2 = string.substring(4, n2).toLowerCase(Locale.ENGLISH);
            if ((string = string.substring(n2 + 2)).length() == 0) continue;
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    @Override
    public Map<String, String> getRequest() {
        return this.request;
    }

    @Override
    public synchronized String getScript() {
        return this.script;
    }

    @Override
    public String getRequestURL() {
        return this.request.get("request");
    }

    @Override
    public String getChannel() {
        return this.request.get("channel");
    }

    @Override
    public String getUniqueId() {
        return this.request.get("uniqueid");
    }

    @Override
    public String getType() {
        return this.request.get("type");
    }

    @Override
    public String getLanguage() {
        return this.request.get("language");
    }

    @Override
    @Deprecated
    public String getCallerId() {
        return this.getCallerIdNumber();
    }

    @Override
    public String getCallerIdNumber() {
        String string = this.request.get("calleridname");
        String string2 = this.request.get("callerid");
        if (string != null) {
            if (string2 == null || "unknown".equals(string2)) {
                return null;
            }
            return string2;
        }
        return this.getCallerId10();
    }

    @Override
    public String getCallerIdName() {
        String string = this.request.get("calleridname");
        if (string != null) {
            if ("unknown".equals(string)) {
                return null;
            }
            return string;
        }
        return this.getCallerIdName10();
    }

    private synchronized String getCallerId10() {
        String[] stringArray;
        if (!this.callerIdCreated) {
            this.rawCallerId = this.request.get("callerid");
            this.callerIdCreated = true;
        }
        if ((stringArray = AstUtil.parseCallerId(this.rawCallerId))[1] == null) {
            return stringArray[0];
        }
        return stringArray[1];
    }

    private synchronized String getCallerIdName10() {
        if (!this.callerIdCreated) {
            this.rawCallerId = this.request.get("callerid");
            this.callerIdCreated = true;
        }
        return AstUtil.parseCallerId(this.rawCallerId)[0];
    }

    @Override
    public String getDnid() {
        String string = this.request.get("dnid");
        if (string == null || "unknown".equals(string)) {
            return null;
        }
        return string;
    }

    @Override
    public String getRdnis() {
        String string = this.request.get("rdnis");
        if (string == null || "unknown".equals(string)) {
            return null;
        }
        return string;
    }

    @Override
    public String getContext() {
        return this.request.get("context");
    }

    @Override
    public String getExtension() {
        return this.request.get("extension");
    }

    @Override
    public Integer getPriority() {
        if (this.request.get("priority") != null) {
            return Integer.valueOf(this.request.get("priority"));
        }
        return null;
    }

    @Override
    public Boolean getEnhanced() {
        if (this.request.get("enhanced") != null) {
            if ("1.0".equals(this.request.get("enhanced"))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public String getAccountCode() {
        return this.request.get("accountcode");
    }

    @Override
    public Integer getCallingAni2() {
        if (this.request.get("callingani2") == null) {
            return null;
        }
        try {
            return Integer.valueOf(this.request.get("callingani2"));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public Integer getCallingPres() {
        if (this.request.get("callingpres") == null) {
            return null;
        }
        try {
            return Integer.valueOf(this.request.get("callingpres"));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public Integer getCallingTns() {
        if (this.request.get("callingtns") == null) {
            return null;
        }
        try {
            return Integer.valueOf(this.request.get("callingtns"));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public Integer getCallingTon() {
        if (this.request.get("callington") == null) {
            return null;
        }
        try {
            return Integer.valueOf(this.request.get("callington"));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public String getParameter(String stringArray) {
        if ((stringArray = this.getParameterValues((String)stringArray)) == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    @Override
    public synchronized String[] getParameterValues(String stringArray) {
        if (this.getParameterMap().isEmpty()) {
            return new String[0];
        }
        if ((stringArray = this.parameterMap.get(stringArray)) == null) {
            return new String[0];
        }
        return stringArray;
    }

    @Override
    public synchronized Map<String, String[]> getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = this.parseParameters(this.parameters);
        }
        return this.parameterMap;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Map<String, String[]> parseParameters(String object) {
        String[] stringArray;
        HashMap hashMap = new HashMap();
        HashMap<String, String[]> hashMap2 = new HashMap<String, String[]>();
        if (object == null) {
            return hashMap2;
        }
        object = new StringTokenizer((String)object, "&");
        while (((StringTokenizer)object).hasMoreTokens()) {
            void var5_11;
            Object object3;
            block9: {
                object3 = ((StringTokenizer)object).nextToken();
                Matcher unsupportedEncodingException = PARAMETER_PATTERN.matcher((CharSequence)object3);
                if (unsupportedEncodingException.matches()) {
                    try {
                        stringArray = URLDecoder.decode(unsupportedEncodingException.group(1), "UTF-8");
                        String unsupportedEncodingException2 = URLDecoder.decode(unsupportedEncodingException.group(2), "UTF-8");
                        break block9;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException3) {
                        this.logger.error("Unable to decode parameter '" + (String)object3 + "'", unsupportedEncodingException3);
                        continue;
                    }
                }
                try {
                    stringArray = URLDecoder.decode((String)object3, "UTF-8");
                    String string = "";
                }
                catch (UnsupportedEncodingException unsupportedEncodingException4) {
                    this.logger.error("Unable to decode parameter '" + (String)object3 + "'", unsupportedEncodingException4);
                    continue;
                }
            }
            if (hashMap.get(stringArray) == null) {
                object3 = new ArrayList<void>();
                object3.add(var5_11);
                hashMap.put(stringArray, object3);
                continue;
            }
            ((List)hashMap.get(stringArray)).add(var5_11);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            stringArray = new String[((List)entry.getValue()).size()];
            hashMap2.put((String)entry.getKey(), ((List)entry.getValue()).toArray(stringArray));
        }
        return hashMap2;
    }

    @Override
    public synchronized String[] getArguments() {
        if (this.arguments != null) {
            return (String[])this.arguments.clone();
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        int n2 = 0;
        for (Map.Entry<String, String> entry : this.request.entrySet()) {
            if (!entry.getKey().startsWith("arg_")) continue;
            int n3 = Integer.valueOf(entry.getKey().substring(4));
            if (n3 > n2) {
                n2 = n3;
            }
            hashMap.put(n3, entry.getValue());
        }
        this.arguments = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.arguments[i2] = (String)hashMap.get(i2 + 1);
        }
        return (String[])this.arguments.clone();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    void setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    void setLocalPort(int n2) {
        this.localPort = n2;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    void setRemoteAddress(InetAddress inetAddress) {
        this.remoteAddress = inetAddress;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    void setRemotePort(int n2) {
        this.remotePort = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AgiRequest[");
        stringBuffer.append("script='").append(this.getScript()).append("',");
        stringBuffer.append("requestURL='").append(this.getRequestURL()).append("',");
        stringBuffer.append("channel='").append(this.getChannel()).append("',");
        stringBuffer.append("uniqueId='").append(this.getUniqueId()).append("',");
        stringBuffer.append("type='").append(this.getType()).append("',");
        stringBuffer.append("language='").append(this.getLanguage()).append("',");
        stringBuffer.append("callerIdNumber='").append(this.getCallerIdNumber()).append("',");
        stringBuffer.append("callerIdName='").append(this.getCallerIdName()).append("',");
        stringBuffer.append("dnid='").append(this.getDnid()).append("',");
        stringBuffer.append("rdnis='").append(this.getRdnis()).append("',");
        stringBuffer.append("context='").append(this.getContext()).append("',");
        stringBuffer.append("extension='").append(this.getExtension()).append("',");
        stringBuffer.append("priority='").append(this.getPriority()).append("',");
        stringBuffer.append("enhanced='").append(this.getEnhanced()).append("',");
        stringBuffer.append("accountCode='").append(this.getAccountCode()).append("',");
        stringBuffer.append("systemHashcode=").append(System.identityHashCode(this));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

