/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.config.ConfigFile;
import org.asteriskjava.live.AsteriskAgent;
import org.asteriskjava.live.AsteriskChannel;
import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.AsteriskQueueEntry;
import org.asteriskjava.live.AsteriskServer;
import org.asteriskjava.live.AsteriskServerListener;
import org.asteriskjava.live.CallerId;
import org.asteriskjava.live.ChannelState;
import org.asteriskjava.live.LiveException;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.MeetMeRoom;
import org.asteriskjava.live.MeetMeUser;
import org.asteriskjava.live.NoSuchChannelException;
import org.asteriskjava.live.OriginateCallback;
import org.asteriskjava.live.Voicemailbox;
import org.asteriskjava.live.internal.AgentManager;
import org.asteriskjava.live.internal.AsteriskAgentImpl;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.ChannelManager;
import org.asteriskjava.live.internal.ConfigFileImpl;
import org.asteriskjava.live.internal.ManagerCommunicationExceptionMapper;
import org.asteriskjava.live.internal.MeetMeManager;
import org.asteriskjava.live.internal.OriginateCallbackData;
import org.asteriskjava.live.internal.QueueManager;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.ManagerEventListenerProxy;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.action.CommandAction;
import org.asteriskjava.manager.action.DbGetAction;
import org.asteriskjava.manager.action.DbPutAction;
import org.asteriskjava.manager.action.EventGeneratingAction;
import org.asteriskjava.manager.action.GetConfigAction;
import org.asteriskjava.manager.action.GetVarAction;
import org.asteriskjava.manager.action.MailboxCountAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.ModuleCheckAction;
import org.asteriskjava.manager.action.ModuleLoadAction;
import org.asteriskjava.manager.action.OriginateAction;
import org.asteriskjava.manager.action.SetVarAction;
import org.asteriskjava.manager.action.SipPeersAction;
import org.asteriskjava.manager.event.AbstractMeetMeEvent;
import org.asteriskjava.manager.event.AgentCallbackLoginEvent;
import org.asteriskjava.manager.event.AgentCallbackLogoffEvent;
import org.asteriskjava.manager.event.AgentCalledEvent;
import org.asteriskjava.manager.event.AgentCompleteEvent;
import org.asteriskjava.manager.event.AgentConnectEvent;
import org.asteriskjava.manager.event.AgentLoginEvent;
import org.asteriskjava.manager.event.AgentLogoffEvent;
import org.asteriskjava.manager.event.AgentsEvent;
import org.asteriskjava.manager.event.BridgeEvent;
import org.asteriskjava.manager.event.CdrEvent;
import org.asteriskjava.manager.event.ConnectEvent;
import org.asteriskjava.manager.event.DbGetResponseEvent;
import org.asteriskjava.manager.event.DialEvent;
import org.asteriskjava.manager.event.DisconnectEvent;
import org.asteriskjava.manager.event.DtmfEvent;
import org.asteriskjava.manager.event.HangupEvent;
import org.asteriskjava.manager.event.JoinEvent;
import org.asteriskjava.manager.event.LeaveEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.MonitorStartEvent;
import org.asteriskjava.manager.event.MonitorStopEvent;
import org.asteriskjava.manager.event.NewCallerIdEvent;
import org.asteriskjava.manager.event.NewChannelEvent;
import org.asteriskjava.manager.event.NewExtenEvent;
import org.asteriskjava.manager.event.NewStateEvent;
import org.asteriskjava.manager.event.OriginateResponseEvent;
import org.asteriskjava.manager.event.ParkedCallEvent;
import org.asteriskjava.manager.event.ParkedCallGiveUpEvent;
import org.asteriskjava.manager.event.ParkedCallTimeOutEvent;
import org.asteriskjava.manager.event.PeerEntryEvent;
import org.asteriskjava.manager.event.QueueMemberAddedEvent;
import org.asteriskjava.manager.event.QueueMemberPausedEvent;
import org.asteriskjava.manager.event.QueueMemberPenaltyEvent;
import org.asteriskjava.manager.event.QueueMemberRemovedEvent;
import org.asteriskjava.manager.event.QueueMemberStatusEvent;
import org.asteriskjava.manager.event.RenameEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.manager.event.UnparkedCallEvent;
import org.asteriskjava.manager.event.VarSetEvent;
import org.asteriskjava.manager.response.CommandResponse;
import org.asteriskjava.manager.response.GetConfigResponse;
import org.asteriskjava.manager.response.MailboxCountResponse;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.manager.response.ModuleCheckResponse;
import org.asteriskjava.util.AstUtil;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AsteriskServerImpl
implements AsteriskServer,
ManagerEventListener {
    private static final String ACTION_ID_PREFIX_ORIGINATE = "AJ_ORIGINATE_";
    private static final String SHOW_VERSION_COMMAND = "show version";
    private static final String SHOW_VERSION_1_6_COMMAND = "core show version";
    private static final String SHOW_VERSION_FILES_COMMAND = "show version files";
    private static final String SHOW_VERSION_FILES_1_6_COMMAND = "core show file version";
    private static final Pattern SHOW_VERSION_FILES_PATTERN = Pattern.compile("^([\\S]+)\\s+Revision: ([0-9\\.]+)");
    private static final String SHOW_VOICEMAIL_USERS_COMMAND = "show voicemail users";
    private static final String SHOW_VOICEMAIL_USERS_1_6_COMMAND = "voicemail show users";
    private static final Pattern SHOW_VOICEMAIL_USERS_PATTERN = Pattern.compile("^(\\S+)\\s+(\\S+)\\s+(.{25})");
    private final Log logger = LogFactory.getLog(this.getClass());
    private ManagerConnection eventConnection;
    private ManagerEventListener eventListener = null;
    ManagerEventListenerProxy managerEventListenerProxy;
    private boolean initialized = false;
    private boolean initializing = false;
    final Set<AsteriskServerListener> listeners;
    final ChannelManager channelManager;
    final MeetMeManager meetMeManager;
    final QueueManager queueManager;
    final AgentManager agentManager;
    private String version;
    private Map<String, String> versions;
    private final Map<String, OriginateCallbackData> originateCallbacks;
    private final AtomicLong idCounter;
    private boolean skipQueues;
    private boolean asyncEventHandling = true;
    private List<ManagerEventListener> chainListeners = new ArrayList<ManagerEventListener>();

    public AsteriskServerImpl() {
        this.idCounter = new AtomicLong();
        this.listeners = new LinkedHashSet<AsteriskServerListener>();
        this.originateCallbacks = new HashMap<String, OriginateCallbackData>();
        this.channelManager = new ChannelManager(this);
        this.agentManager = new AgentManager(this);
        this.meetMeManager = new MeetMeManager(this, this.channelManager);
        this.queueManager = new QueueManager(this, this.channelManager);
    }

    public AsteriskServerImpl(ManagerConnection managerConnection) {
        this();
        this.setManagerConnection(managerConnection);
    }

    public void setSkipQueues(boolean bl2) {
        this.skipQueues = bl2;
    }

    public void setManagerConnection(ManagerConnection managerConnection) {
        if (this.eventConnection != null) {
            throw new IllegalStateException("ManagerConnection already set.");
        }
        this.eventConnection = managerConnection;
    }

    @Override
    public ManagerConnection getManagerConnection() {
        return this.eventConnection;
    }

    @Override
    public void initialize() {
        this.initializeIfNeeded();
    }

    private synchronized void initializeIfNeeded() {
        if (this.initialized || this.initializing) {
            return;
        }
        this.initializing = true;
        if (this.eventConnection.getState() == ManagerConnectionState.INITIAL || this.eventConnection.getState() == ManagerConnectionState.DISCONNECTED) {
            try {
                this.eventConnection.login();
            }
            catch (Exception exception) {
                throw new ManagerCommunicationException("Unable to login: " + exception.getMessage(), exception);
            }
        }
        this.channelManager.initialize();
        this.agentManager.initialize();
        this.meetMeManager.initialize();
        if (!this.skipQueues) {
            this.queueManager.initialize();
        }
        if (this.asyncEventHandling && this.managerEventListenerProxy == null) {
            this.managerEventListenerProxy = new ManagerEventListenerProxy(this);
            this.eventConnection.addEventListener(this.managerEventListenerProxy);
        } else if (!this.asyncEventHandling && this.eventListener == null) {
            this.eventListener = this;
            this.eventConnection.addEventListener(this.eventListener);
        }
        this.logger.info("Initializing done");
        this.initializing = false;
        this.initialized = true;
    }

    @Override
    public AsteriskChannel originateToExtension(String string, String string2, String string3, int n2, long l2) {
        return this.originateToExtension(string, string2, string3, n2, l2, null, null);
    }

    @Override
    public AsteriskChannel originateToExtension(String string, String string2, String string3, int n2, long l2, CallerId callerId, Map<String, String> map) {
        OriginateAction originateAction = new OriginateAction();
        originateAction.setChannel(string);
        originateAction.setContext(string2);
        originateAction.setExten(string3);
        originateAction.setPriority(n2);
        originateAction.setTimeout(l2);
        if (callerId != null) {
            originateAction.setCallerId(callerId.toString());
        }
        originateAction.setVariables(map);
        return this.originate(originateAction);
    }

    @Override
    public AsteriskChannel originateToApplication(String string, String string2, String string3, long l2) {
        return this.originateToApplication(string, string2, string3, l2, null, null);
    }

    @Override
    public AsteriskChannel originateToApplication(String string, String string2, String string3, long l2, CallerId callerId, Map<String, String> map) {
        OriginateAction originateAction = new OriginateAction();
        originateAction.setChannel(string);
        originateAction.setApplication(string2);
        originateAction.setData(string3);
        originateAction.setTimeout(l2);
        if (callerId != null) {
            originateAction.setCallerId(callerId.toString());
        }
        originateAction.setVariables(map);
        return this.originate(originateAction);
    }

    @Override
    public AsteriskChannel originate(OriginateAction originateAction) {
        ResponseEvent responseEvent;
        AsteriskChannel asteriskChannel = null;
        originateAction.setAsync(Boolean.TRUE);
        this.initializeIfNeeded();
        Object object = this.sendEventGeneratingAction(originateAction, originateAction.getTimeout() + 2000L).getEvents().iterator();
        if (object.hasNext() && (responseEvent = object.next()) instanceof OriginateResponseEvent) {
            object = ((OriginateResponseEvent)responseEvent).getUniqueId();
            this.logger.debug(responseEvent.getClass().getName() + " received with uniqueId " + (String)object);
            asteriskChannel = this.getChannelById((String)object);
        }
        if (asteriskChannel == null) {
            throw new NoSuchChannelException("Channel '" + originateAction.getChannel() + "' is not available");
        }
        return asteriskChannel;
    }

    @Override
    public void originateToExtensionAsync(String string, String string2, String string3, int n2, long l2, OriginateCallback originateCallback) {
        this.originateToExtensionAsync(string, string2, string3, n2, l2, null, null, originateCallback);
    }

    @Override
    public void originateToExtensionAsync(String string, String string2, String string3, int n2, long l2, CallerId callerId, Map<String, String> map, OriginateCallback originateCallback) {
        OriginateAction originateAction = new OriginateAction();
        originateAction.setChannel(string);
        originateAction.setContext(string2);
        originateAction.setExten(string3);
        originateAction.setPriority(n2);
        originateAction.setTimeout(l2);
        if (callerId != null) {
            originateAction.setCallerId(callerId.toString());
        }
        originateAction.setVariables(map);
        this.originateAsync(originateAction, originateCallback);
    }

    @Override
    public void originateToApplicationAsync(String string, String string2, String string3, long l2, OriginateCallback originateCallback) {
        this.originateToApplicationAsync(string, string2, string3, l2, null, null, originateCallback);
    }

    @Override
    public void originateToApplicationAsync(String string, String string2, String string3, long l2, CallerId callerId, Map<String, String> map, OriginateCallback originateCallback) {
        OriginateAction originateAction = new OriginateAction();
        originateAction.setChannel(string);
        originateAction.setApplication(string2);
        originateAction.setData(string3);
        originateAction.setTimeout(l2);
        if (callerId != null) {
            originateAction.setCallerId(callerId.toString());
        }
        originateAction.setVariables(map);
        this.originateAsync(originateAction, originateCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void originateAsync(OriginateAction originateAction, OriginateCallback object) {
        String string = ACTION_ID_PREFIX_ORIGINATE + this.idCounter.getAndIncrement();
        Map<String, Object> map = originateAction.getVariables() == null ? new HashMap<String, String>() : new HashMap<String, String>(originateAction.getVariables());
        map.put("__AJ_TRACE_ID", string);
        originateAction.setVariables(map);
        originateAction.setAsync(Boolean.TRUE);
        originateAction.setActionId(string);
        if (object != null) {
            object = new OriginateCallbackData(originateAction, DateUtil.getDate(), (OriginateCallback)object);
            map = this.originateCallbacks;
            synchronized (map) {
                this.originateCallbacks.put(string, (OriginateCallbackData)object);
            }
        }
        this.initializeIfNeeded();
        this.sendActionOnEventConnection(originateAction);
    }

    @Override
    public Collection<AsteriskChannel> getChannels() {
        this.initializeIfNeeded();
        return this.channelManager.getChannels();
    }

    @Override
    public AsteriskChannel getChannelByName(String string) {
        this.initializeIfNeeded();
        return this.channelManager.getChannelImplByName(string);
    }

    @Override
    public AsteriskChannel getChannelById(String string) {
        this.initializeIfNeeded();
        return this.channelManager.getChannelImplById(string);
    }

    @Override
    public Collection<MeetMeRoom> getMeetMeRooms() {
        this.initializeIfNeeded();
        return this.meetMeManager.getMeetMeRooms();
    }

    @Override
    public MeetMeRoom getMeetMeRoom(String string) {
        this.initializeIfNeeded();
        return this.meetMeManager.getOrCreateRoomImpl(string);
    }

    @Override
    public Collection<AsteriskQueue> getQueues() {
        this.initializeIfNeeded();
        return this.queueManager.getQueues();
    }

    @Override
    public synchronized String getVersion() {
        this.initializeIfNeeded();
        if (this.version == null) {
            String string = this.eventConnection.getVersion().isAtLeast(AsteriskVersion.ASTERISK_1_6) ? SHOW_VERSION_1_6_COMMAND : SHOW_VERSION_COMMAND;
            Object object = this.sendAction(new CommandAction(string));
            if (object instanceof CommandResponse) {
                if ((object = ((CommandResponse)object).getResult()).size() > 0) {
                    this.version = (String)object.get(0);
                }
            } else {
                this.logger.error("Response to CommandAction(\"" + string + "\") was not a CommandResponse but " + object);
            }
        }
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getVersion(String stringArray) {
        Object object;
        block13: {
            Map<Object, Object> map;
            object = null;
            this.initializeIfNeeded();
            if (this.versions == null) {
                map = new HashMap();
                try {
                    String string = this.eventConnection.getVersion().isAtLeast(AsteriskVersion.ASTERISK_1_6) ? SHOW_VERSION_FILES_1_6_COMMAND : SHOW_VERSION_FILES_COMMAND;
                    Object object2 = this.sendAction(new CommandAction(string));
                    if (object2 instanceof CommandResponse) {
                        object2 = ((CommandResponse)object2).getResult();
                        for (int i2 = 2; i2 < object2.size(); ++i2) {
                            Object object3 = (String)object2.get(i2);
                            if (!((Matcher)(object3 = SHOW_VERSION_FILES_PATTERN.matcher((CharSequence)object3))).find()) continue;
                            String string2 = ((Matcher)object3).group(1);
                            object3 = ((Matcher)object3).group(2);
                            map.put(string2, object3);
                        }
                        object = (String)map.get(stringArray);
                        this.versions = map;
                        break block13;
                    }
                    this.logger.error("Response to CommandAction(\"" + string + "\") was not a CommandResponse but " + object2);
                }
                catch (Exception exception) {
                    this.logger.warn("Unable to send 'show version files' command.", exception);
                }
            } else {
                map = this.versions;
                synchronized (map) {
                    object = this.versions.get(stringArray);
                }
            }
        }
        if (object == null) {
            return null;
        }
        stringArray = ((String)object).split("\\.");
        object = new int[stringArray.length];
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            try {
                object[i3] = Integer.parseInt(stringArray[i3]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                object[i3] = false;
            }
        }
        return object;
    }

    @Override
    public String getGlobalVariable(String string) {
        this.initializeIfNeeded();
        ManagerResponse managerResponse = this.sendAction(new GetVarAction(string));
        if (managerResponse instanceof ManagerError) {
            return null;
        }
        String string2 = managerResponse.getAttribute("Value");
        if (string2 == null) {
            string2 = managerResponse.getAttribute(string);
        }
        return string2;
    }

    @Override
    public void setGlobalVariable(String string, String string2) {
        this.initializeIfNeeded();
        ManagerResponse managerResponse = this.sendAction(new SetVarAction(string, string2));
        if (managerResponse instanceof ManagerError) {
            this.logger.error("Unable to set global variable '" + string + "' to '" + string2 + "':" + managerResponse.getMessage());
        }
    }

    @Override
    public Collection<Voicemailbox> getVoicemailboxes() {
        this.initializeIfNeeded();
        ArrayList<Voicemailbox> arrayList = new ArrayList<Voicemailbox>();
        Object object = this.eventConnection.getVersion().isAtLeast(AsteriskVersion.ASTERISK_1_6) ? this.sendAction(new CommandAction(SHOW_VOICEMAIL_USERS_1_6_COMMAND)) : this.sendAction(new CommandAction(SHOW_VOICEMAIL_USERS_COMMAND));
        if (!(object instanceof CommandResponse)) {
            this.logger.error("Response to CommandAction(\"show voicemail users\") was not a CommandResponse but " + object);
            return arrayList;
        }
        if ((object = ((CommandResponse)object).getResult()) == null || object.size() <= 0) {
            return arrayList;
        }
        object.remove(0);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = SHOW_VOICEMAIL_USERS_PATTERN.matcher(string);
            if (!((Matcher)object).find()) continue;
            String string2 = ((Matcher)object).group(1);
            String string3 = ((Matcher)object).group(2);
            object = ((Matcher)object).group(3).trim();
            object = new Voicemailbox(string3, string2, (String)object);
            arrayList.add((Voicemailbox)object);
        }
        for (Voicemailbox voicemailbox : arrayList) {
            object = voicemailbox.getMailbox() + "@" + voicemailbox.getContext();
            if ((object = this.sendAction(new MailboxCountAction((String)object))) instanceof MailboxCountResponse) {
                object = (MailboxCountResponse)object;
                voicemailbox.setNewMessages(((MailboxCountResponse)object).getNewMessages());
                voicemailbox.setOldMessages(((MailboxCountResponse)object).getOldMessages());
                continue;
            }
            this.logger.error("Response to MailboxCountAction was not a MailboxCountResponse but " + object);
        }
        return arrayList;
    }

    @Override
    public List<String> executeCliCommand(String string) {
        this.initializeIfNeeded();
        ManagerResponse managerResponse = this.sendAction(new CommandAction(string));
        if (!(managerResponse instanceof CommandResponse)) {
            throw new ManagerCommunicationException("Response to CommandAction(\"" + string + "\") was not a CommandResponse but " + managerResponse, null);
        }
        return ((CommandResponse)managerResponse).getResult();
    }

    @Override
    public boolean isModuleLoaded(String string) {
        return this.sendAction(new ModuleCheckAction(string)) instanceof ModuleCheckResponse;
    }

    @Override
    public void loadModule(String string) {
        this.sendModuleLoadAction(string, "load");
    }

    @Override
    public void unloadModule(String string) {
        this.sendModuleLoadAction(string, "unload");
    }

    @Override
    public void reloadModule(String string) {
        this.sendModuleLoadAction(string, "reload");
    }

    @Override
    public void reloadAllModules() {
        this.sendModuleLoadAction(null, "reload");
    }

    protected void sendModuleLoadAction(String object, String string) {
        if ((object = this.sendAction(new ModuleLoadAction((String)object, string))) instanceof ManagerError) {
            object = (ManagerError)object;
            throw new ManagerCommunicationException(((ManagerResponse)object).getMessage(), null);
        }
    }

    @Override
    public ConfigFile getConfig(String string) {
        this.initializeIfNeeded();
        ManagerResponse managerResponse = this.sendAction(new GetConfigAction(string));
        if (!(managerResponse instanceof GetConfigResponse)) {
            throw new ManagerCommunicationException("Response to GetConfigAction(\"" + string + "\") was not a CommandResponse but " + managerResponse, null);
        }
        managerResponse = (GetConfigResponse)managerResponse;
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<Integer, String> entry : ((GetConfigResponse)managerResponse).getCategories().entrySet()) {
            Object object = ((GetConfigResponse)managerResponse).getLines(entry.getKey());
            object = object == null ? new ArrayList() : new ArrayList<String>(object.values());
            linkedHashMap.put(entry.getValue(), (List<String>)object);
        }
        return new ConfigFileImpl(string, linkedHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAsteriskServerListener(AsteriskServerListener asteriskServerListener) {
        this.initializeIfNeeded();
        Set<AsteriskServerListener> set = this.listeners;
        synchronized (set) {
            if (!this.listeners.contains(asteriskServerListener)) {
                this.listeners.add(asteriskServerListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAsteriskServerListener(AsteriskServerListener asteriskServerListener) {
        Set<AsteriskServerListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(asteriskServerListener);
            return;
        }
    }

    @Override
    public boolean isAsteriskServerListening(AsteriskServerListener asteriskServerListener) {
        return this.listeners.contains(asteriskServerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChainListener(ManagerEventListener managerEventListener) {
        List<ManagerEventListener> list = this.chainListeners;
        synchronized (list) {
            if (!this.chainListeners.contains(managerEventListener)) {
                this.chainListeners.add(managerEventListener);
            }
            return;
        }
    }

    @Override
    public void removeChainListener(ManagerEventListener managerEventListener) {
        this.chainListeners.remove(managerEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireNewAsteriskChannel(AsteriskChannel asteriskChannel) {
        Set<AsteriskServerListener> set = this.listeners;
        synchronized (set) {
            for (AsteriskServerListener asteriskServerListener : this.listeners) {
                try {
                    asteriskServerListener.onNewAsteriskChannel(asteriskChannel);
                }
                catch (Exception exception) {
                    this.logger.warn("Exception in onNewAsteriskChannel()", exception);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireNewMeetMeUser(MeetMeUser meetMeUser) {
        Set<AsteriskServerListener> set = this.listeners;
        synchronized (set) {
            for (AsteriskServerListener asteriskServerListener : this.listeners) {
                try {
                    asteriskServerListener.onNewMeetMeUser(meetMeUser);
                }
                catch (Exception exception) {
                    this.logger.warn("Exception in onNewMeetMeUser()", exception);
                }
            }
            return;
        }
    }

    ManagerResponse sendActionOnEventConnection(ManagerAction managerAction) {
        try {
            return this.eventConnection.sendAction(managerAction);
        }
        catch (Exception exception) {
            throw ManagerCommunicationExceptionMapper.mapSendActionException(managerAction.getAction(), exception);
        }
    }

    ManagerResponse sendAction(ManagerAction managerAction) {
        try {
            return this.eventConnection.sendAction(managerAction);
        }
        catch (Exception exception) {
            throw ManagerCommunicationExceptionMapper.mapSendActionException(managerAction.getAction(), exception);
        }
    }

    ResponseEvents sendEventGeneratingAction(EventGeneratingAction eventGeneratingAction) {
        try {
            return this.eventConnection.sendEventGeneratingAction(eventGeneratingAction);
        }
        catch (Exception exception) {
            throw ManagerCommunicationExceptionMapper.mapSendActionException(eventGeneratingAction.getAction(), exception);
        }
    }

    ResponseEvents sendEventGeneratingAction(EventGeneratingAction eventGeneratingAction, long l2) {
        try {
            return this.eventConnection.sendEventGeneratingAction(eventGeneratingAction, l2);
        }
        catch (Exception exception) {
            throw ManagerCommunicationExceptionMapper.mapSendActionException(eventGeneratingAction.getAction(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OriginateCallbackData getOriginateCallbackDataByTraceId(String string) {
        Map<String, OriginateCallbackData> map = this.originateCallbacks;
        synchronized (map) {
            return this.originateCallbacks.get(string);
        }
    }

    @Override
    public void onManagerEvent(ManagerEvent managerEvent) {
        if (managerEvent instanceof ConnectEvent) {
            this.handleConnectEvent((ConnectEvent)managerEvent);
        } else if (managerEvent instanceof DisconnectEvent) {
            this.handleDisconnectEvent((DisconnectEvent)managerEvent);
        } else if (managerEvent instanceof NewChannelEvent) {
            this.channelManager.handleNewChannelEvent((NewChannelEvent)managerEvent);
        } else if (managerEvent instanceof NewExtenEvent) {
            this.channelManager.handleNewExtenEvent((NewExtenEvent)managerEvent);
        } else if (managerEvent instanceof NewStateEvent) {
            this.channelManager.handleNewStateEvent((NewStateEvent)managerEvent);
        } else if (managerEvent instanceof NewCallerIdEvent) {
            this.channelManager.handleNewCallerIdEvent((NewCallerIdEvent)managerEvent);
        } else if (managerEvent instanceof DialEvent) {
            this.channelManager.handleDialEvent((DialEvent)managerEvent);
        } else if (managerEvent instanceof BridgeEvent) {
            this.channelManager.handleBridgeEvent((BridgeEvent)managerEvent);
        } else if (managerEvent instanceof RenameEvent) {
            this.channelManager.handleRenameEvent((RenameEvent)managerEvent);
        } else if (managerEvent instanceof HangupEvent) {
            this.channelManager.handleHangupEvent((HangupEvent)managerEvent);
        } else if (managerEvent instanceof CdrEvent) {
            this.channelManager.handleCdrEvent((CdrEvent)managerEvent);
        } else if (managerEvent instanceof VarSetEvent) {
            this.channelManager.handleVarSetEvent((VarSetEvent)managerEvent);
        } else if (managerEvent instanceof DtmfEvent) {
            this.channelManager.handleDtmfEvent((DtmfEvent)managerEvent);
        } else if (managerEvent instanceof MonitorStartEvent) {
            this.channelManager.handleMonitorStartEvent((MonitorStartEvent)managerEvent);
        } else if (managerEvent instanceof MonitorStopEvent) {
            this.channelManager.handleMonitorStopEvent((MonitorStopEvent)managerEvent);
        } else if (managerEvent instanceof ParkedCallEvent) {
            this.channelManager.handleParkedCallEvent((ParkedCallEvent)managerEvent);
        } else if (managerEvent instanceof ParkedCallGiveUpEvent) {
            this.channelManager.handleParkedCallGiveUpEvent((ParkedCallGiveUpEvent)managerEvent);
        } else if (managerEvent instanceof ParkedCallTimeOutEvent) {
            this.channelManager.handleParkedCallTimeOutEvent((ParkedCallTimeOutEvent)managerEvent);
        } else if (managerEvent instanceof UnparkedCallEvent) {
            this.channelManager.handleUnparkedCallEvent((UnparkedCallEvent)managerEvent);
        } else if (managerEvent instanceof JoinEvent) {
            this.queueManager.handleJoinEvent((JoinEvent)managerEvent);
        } else if (managerEvent instanceof LeaveEvent) {
            this.queueManager.handleLeaveEvent((LeaveEvent)managerEvent);
        } else if (managerEvent instanceof QueueMemberStatusEvent) {
            this.queueManager.handleQueueMemberStatusEvent((QueueMemberStatusEvent)managerEvent);
        } else if (managerEvent instanceof QueueMemberPenaltyEvent) {
            this.queueManager.handleQueueMemberPenaltyEvent((QueueMemberPenaltyEvent)managerEvent);
        } else if (managerEvent instanceof QueueMemberAddedEvent) {
            this.queueManager.handleQueueMemberAddedEvent((QueueMemberAddedEvent)managerEvent);
        } else if (managerEvent instanceof QueueMemberRemovedEvent) {
            this.queueManager.handleQueueMemberRemovedEvent((QueueMemberRemovedEvent)managerEvent);
        } else if (managerEvent instanceof QueueMemberPausedEvent) {
            this.queueManager.handleQueueMemberPausedEvent((QueueMemberPausedEvent)managerEvent);
        } else if (managerEvent instanceof AbstractMeetMeEvent) {
            this.meetMeManager.handleMeetMeEvent((AbstractMeetMeEvent)managerEvent);
        } else if (managerEvent instanceof OriginateResponseEvent) {
            this.handleOriginateEvent((OriginateResponseEvent)managerEvent);
        } else if (managerEvent instanceof AgentsEvent) {
            this.agentManager.handleAgentsEvent((AgentsEvent)managerEvent);
        } else if (managerEvent instanceof AgentCalledEvent) {
            this.agentManager.handleAgentCalledEvent((AgentCalledEvent)managerEvent);
        } else if (managerEvent instanceof AgentConnectEvent) {
            this.agentManager.handleAgentConnectEvent((AgentConnectEvent)managerEvent);
        } else if (managerEvent instanceof AgentCompleteEvent) {
            this.agentManager.handleAgentCompleteEvent((AgentCompleteEvent)managerEvent);
        } else if (managerEvent instanceof AgentCallbackLoginEvent) {
            this.agentManager.handleAgentCallbackLoginEvent((AgentCallbackLoginEvent)managerEvent);
        } else if (managerEvent instanceof AgentCallbackLogoffEvent) {
            this.agentManager.handleAgentCallbackLogoffEvent((AgentCallbackLogoffEvent)managerEvent);
        } else if (managerEvent instanceof AgentLoginEvent) {
            this.agentManager.handleAgentLoginEvent((AgentLoginEvent)managerEvent);
        } else if (managerEvent instanceof AgentLogoffEvent) {
            this.agentManager.handleAgentLogoffEvent((AgentLogoffEvent)managerEvent);
        }
        this.fireChainListeners(managerEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChainListeners(ManagerEvent managerEvent) {
        List<ManagerEventListener> list = this.chainListeners;
        synchronized (list) {
            Iterator<ManagerEventListener> iterator = this.chainListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onManagerEvent(managerEvent);
            }
            return;
        }
    }

    private void handleDisconnectEvent(DisconnectEvent disconnectEvent) {
        this.version = null;
        this.versions = null;
        this.channelManager.disconnected();
        this.agentManager.disconnected();
        this.meetMeManager.disconnected();
        this.queueManager.disconnected();
        this.initialized = false;
    }

    private void handleConnectEvent(ConnectEvent connectEvent) {
        try {
            this.initialize();
            return;
        }
        catch (Exception exception) {
            this.logger.error("Unable to reinitialize state after reconnection", exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOriginateEvent(OriginateResponseEvent object) {
        Object object2;
        Object object3 = ((ResponseEvent)object).getActionId();
        if (object3 == null) {
            return;
        }
        Object object4 = this.originateCallbacks;
        synchronized (object4) {
            object2 = this.originateCallbacks.get(object3);
            if (object2 == null) {
                return;
            }
            this.originateCallbacks.remove(object3);
        }
        object3 = ((OriginateCallbackData)object2).getCallback();
        object = !AstUtil.isNull(((OriginateResponseEvent)object).getUniqueId()) ? this.channelManager.getChannelImplById(((OriginateResponseEvent)object).getUniqueId()) : ((OriginateCallbackData)object2).getChannel();
        try {
            if (object == null) {
                object4 = new NoSuchChannelException("Channel '" + ((OriginateCallbackData)object2).getOriginateAction().getChannel() + "' is not available");
                object3.onFailure((LiveException)object4);
                return;
            }
            if (((AsteriskChannelImpl)object).wasInState(ChannelState.UP)) {
                object3.onSuccess((AsteriskChannel)object);
                return;
            }
            if (((AsteriskChannelImpl)object).wasBusy()) {
                object3.onBusy((AsteriskChannel)object);
                return;
            }
            object2 = this.channelManager.getOtherSideOfLocalChannel((AsteriskChannel)object);
            if (object2 != null) {
                object4 = ((AsteriskChannelImpl)object2).getDialedChannel();
                if (((AsteriskChannelImpl)object2).wasBusy()) {
                    object3.onBusy((AsteriskChannel)object);
                    return;
                }
                if (object4 != null && object4.wasBusy()) {
                    object3.onBusy((AsteriskChannel)object);
                    return;
                }
            }
            object3.onNoAnswer((AsteriskChannel)object);
            return;
        }
        catch (Throwable throwable) {
            this.logger.warn("Exception dispatching originate progress", throwable);
            return;
        }
    }

    @Override
    public void shutdown() {
        if (this.eventConnection != null && (this.eventConnection.getState() == ManagerConnectionState.CONNECTED || this.eventConnection.getState() == ManagerConnectionState.RECONNECTING)) {
            try {
                this.eventConnection.logoff();
            }
            catch (Exception exception) {}
        }
        if (this.managerEventListenerProxy != null) {
            if (this.eventConnection != null) {
                this.eventConnection.removeEventListener(this.managerEventListenerProxy);
            }
            this.managerEventListenerProxy.shutdown();
        }
        if (this.eventConnection != null && this.eventListener != null) {
            this.eventConnection.removeEventListener(this.eventListener);
        }
        this.managerEventListenerProxy = null;
        this.eventListener = null;
        if (this.initialized) {
            this.handleDisconnectEvent(null);
        }
    }

    public List<PeerEntryEvent> getPeerEntries() {
        ResponseEvents responseEvents = this.sendEventGeneratingAction(new SipPeersAction(), 2000L);
        ArrayList<PeerEntryEvent> arrayList = new ArrayList<PeerEntryEvent>(30);
        for (ResponseEvent responseEvent : responseEvents.getEvents()) {
            if (!(responseEvent instanceof PeerEntryEvent)) continue;
            arrayList.add((PeerEntryEvent)responseEvent);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public DbGetResponseEvent dbGet(String iterator, String object2) {
        void var2_4;
        iterator = this.sendEventGeneratingAction(new DbGetAction((String)((Object)iterator), (String)object2), 2000L);
        Object var2_3 = null;
        for (DbGetResponseEvent dbGetResponseEvent : iterator.getEvents()) {
        }
        return var2_4;
    }

    public void dbDel(String string, String string2) {
        this.sendAction(new CommandAction("database del " + string + " " + string2));
    }

    public void dbPut(String string, String string2, String string3) {
        this.sendAction(new DbPutAction(string, string2, string3));
    }

    public AsteriskChannel getChannelByNameAndActive(String string) {
        this.initializeIfNeeded();
        return this.channelManager.getChannelImplByNameAndActive(string);
    }

    @Override
    public Collection<AsteriskAgent> getAgents() {
        this.initializeIfNeeded();
        return this.agentManager.getAgents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireNewAgent(AsteriskAgentImpl asteriskAgentImpl) {
        Set<AsteriskServerListener> set = this.listeners;
        synchronized (set) {
            for (AsteriskServerListener asteriskServerListener : this.listeners) {
                try {
                    asteriskServerListener.onNewAgent(asteriskAgentImpl);
                }
                catch (Exception exception) {
                    this.logger.warn("Exception in onNewAgent()", exception);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireNewQueueEntry(AsteriskQueueEntry asteriskQueueEntry) {
        Set<AsteriskServerListener> set = this.listeners;
        synchronized (set) {
            for (AsteriskServerListener asteriskServerListener : this.listeners) {
                try {
                    asteriskServerListener.onNewQueueEntry(asteriskQueueEntry);
                }
                catch (Exception exception) {
                    this.logger.warn("Exception in onNewQueueEntry()", exception);
                }
            }
            return;
        }
    }
}

