/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util;

import org.asteriskjava.util.Log;
import org.asteriskjava.util.internal.JavaLoggingLog;
import org.asteriskjava.util.internal.Log4JLogger;
import org.asteriskjava.util.internal.NullLog;
import org.asteriskjava.util.internal.Slf4JLogger;

public final class LogFactory {
    private static Boolean slf4jLoggingAvailable = null;
    private static Boolean log4jLoggingAvailable = null;
    private static Boolean javaLoggingAvailable = null;
    private static ClassLoader classLoader = LogFactory.class.getClassLoader();

    public static void setClassLoader(ClassLoader classLoader) {
        LogFactory.classLoader = classLoader;
    }

    public static Log getLog(Class<?> clazz) {
        if (slf4jLoggingAvailable == null) {
            try {
                classLoader.loadClass("org.slf4j.Logger");
                slf4jLoggingAvailable = Boolean.TRUE;
            }
            catch (Exception exception) {
                slf4jLoggingAvailable = Boolean.FALSE;
            }
        }
        if (slf4jLoggingAvailable.booleanValue()) {
            try {
                return new Slf4JLogger(clazz);
            }
            catch (Throwable throwable) {
                slf4jLoggingAvailable = Boolean.FALSE;
            }
        }
        if (log4jLoggingAvailable == null) {
            try {
                classLoader.loadClass("org.apache.log4j.Logger");
                log4jLoggingAvailable = Boolean.TRUE;
            }
            catch (Exception exception) {
                log4jLoggingAvailable = Boolean.FALSE;
            }
        }
        if (log4jLoggingAvailable.booleanValue()) {
            return new Log4JLogger(clazz);
        }
        if (javaLoggingAvailable == null) {
            try {
                classLoader.loadClass("java.util.logging.Logger");
                javaLoggingAvailable = Boolean.TRUE;
            }
            catch (Exception exception) {
                javaLoggingAvailable = Boolean.FALSE;
            }
        }
        if (javaLoggingAvailable.booleanValue()) {
            return new JavaLoggingLog(clazz);
        }
        return new NullLog();
    }
}

