/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util.internal;

import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.asteriskjava.util.Log;

public class Log4JLogger
implements Serializable,
Log {
    private static final long serialVersionUID = 3545240215095883829L;
    private static final String FQCN = Log4JLogger.class.getName();
    private static final boolean IS12 = Priority.class.isAssignableFrom(Level.class);
    private transient Logger logger = null;
    private String name = null;

    public Log4JLogger() {
    }

    public Log4JLogger(Class<?> clazz) {
        this.name = clazz.getName();
        this.logger = this.getLogger();
    }

    public void trace(Object object) {
        this.getLogger().log(FQCN, (Priority)Level.DEBUG, object, null);
    }

    public void trace(Object object, Throwable throwable) {
        this.getLogger().log(FQCN, (Priority)Level.DEBUG, object, throwable);
    }

    @Override
    public void debug(Object object) {
        this.getLogger().log(FQCN, (Priority)Level.DEBUG, object, null);
    }

    public void debug(Object object, Throwable throwable) {
        this.getLogger().log(FQCN, (Priority)Level.DEBUG, object, throwable);
    }

    @Override
    public void info(Object object) {
        this.getLogger().log(FQCN, (Priority)Level.INFO, object, null);
    }

    public void info(Object object, Throwable throwable) {
        this.getLogger().log(FQCN, (Priority)Level.INFO, object, throwable);
    }

    @Override
    public void warn(Object object) {
        this.getLogger().log(FQCN, (Priority)Level.WARN, object, null);
    }

    @Override
    public void warn(Object object, Throwable throwable) {
        this.getLogger().log(FQCN, (Priority)Level.WARN, object, throwable);
    }

    @Override
    public void error(Object object) {
        this.getLogger().log(FQCN, (Priority)Level.ERROR, object, null);
    }

    @Override
    public void error(Object object, Throwable throwable) {
        this.getLogger().log(FQCN, (Priority)Level.ERROR, object, throwable);
    }

    public void fatal(Object object) {
        this.getLogger().log(FQCN, (Priority)Level.FATAL, object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        this.getLogger().log(FQCN, (Priority)Level.FATAL, object, throwable);
    }

    public final Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)this.name);
        }
        return this.logger;
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        if (IS12) {
            return this.getLogger().isEnabledFor((Priority)Level.ERROR);
        }
        return this.getLogger().isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isFatalEnabled() {
        if (IS12) {
            return this.getLogger().isEnabledFor((Priority)Level.FATAL);
        }
        return this.getLogger().isEnabledFor((Priority)Level.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        if (IS12) {
            return this.getLogger().isEnabledFor((Priority)Level.WARN);
        }
        return this.getLogger().isEnabledFor((Priority)Level.WARN);
    }
}

