/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.KeyListener;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerManager;
import org.tigris.gef.base.SelectionManager;

public class CmdReorder
extends Cmd {
    private static final long serialVersionUID = 1315160037668280033L;
    public static final int SEND_TO_BACK = 1;
    public static final int BRING_TO_FRONT = 2;
    public static final int SEND_BACKWARD = 3;
    public static final int BRING_FORWARD = 4;
    public static CmdReorder SendToBack = new CmdReorder(1);
    public static CmdReorder BringToFront = new CmdReorder(2);
    public static CmdReorder SendBackward = new CmdReorder(3);
    public static CmdReorder BringForward = new CmdReorder(4);
    private int function;

    public CmdReorder(int n2) {
        super(CmdReorder.wordFor(n2));
        this.function = n2;
    }

    protected static String wordFor(int n2) {
        switch (n2) {
            case 3: {
                return "Backward";
            }
            case 1: {
                return "ToBack";
            }
            case 4: {
                return "Forward";
            }
            case 2: {
                return "ToFront";
            }
        }
        return "";
    }

    @Override
    public void doIt() {
        KeyListener keyListener = Globals.curEditor();
        LayerManager layerManager = ((Editor)keyListener).getLayerManager();
        keyListener = ((Editor)keyListener).getSelectionManager();
        ((SelectionManager)keyListener).reorder(this.function, layerManager.getActiveLayer());
        ((SelectionManager)keyListener).endTrans();
    }

    @Override
    public void undoIt() {
        System.out.println("Connot undo CmdReorder, yet");
    }
}

