/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.util.Localizer;

public class CmdZoom
extends Cmd {
    private static final long serialVersionUID = 8472508088519383941L;
    protected double _magnitude;

    public CmdZoom() {
        this(0.0);
    }

    public CmdZoom(double d2) {
        super(CmdZoom.wordFor(d2));
        this._magnitude = d2;
    }

    protected static String wordFor(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Zoom magnitude cannot be less than 0");
        }
        if (d2 == 0.0) {
            return Localizer.localize("GefBase", "ZoomReset");
        }
        if (d2 > 1.0) {
            return Localizer.localize("GefBase", "ZoomIn");
        }
        if (d2 < 1.0) {
            return Localizer.localize("GefBase", "ZoomOut");
        }
        return Localizer.localize("GefBase", "DoNothing");
    }

    @Override
    public void doIt() {
        Editor editor = Globals.curEditor();
        if (editor == null) {
            return;
        }
        if (this._magnitude > 0.0) {
            editor.setScale(editor.getScale() * this._magnitude);
        } else {
            editor.setScale(1.0);
        }
        editor.damageAll();
    }

    @Override
    public void undoIt() {
        Editor editor = Globals.curEditor();
        if (editor == null) {
            return;
        }
        if (this._magnitude > 0.0) {
            editor.setScale(editor.getScale() / this._magnitude);
            return;
        }
        System.out.println("Cannot undo CmdZoom reset, yet.");
    }
}

