/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class NudgeAction
extends UndoableAction {
    private static final long serialVersionUID = 2121611741541853360L;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    private int _direction;
    private int _magnitude;

    public NudgeAction(int n2) {
        this(n2, 1);
    }

    public NudgeAction(int n2, int n3) {
        super(Localizer.localize("GefBase", "Nudge" + NudgeAction.wordFor(n2)));
        this._direction = n2;
        this._magnitude = n3;
    }

    protected static String wordFor(int n2) {
        switch (n2) {
            case 1: {
                return "Left";
            }
            case 2: {
                return "Right";
            }
            case 3: {
                return "Up";
            }
            case 4: {
                return "Down";
            }
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent serializable) {
        super.actionPerformed((ActionEvent)serializable);
        serializable = Globals.curEditor().getSelectionManager();
        if (((SelectionManager)serializable).getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            return;
        }
        int n2 = 0;
        int n3 = 0;
        switch (this._direction) {
            case 1: {
                n2 = 0 - this._magnitude;
                break;
            }
            case 2: {
                n2 = this._magnitude;
                break;
            }
            case 3: {
                n3 = 0 - this._magnitude;
                break;
            }
            case 4: {
                n3 = this._magnitude;
            }
        }
        ((SelectionManager)serializable).translate(n2, n3);
        MutableGraphSupport.enableSaveAction();
        ((SelectionManager)serializable).endTrans();
    }

    public void undoIt() {
        System.out.println("Cannot undo CmdNudge, yet.");
    }
}

