/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.graph.presentation.JGraphFrame;
import org.tigris.gef.persistence.pgml.PGMLStackParser;
import org.tigris.gef.util.Localizer;
import org.tigris.gef.util.Util;
import org.xml.sax.SAXException;

public class OpenPGMLAction
extends AbstractAction
implements FilenameFilter {
    private Dimension dimension;
    static final long serialVersionUID = 0L;

    public OpenPGMLAction(String string) {
        this(string, null, false);
    }

    public OpenPGMLAction(String string, Dimension dimension) {
        this(string, dimension, false);
    }

    public OpenPGMLAction(String string, Icon icon) {
        this(string, icon, null, false);
    }

    public OpenPGMLAction(String string, Icon icon, Dimension dimension) {
        this(string, icon, dimension, false);
    }

    public OpenPGMLAction(String string, Dimension dimension, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string);
        this.dimension = dimension;
    }

    public OpenPGMLAction(String string, Icon icon, Dimension dimension, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string, icon);
        this.dimension = dimension;
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        object = Globals.curEditor();
        object = new FileDialog(((Editor)object).findFrame(), "Open...", 0);
        ((FileDialog)object).setFilenameFilter(this);
        ((FileDialog)object).setDirectory(Globals.getLastDirectory());
        ((Dialog)object).setVisible(true);
        String string = ((FileDialog)object).getFile();
        object = ((FileDialog)object).getDirectory();
        Globals.setLastDirectory((String)object);
        if (string != null) {
            try {
                Globals.showStatus("Reading " + (String)object + string + "...");
                Serializable serializable = Util.fileToURL(new File((String)object + string));
                serializable = new PGMLStackParser(null).readDiagram(serializable.openStream(), false);
                serializable = new Editor((Diagram)serializable);
                Globals.showStatus("Read " + (String)object + string);
                object = new JGraphFrame((String)object + string, (Editor)serializable);
                if (this.dimension != null) {
                    ((Window)object).setSize(this.dimension);
                }
                ((JGraphFrame)object).setVisible(true);
                return;
            }
            catch (SAXException sAXException) {
                System.out.println("bad URL");
                return;
            }
            catch (IOException iOException) {
                System.out.println("IOExcept in openpgml");
            }
        }
    }

    @Override
    public boolean accept(File file, String string) {
        return true;
    }
}

